/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.UniKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.FullStringKeyType;
import com.alexbarter.ciphertool.lib.MorseCode;
import com.alexbarter.lib.util.ArrayUtil;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class FractionatedMorseCipher
extends UniKeyCipher<String, FullStringKeyType.Builder> {
    private static List<Character> list = Arrays.asList(Character.valueOf('.'), Character.valueOf('-'), Character.valueOf('X'));

    public FractionatedMorseCipher() {
        super((IKeyType.IKeyBuilder)FullStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ"));
    }

    public CharSequence encode(CharSequence plainText, String key) {
        StringBuilder cipherText = new StringBuilder(plainText.length());
        Object morseText = MorseCode.getMorseEquivalent((CharSequence)plainText);
        while (((String)morseText).length() % 3 != 0) {
            morseText = (String)morseText + "X";
        }
        for (int i = 0; i < ((String)morseText).length(); i += 3) {
            int a = list.indexOf(Character.valueOf(((String)morseText).charAt(i)));
            int b = list.indexOf(Character.valueOf(((String)morseText).charAt(i + 1)));
            int c = list.indexOf(Character.valueOf(((String)morseText).charAt(i + 2)));
            cipherText.append(key.charAt(a * 9 + b * 3 + c));
        }
        return cipherText;
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, String key) {
        char[] morseText = new char[cipherText.length() * 3];
        plainText = new char[cipherText.length() * 3];
        for (int i = 0; i < cipherText.length(); ++i) {
            int index = key.indexOf(cipherText.charAt(i));
            morseText[i * 3] = list.get(index / 9).charValue();
            morseText[i * 3 + 1] = list.get(index / 3 % 3).charValue();
            morseText[i * 3 + 2] = list.get(index % 3).charValue();
        }
        int index = 0;
        int lastX = 0;
        for (int i = 0; i < morseText.length; ++i) {
            boolean end;
            char morseCh = morseText[i];
            boolean isX = morseCh == 'X';
            boolean bl = end = i == morseText.length - 1;
            if (!isX && !end) continue;
            int length = i - lastX + (end && !isX ? 1 : 0);
            if (length > 0) {
                Character character = MorseCode.getCharFromMorse((char[])morseText, (int)lastX, (int)length);
                if (character == null) {
                    for (int j = lastX; j < i; ++j) {
                        plainText[index++] = morseText[j];
                    }
                } else {
                    plainText[index++] = character.charValue();
                }
            }
            if (isX && i < morseText.length - 2 && morseText[i + 1] == 'X') {
                plainText[index++] = 32;
                ++i;
            }
            lastX = i + 1;
        }
        return ArrayUtil.copyRange((char[])plainText, (int)0, (int)index);
    }
}

