/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.TriKey;
import com.alexbarter.ciphertool.base.ciphers.TriKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.IntegerKeyType;
import com.alexbarter.ciphertool.base.key.types.SquareStringKeyType;
import com.alexbarter.ciphertool.lib.characters.CharacterArrayWrapper;
import javax.annotation.Nullable;

public class DigrafidCipher
extends TriKeyCipher<String, String, Integer, SquareStringKeyType.Builder, SquareStringKeyType.Builder, IntegerKeyType.Builder> {
    public DigrafidCipher() {
        super((IKeyType.IKeyBuilder)SquareStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ#").setDim(3, 9), (IKeyType.IKeyBuilder)SquareStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ#").setDim(9, 3), (IKeyType.IKeyBuilder)IntegerKeyType.builder().setRange(2, Integer.MAX_VALUE));
    }

    public IntegerKeyType.Builder limitDomainForThirdKey(IntegerKeyType.Builder thirdKey) {
        return thirdKey.setRange(2, 15);
    }

    public CharSequence normaliseText(CharSequence plainText, TriKey<String, String, Integer> key) {
        if (plainText.length() % 2 == 1) {
            StringBuilder builder = new StringBuilder(plainText.length() + 1);
            builder.append(plainText);
            builder.append('X');
            return builder;
        }
        return plainText;
    }

    public CharSequence encode(CharSequence plainText, TriKey<String, String, Integer> key) {
        int fractionation = (Integer)key.getThirdKey();
        if (fractionation == 0) {
            fractionation = plainText.length() / 2;
        }
        int period = fractionation * 2;
        int[] numberText = new int[plainText.length() * 3 / 2];
        int blocks = (int)Math.ceil((double)plainText.length() / (double)period);
        int index = 0;
        Character[] cipherText = new Character[plainText.length()];
        for (int b = 0; b < blocks; ++b) {
            int f;
            int min = Math.min(fractionation, (plainText.length() - b * period) / 2);
            for (f = 0; f < min; ++f) {
                int cTIndex = b * period + f * 2;
                int index1 = ((String)key.getFirstKey()).indexOf(plainText.charAt(cTIndex));
                int index2 = ((String)key.getSecondKey()).indexOf(plainText.charAt(cTIndex + 1));
                numberText[b * fractionation * 3 + f] = index1 % 9;
                numberText[b * fractionation * 3 + min + f] = index1 / 9 * 3 + index2 % 3;
                numberText[b * fractionation * 3 + min * 2 + f] = index2 / 3;
            }
            for (f = 0; f < min; ++f) {
                int n1 = numberText[b * fractionation * 3 + f * 3];
                int n2 = numberText[b * fractionation * 3 + f * 3 + 1];
                int n3 = numberText[b * fractionation * 3 + f * 3 + 2];
                cipherText[index++] = Character.valueOf(((String)key.getFirstKey()).charAt(n1 + n2 / 3 * 9));
                cipherText[index++] = Character.valueOf(((String)key.getSecondKey()).charAt(n3 * 3 + n2 % 3));
            }
        }
        return new CharacterArrayWrapper(cipherText);
    }

    public char[] decodeEfficiently(CharSequence cipherText, @Nullable char[] plainText, TriKey<String, String, Integer> key) {
        int fractionation = (Integer)key.getThirdKey();
        byte[] numberText = new byte[cipherText.length() * 3 / 2];
        if (fractionation == 0) {
            fractionation = cipherText.length() / 2;
        }
        int period = fractionation * 2;
        int blocks = (int)Math.ceil((double)cipherText.length() / (double)period);
        int indexNo = 0;
        int index = 0;
        for (int b = 0; b < blocks; ++b) {
            int f;
            int min = Math.min(fractionation, (cipherText.length() - b * period) / 2);
            for (f = 0; f < min; ++f) {
                int cTIndex = b * period + f * 2;
                int index1 = ((String)key.getFirstKey()).indexOf(cipherText.charAt(cTIndex));
                int index2 = ((String)key.getSecondKey()).indexOf(cipherText.charAt(cTIndex + 1));
                numberText[indexNo++] = (byte)(index1 % 9);
                numberText[indexNo++] = (byte)(index1 / 9 * 3 + index2 % 3);
                numberText[indexNo++] = (byte)(index2 / 3);
            }
            for (f = 0; f < min; ++f) {
                byte n1 = numberText[b * fractionation * 3 + f];
                byte n2 = numberText[b * fractionation * 3 + min + f];
                byte n3 = numberText[b * fractionation * 3 + min * 2 + f];
                plainText[index++] = ((String)key.getFirstKey()).charAt(n1 + n2 / 3 * 9);
                plainText[index++] = ((String)key.getSecondKey()).charAt(n3 * 3 + n2 % 3);
            }
        }
        return plainText;
    }
}

