/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.BiKey;
import com.alexbarter.ciphertool.base.ciphers.BiKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.SquareStringKeyType;
import javax.annotation.Nullable;

public class TwoSquareCipher
extends BiKeyCipher<String, String, SquareStringKeyType.Builder, SquareStringKeyType.Builder> {
    public TwoSquareCipher() {
        super((IKeyType.IKeyBuilder)SquareStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIKLMNOPQRSTUVWXYZ").setDim(5, 5), (IKeyType.IKeyBuilder)SquareStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIKLMNOPQRSTUVWXYZ").setDim(5, 5));
    }

    public CharSequence normaliseText(CharSequence plainText, BiKey<String, String> key) {
        StringBuilder builder = new StringBuilder(plainText.length());
        for (int i = 0; i < plainText.length(); ++i) {
            char c = plainText.charAt(i);
            builder.append(c == 'J' ? (char)'I' : (char)c);
        }
        if (builder.length() % 2 == 1) {
            builder.append('X');
        }
        return builder;
    }

    public CharSequence encode(CharSequence plainText, BiKey<String, String> key) {
        StringBuilder cipherText = new StringBuilder(plainText.length());
        for (int i = 0; i < plainText.length(); i += 2) {
            char a = plainText.charAt(i);
            char b = plainText.charAt(i + 1);
            int aIndex = ((String)key.getFirstKey()).indexOf(a);
            int bIndex = ((String)key.getSecondKey()).indexOf(b);
            int aRow = (int)Math.floor(aIndex / 5);
            int bRow = (int)Math.floor(bIndex / 5);
            int aCol = aIndex % 5;
            int bCol = bIndex % 5;
            if (aRow == bRow) {
                cipherText.append(b);
                cipherText.append(a);
                continue;
            }
            cipherText.append(((String)key.getSecondKey()).charAt(5 * aRow + bCol));
            cipherText.append(((String)key.getFirstKey()).charAt(5 * bRow + aCol));
        }
        return cipherText;
    }

    public char[] decodeEfficently(CharSequence cipherText, @Nullable char[] plainText, BiKey<String, String> key) {
        for (int i = 0; i < cipherText.length(); i += 2) {
            char a = cipherText.charAt(i);
            char b = cipherText.charAt(i + 1);
            int aIndex = ((String)key.getSecondKey()).indexOf(a);
            int bIndex = ((String)key.getFirstKey()).indexOf(b);
            int aRow = (int)Math.floor(aIndex / 5);
            int bRow = (int)Math.floor(bIndex / 5);
            int aCol = aIndex % 5;
            int bCol = bIndex % 5;
            if (aRow == bRow) {
                plainText[i] = b;
                plainText[i + 1] = a;
                continue;
            }
            plainText[i] = ((String)key.getFirstKey()).charAt(5 * aRow + bCol);
            plainText[i + 1] = ((String)key.getSecondKey()).charAt(5 * bRow + aCol);
        }
        return plainText;
    }
}

