/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.TriKey;
import com.alexbarter.ciphertool.base.ciphers.TriKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.SquareStringKeyType;
import com.alexbarter.lib.util.RandomUtil;
import javax.annotation.Nullable;

public class TriSquareCipher
extends TriKeyCipher<String, String, String, SquareStringKeyType.Builder, SquareStringKeyType.Builder, SquareStringKeyType.Builder> {
    public TriSquareCipher() {
        super((IKeyType.IKeyBuilder)SquareStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIKLMNOPQRSTUVWXYZ").setDim(5, 5), (IKeyType.IKeyBuilder)SquareStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIKLMNOPQRSTUVWXYZ").setDim(5, 5), (IKeyType.IKeyBuilder)SquareStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIKLMNOPQRSTUVWXYZ").setDim(5, 5));
    }

    public CharSequence normaliseText(CharSequence plainText, TriKey<String, String, String> key) {
        StringBuilder builder = new StringBuilder(plainText.length());
        for (int i = 0; i < plainText.length(); ++i) {
            char c = plainText.charAt(i);
            builder.append(c == 'J' ? (char)'I' : (char)c);
        }
        if (builder.length() % 2 == 1) {
            builder.append('X');
        }
        return builder;
    }

    public CharSequence encode(CharSequence plainText, TriKey<String, String, String> key) {
        StringBuilder cipherText = new StringBuilder(plainText.length() * 3 / 2);
        for (int i = 0; i < plainText.length() / 2; ++i) {
            char a = plainText.charAt(i * 2);
            char b = plainText.charAt(i * 2 + 1);
            int column1 = ((String)key.getFirstKey()).indexOf(a) % 5;
            int row1 = ((String)key.getFirstKey()).indexOf(a) / 5;
            int row2 = ((String)key.getSecondKey()).indexOf(b) / 5;
            int column2 = ((String)key.getSecondKey()).indexOf(b) % 5;
            cipherText.append(((String)key.getFirstKey()).charAt(5 * RandomUtil.pickRandomInt((int)5) + column1));
            cipherText.append(((String)key.getThirdKey()).charAt(5 * row1 + column2));
            cipherText.append(((String)key.getSecondKey()).charAt(5 * row2 + RandomUtil.pickRandomInt((int)5)));
        }
        return cipherText;
    }

    public char[] decodeEfficently(CharSequence cipherText, TriKey<String, String, String> key) {
        return this.decodeEfficently(cipherText, new char[cipherText.length() / 3 * 2], key);
    }

    public char[] decodeEfficently(CharSequence cipherText, @Nullable char[] plainText, TriKey<String, String, String> key) {
        for (int i = 0; i < cipherText.length() / 3; ++i) {
            char a = cipherText.charAt(i * 3);
            char b = cipherText.charAt(i * 3 + 1);
            char c = cipherText.charAt(i * 3 + 2);
            int column = ((String)key.getFirstKey()).indexOf(a) % 5;
            int row = ((String)key.getSecondKey()).indexOf(c) / 5;
            int index = ((String)key.getThirdKey()).indexOf(b);
            int columnSort = index % 5;
            int rowSort = index / 5;
            plainText[i * 2] = ((String)key.getFirstKey()).charAt(rowSort * 5 + column);
            plainText[i * 2 + 1] = ((String)key.getSecondKey()).charAt(row * 5 + columnSort);
        }
        return plainText;
    }

    public boolean deterministic() {
        return false;
    }
}

