/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.UniKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.OrderedIntegerKeyType;
import com.alexbarter.ciphertool.ciphers.solitaire.Solitaire;
import javax.annotation.Nullable;

public class SolitaireCipher
extends UniKeyCipher<Integer[], OrderedIntegerKeyType.Builder> {
    public SolitaireCipher() {
        super((IKeyType.IKeyBuilder)OrderedIntegerKeyType.builder().setRange(54, 54));
    }

    public CharSequence encode(CharSequence plainText, Integer[] key) {
        Object cipherText = "";
        int index = 0;
        while (index < plainText.length()) {
            int topCard = (key = Solitaire.nextCardOrder(key))[0];
            int keyStreamNumber = !Solitaire.isJoker(topCard) ? key[topCard + 1].intValue() : key[key.length - 1].intValue();
            if (Solitaire.isJoker(keyStreamNumber)) continue;
            cipherText = (String)cipherText + (char)((plainText.charAt(index) - 65 + (keyStreamNumber + 1)) % 26 + 65);
            ++index;
        }
        return cipherText;
    }

    public char[] decodeEfficently(CharSequence cipherText, @Nullable char[] plainText, Integer[] key) {
        int index = 0;
        for (int i = 0; i < index; ++i) {
            plainText[i] = cipherText.charAt(i);
        }
        while (index < cipherText.length()) {
            int topCard = (key = Solitaire.nextCardOrder(key))[0];
            int keyStreamNumber = !Solitaire.isJoker(topCard) ? key[topCard + 1].intValue() : key[key.length - 1].intValue();
            if (Solitaire.isJoker(keyStreamNumber)) continue;
            plainText[index] = (char)((52 + (cipherText.charAt(index) - 65) - (keyStreamNumber + 1)) % 26 + 65);
            ++index;
        }
        return plainText;
    }
}

