/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.UniKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.VariableStringKeyType;
import com.alexbarter.ciphertool.util.VigenereType;
import java.util.Arrays;
import javax.annotation.Nullable;

public class SlidefairCipher
extends UniKeyCipher<String, VariableStringKeyType.Builder> {
    private VigenereType type;

    public SlidefairCipher(VigenereType type) {
        super((IKeyType.IKeyBuilder)VariableStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ").setRange(2, Integer.MAX_VALUE));
        this.type = type;
    }

    public VariableStringKeyType.Builder limitDomainForFirstKey(VariableStringKeyType.Builder secondKey) {
        return secondKey.setRange(2, 15);
    }

    public CharSequence encode(CharSequence plainText, String key) {
        int i;
        StringBuilder cipherText = new StringBuilder(plainText.length());
        Object[] keyAlpha = new String[key.length()];
        Arrays.fill(keyAlpha, "");
        for (i = 0; i < key.length(); ++i) {
            for (int k = 0; k < 26; ++k) {
                int n = i;
                keyAlpha[n] = (String)keyAlpha[n] + this.type.encode((char)(k + 65), key.charAt(i));
            }
        }
        for (i = 0; i < plainText.length() / 2; ++i) {
            char a = plainText.charAt(i * 2);
            char b = plainText.charAt(i * 2 + 1);
            Object alpha = keyAlpha[i % key.length()];
            int index = ((String)alpha).indexOf(b);
            if (a - 65 == index) {
                cipherText.append((char)((index + 1) % 26 + 65));
                cipherText.append(((String)alpha).charAt((index + 1) % 26));
                continue;
            }
            cipherText.append((char)(index + 65));
            cipherText.append(((String)alpha).charAt(a - 65));
        }
        return cipherText;
    }

    public char[] decodeEfficently(CharSequence cipherText, @Nullable char[] plainText, String key) {
        int i;
        char[][] keyAlpha = new char[key.length()][26];
        byte[][] keyAlphaIndex = new byte[key.length()][26];
        for (i = 0; i < key.length(); ++i) {
            for (int k = 0; k < 26; k = (int)((byte)(k + 1))) {
                char a;
                keyAlpha[i][k] = a = this.type.encode((char)(k + 65), key.charAt(i));
                keyAlphaIndex[i][a - 65] = k;
            }
        }
        for (i = 0; i < cipherText.length() / 2; ++i) {
            char a = cipherText.charAt(i * 2);
            char b = cipherText.charAt(i * 2 + 1);
            char[] alpha = keyAlpha[i % key.length()];
            byte index = keyAlphaIndex[i % key.length()][b - 65];
            if (a - 65 == index) {
                plainText[i * 2] = (char)((index + 25) % 26 + 65);
                plainText[i * 2 + 1] = alpha[(index + 25) % 26];
                continue;
            }
            plainText[i * 2] = (char)(index + 65);
            plainText[i * 2 + 1] = alpha[a - 65];
        }
        return plainText;
    }
}

