/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.BiKey;
import com.alexbarter.ciphertool.base.interfaces.ICipher;
import com.alexbarter.ciphertool.base.key.types.IntegerKeyType;
import com.alexbarter.ciphertool.ciphers.RedefenceCipher;
import com.alexbarter.lib.util.RandomUtil;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.function.Function;
import javax.annotation.Nullable;

public class RailFenceCipher
implements ICipher<BiKey<Integer, Integer>> {
    protected final IntegerKeyType firstType;
    private IntegerKeyType firstTypeLimit;
    private final IntegerKeyType.Builder firstKeyBuilder;

    public RailFenceCipher() {
        IntegerKeyType.Builder firstKey = IntegerKeyType.builder().setRange(2, 0x3FFFFFFD);
        this.firstType = firstKey.create();
        this.firstTypeLimit = firstKey.setRange(2, 50).create();
        this.firstKeyBuilder = firstKey;
    }

    public boolean isValid(BiKey<Integer, Integer> key) {
        return this.firstType.isValid((Integer)key.getFirstKey()) && 0 <= (Integer)key.getSecondKey() && (Integer)key.getSecondKey() < ((Integer)key.getFirstKey() - 1) * 2;
    }

    public BiKey<Integer, Integer> randomiseKey() {
        int rails = this.firstTypeLimit.randomise();
        return BiKey.of((Object)rails, (Object)RandomUtil.pickRandomInt((int)0, (int)((rails - 1) * 2 - 1)));
    }

    public boolean iterateKeys(Function<BiKey<Integer, Integer>, Boolean> consumer) {
        return this.firstTypeLimit.iterateKeys(f -> {
            for (int s = 0; s < (f - 1) * 2; ++s) {
                if (((Boolean)consumer.apply(BiKey.of((Object)f, (Object)s))).booleanValue()) continue;
                return false;
            }
            return true;
        });
    }

    public BiKey<Integer, Integer> alterKey(BiKey<Integer, Integer> key, double temp, int count) {
        return key;
    }

    public BigInteger getNumOfKeys() {
        BigInteger total = BigInteger.ZERO;
        for (int i = this.firstTypeLimit.getMin(); i <= this.firstTypeLimit.getMax(); ++i) {
            total = total.add(BigInteger.valueOf(i).subtract(BigInteger.ONE).multiply(BigInteger.valueOf(2L)));
        }
        return total;
    }

    public String prettifyKey(BiKey<Integer, Integer> key) {
        return String.join((CharSequence)" ", this.firstType.prettifyKey((Object)((Integer)key.getFirstKey())), String.valueOf(key.getSecondKey()));
    }

    public BiKey<Integer, Integer> parseKey(String input) throws ParseException {
        String[] split = input.split(" ");
        if (split.length != 2) {
            throw new ParseException(input, 0);
        }
        return BiKey.of((Object)this.firstType.parse(split[0]), (Object)this.firstType.parse(split[1]));
    }

    public void limitDomainForFirstKey(Function<IntegerKeyType.Builder, IntegerKeyType.Builder> firstKeyFunc) {
        this.firstTypeLimit = firstKeyFunc.apply(this.firstKeyBuilder).create();
    }

    public IntegerKeyType getFirstKeyType() {
        return this.firstTypeLimit;
    }

    public CharSequence encode(CharSequence plainText, BiKey<Integer, Integer> key) {
        return RedefenceCipher.encodeGeneral(plainText, (Integer)key.getFirstKey(), (Integer)key.getSecondKey(), i -> i);
    }

    public char[] decodeEfficently(CharSequence cipherText, @Nullable char[] plainText, BiKey<Integer, Integer> key) {
        return RedefenceCipher.decodeGeneral(cipherText, plainText, (Integer)key.getFirstKey(), (Integer)key.getSecondKey(), i -> i);
    }
}

