/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.UniKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.VariableStringKeyType;
import javax.annotation.Nullable;

public class MyszkowskiCipher
extends UniKeyCipher<String, VariableStringKeyType.Builder> {
    public MyszkowskiCipher() {
        super((IKeyType.IKeyBuilder)VariableStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ").setRange(2, Integer.MAX_VALUE).setRepeats());
    }

    public VariableStringKeyType.Builder limitDomainForFirstKey(VariableStringKeyType.Builder firstKey) {
        return firstKey.setRange(2, 15);
    }

    public CharSequence encode(CharSequence plainText, String key) {
        StringBuilder cipherText = new StringBuilder(plainText.length());
        int rows = (int)Math.ceil((double)plainText.length() / (double)key.length());
        for (char c = 'A'; c <= 'Z'; c = (char)((char)(c + 1))) {
            if (key.indexOf(c) == -1) continue;
            for (int row = 0; row < rows; ++row) {
                for (int i = 0; i < key.length(); ++i) {
                    if (c != key.charAt(i) || row * key.length() + i >= plainText.length()) continue;
                    cipherText.append(plainText.charAt(row * key.length() + i));
                }
            }
        }
        return cipherText;
    }

    public char[] decodeEfficently(CharSequence cipherText, @Nullable char[] plainText, String key) {
        int rows = (int)Math.ceil((double)cipherText.length() / (double)key.length());
        int index = 0;
        for (char c = 'A'; c <= 'Z'; c = (char)((char)(c + 1))) {
            if (key.indexOf(c) == -1) continue;
            for (int row = 0; row < rows; ++row) {
                for (int i = 0; i < key.length(); ++i) {
                    if (c != key.charAt(i) || row * key.length() + i >= cipherText.length()) continue;
                    plainText[row * key.length() + i] = cipherText.charAt(index++);
                }
            }
        }
        return plainText;
    }
}

