/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.UniKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.FullStringKeyType;
import com.alexbarter.ciphertool.lib.characters.CharacterArrayWrapper;
import javax.annotation.Nullable;

public class KeywordCipher
extends UniKeyCipher<String, FullStringKeyType.Builder> {
    public KeywordCipher() {
        this("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    }

    public KeywordCipher(CharSequence alphabet) {
        super((IKeyType.IKeyBuilder)FullStringKeyType.builder().setAlphabet(alphabet));
    }

    public CharSequence encode(CharSequence plainText, String key) {
        Character[] cipherText = new Character[plainText.length()];
        for (int i = 0; i < plainText.length(); ++i) {
            char ch = plainText.charAt(i);
            if (ch < 'A' || ch > 'Z') continue;
            cipherText[i] = Character.valueOf(key.charAt(ch - 65));
        }
        return new CharacterArrayWrapper(cipherText);
    }

    public char[] decodeEfficently(CharSequence cipherText, @Nullable char[] plainText, String key) {
        for (int i = 0; i < cipherText.length(); ++i) {
            plainText[i] = (char)(key.indexOf(cipherText.charAt(i)) + 65);
        }
        return plainText;
    }
}

