/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.ciphers;

import com.alexbarter.ciphertool.base.ciphers.BiKey;
import com.alexbarter.ciphertool.base.ciphers.BiKeyCipher;
import com.alexbarter.ciphertool.base.interfaces.IKeyType;
import com.alexbarter.ciphertool.base.key.types.FullStringKeyType;
import com.alexbarter.ciphertool.base.key.types.SquareMatrixKeyType;
import com.alexbarter.ciphertool.ciphers.KeywordCipher;
import com.alexbarter.ciphertool.lib.characters.CharArrayWrapper;
import com.alexbarter.ciphertool.lib.matrix.Matrix;
import javax.annotation.Nullable;

public class HillSubstitutionCipher
extends BiKeyCipher<Matrix, String, SquareMatrixKeyType.Builder, FullStringKeyType.Builder> {
    private KeywordCipher keywordCipher = new KeywordCipher();

    public HillSubstitutionCipher() {
        super((IKeyType.IKeyBuilder)SquareMatrixKeyType.builder(), (IKeyType.IKeyBuilder)FullStringKeyType.builder().setAlphabet((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZ"));
    }

    public CharSequence normaliseText(CharSequence plainText, BiKey<Matrix, String> key) {
        int blockSize = ((Matrix)key.getFirstKey()).size();
        if (plainText.length() % blockSize != 0) {
            StringBuilder builder = new StringBuilder(plainText.length() + blockSize - plainText.length() % blockSize);
            builder.append(plainText);
            while (builder.length() % blockSize != 0) {
                builder.append('X');
            }
            return builder;
        }
        return plainText;
    }

    public CharSequence encode(CharSequence plainText, BiKey<Matrix, String> key) {
        char[] cipherText = new char[plainText.length()];
        int size = ((Matrix)key.getFirstKey()).size();
        plainText = this.keywordCipher.encode(plainText, (String)key.getSecondKey());
        for (int i = 0; i < plainText.length(); i += size) {
            Integer[] let = new Integer[size];
            for (int j = 0; j < size; ++j) {
                let[j] = plainText.charAt(i + j) - 65;
            }
            Matrix plainMatrix = new Matrix(let, size, 1);
            Matrix cipherMatrix = ((Matrix)key.getFirstKey()).multiply(plainMatrix).modular(26);
            for (int j = 0; j < size; ++j) {
                cipherText[i + j] = (char)(cipherMatrix.data[j] + 65);
            }
        }
        return new CharArrayWrapper(cipherText);
    }

    public char[] decodeEfficently(CharSequence cipherText, @Nullable char[] plainText, BiKey<Matrix, String> key) {
        return this.decodeUsingInverse(cipherText, plainText, ((Matrix)key.getFirstKey()).inverseMod(26), (String)key.getSecondKey());
    }

    public char[] decodeUsingInverse(CharSequence cipherText, char[] plainText, Matrix inverseKey, String secondKey) {
        int size = inverseKey.size();
        for (int i = 0; i < cipherText.length(); i += size) {
            Integer[] let = new Integer[size];
            for (int j = 0; j < size; ++j) {
                let[j] = cipherText.charAt(i + j) - 65;
            }
            Matrix cipherMatrix = new Matrix(let, size, 1);
            Matrix plainMatrix = inverseKey.multiply(cipherMatrix).modular(26);
            for (int j = 0; j < size; ++j) {
                plainText[i + j] = (char)(plainMatrix.data[j] + 65);
            }
        }
        plainText = this.keywordCipher.decodeEfficently((CharSequence)new CharArrayWrapper(plainText), plainText, secondKey);
        return plainText;
    }
}

