/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.base.key.types;

import com.alexbarter.ciphertool.base.key.IRangedKeyType;
import com.alexbarter.ciphertool.base.key.KeyGeneration;
import com.alexbarter.ciphertool.base.key.KeyIterator;
import com.alexbarter.ciphertool.base.key.KeyManipulation;
import com.alexbarter.ciphertool.lib.characters.CharSequenceUtils;
import com.alexbarter.lib.util.MathUtil;
import com.alexbarter.lib.util.RandomUtil;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

public class VariableStringKeyType
implements IRangedKeyType<String> {
    private final int min;
    private final int max;
    private final CharSequence alphabet;
    private final boolean repeats;

    private VariableStringKeyType(CharSequence alphabet, int min, int max, boolean repeats) {
        this.alphabet = alphabet;
        this.min = min;
        this.max = max;
        this.repeats = repeats;
    }

    @Override
    public String randomise() {
        BiFunction<CharSequence, Integer, String> func = this.repeats ? KeyGeneration::createRepeatingShortKeyUniversal : KeyGeneration::createDistinctKeyUniversal;
        return func.apply(this.alphabet, RandomUtil.pickRandomInt((int)this.min, (int)this.max));
    }

    @Override
    public boolean isValid(String key) {
        if (!this.repeats && key.length() > this.alphabet.length()) {
            return false;
        }
        for (int i = 0; i < key.length(); ++i) {
            if (!CharSequenceUtils.contains((CharSequence)this.alphabet, (char)key.charAt(i))) {
                return false;
            }
            if (this.repeats || i >= key.length() - 1 || !CharSequenceUtils.contains((CharSequence)key, (int)(i + 1), (int)key.length(), (char)key.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean iterateKeys(Function<String, Boolean> consumer) {
        for (int length = this.min; length <= this.max; ++length) {
            if (KeyIterator.iterateShortCustomKey(consumer, this.alphabet, length, this.repeats)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String alterKey(String key) {
        return new String(KeyManipulation.changeCharacters(key.toCharArray(), this.alphabet, this.repeats));
    }

    @Override
    public BigInteger getNumOfKeys() {
        BigInteger total = BigInteger.ZERO;
        for (int length = this.min; length <= this.max; ++length) {
            total = this.repeats ? total.add(BigInteger.valueOf(this.alphabet.length()).pow(length)) : total.add(MathUtil.factorialLength((BigInteger)BigInteger.valueOf(this.alphabet.length()), (BigInteger)BigInteger.valueOf(length)));
        }
        return total;
    }

    @Override
    public String parse(String input) throws ParseException {
        input = input.toUpperCase(Locale.ROOT);
        for (int i = 0; i < input.length(); ++i) {
            if (CharSequenceUtils.contains((CharSequence)this.alphabet, (char)input.charAt(i))) continue;
            throw new ParseException("The key can not contain the letter: " + input.charAt(i), i);
        }
        return input;
    }

    @Override
    public String getHelp() {
        return "keyword";
    }

    @Override
    public int getMin() {
        return this.min;
    }

    @Override
    public int getMax() {
        return this.max;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements IRangedKeyType.IRangedKeyBuilder<String> {
        private Optional<CharSequence> alphabet = Optional.empty();
        private Optional<Integer> min = Optional.empty();
        private Optional<Integer> max = Optional.empty();
        private boolean repeats = false;

        private Builder() {
        }

        public Builder setAlphabet(CharSequence alphabet) {
            this.alphabet = Optional.of(alphabet);
            return this;
        }

        public Builder setMin(int min) {
            this.min = Optional.of(min);
            return this;
        }

        public Builder setMax(int max) {
            this.max = Optional.of(max);
            return this;
        }

        public Builder setRange(int min, int max) {
            return this.setMin(min).setMax(max);
        }

        public Builder setSize(int size) {
            return this.setRange(size, size);
        }

        public Builder setRepeats() {
            this.repeats = true;
            return this;
        }

        public VariableStringKeyType create() {
            VariableStringKeyType handler = new VariableStringKeyType(this.alphabet.orElse("ABCDEFGHIJKLMNOPQRSTUVWXYZ"), this.min.orElse(2), this.max.orElse(6), this.repeats);
            return handler;
        }
    }
}

