/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.base.key;

import com.alexbarter.lib.util.ArrayUtil;
import com.alexbarter.lib.util.RandomUtil;

public class KeyManipulation {
    public static String swapTwoCharacters(String keySquare) {
        return new String(KeyManipulation.swapTwoCharacters(keySquare.toCharArray()));
    }

    public static char[] swapTwoCharacters(char[] keySquare) {
        int i1 = RandomUtil.pickRandomInt((int)keySquare.length);
        int i2 = RandomUtil.pickRandomInt((int)keySquare.length);
        char temp = keySquare[i1];
        keySquare[i1] = keySquare[i2];
        keySquare[i2] = temp;
        return keySquare;
    }

    public static char[] changeCharacters(char[] keySquare, CharSequence characters, boolean canHaveRepeats) {
        char tempChar;
        int pos = RandomUtil.pickRandomInt((int)keySquare.length);
        do {
            tempChar = RandomUtil.pickRandomChar((CharSequence)characters);
        } while (!canHaveRepeats && ArrayUtil.contains((char[])keySquare, (char)tempChar));
        keySquare[pos] = tempChar;
        return keySquare;
    }

    public static String changeLength(String key, int min, int max, String characters, boolean canHaveRepeats) {
        return new String(KeyManipulation.changeLength(key.toCharArray(), min, max, characters.toCharArray(), canHaveRepeats));
    }

    public static char[] changeLength(char[] keySquare, int min, int max, char[] characters, boolean canHaveRepeats) {
        char tempChar;
        int newLength = RandomUtil.pickRandomInt((int)min, (int)max);
        char[] newKey = new char[newLength];
        if (newLength < keySquare.length) {
            System.arraycopy(keySquare, 0, newKey, 0, newLength);
            return newKey;
        }
        if (newLength == keySquare.length) {
            return keySquare;
        }
        System.arraycopy(keySquare, 0, newKey, 0, keySquare.length);
        int pos = keySquare.length;
        do {
            int i2 = RandomUtil.pickRandomInt((int)characters.length);
            tempChar = characters[i2];
        } while (!canHaveRepeats && ArrayUtil.contains((char[])keySquare, (char)tempChar));
        newKey[pos++] = tempChar;
        return keySquare;
    }

    public static String swapTwoRows(String keySquare, int columns, int rows) {
        return new String(KeyManipulation.swapTwoRows(keySquare.toCharArray(), columns, rows));
    }

    public static char[] swapTwoRows(char[] keySquare, int columns, int rows) {
        int r1 = RandomUtil.pickRandomInt((int)rows);
        int r2 = RandomUtil.pickRandomInt((int)rows);
        for (int c = 0; c < columns; ++c) {
            char temp = keySquare[r1 * columns + c];
            keySquare[r1 * columns + c] = keySquare[r2 * columns + c];
            keySquare[r2 * columns + c] = temp;
        }
        return keySquare;
    }

    public static String swapTwoColumns(String keySquare, int columns, int rows) {
        return new String(KeyManipulation.swapTwoColumns(keySquare.toCharArray(), columns, rows));
    }

    public static char[] swapTwoColumns(char[] keySquare, int columns, int rows) {
        int c1 = RandomUtil.pickRandomInt((int)columns);
        int c2 = RandomUtil.pickRandomInt((int)columns);
        for (int r = 0; r < rows; ++r) {
            char temp = keySquare[r * columns + c1];
            keySquare[r * columns + c1] = keySquare[r * columns + c2];
            keySquare[r * columns + c2] = temp;
        }
        return keySquare;
    }

    public static String flipColumns(String keySquare, int columns, int rows) {
        return new String(KeyManipulation.flipColumns(keySquare.toCharArray(), columns, rows));
    }

    public static char[] flipColumns(char[] keySquare, int columns, int rows) {
        for (int c = 0; c < columns / 2; ++c) {
            for (int r = 0; r < rows; ++r) {
                char temp = keySquare[r * columns + c];
                keySquare[r * columns + c] = keySquare[r * columns + columns - c - 1];
                keySquare[r * columns + columns - c - 1] = temp;
            }
        }
        return keySquare;
    }

    public static String flipRows(String keySquare, int columns, int rows) {
        return new String(KeyManipulation.flipRows(keySquare.toCharArray(), columns, rows));
    }

    public static char[] flipRows(char[] keySquare, int columns, int rows) {
        for (int r = 0; r < rows / 2; ++r) {
            for (int c = 0; c < columns; ++c) {
                char temp = keySquare[r * columns + c];
                keySquare[r * columns + c] = keySquare[(rows - r - 1) * columns + c];
                keySquare[(rows - r - 1) * columns + c] = temp;
            }
        }
        return keySquare;
    }

    public static String reverseKey(String keySquare) {
        return new String(KeyManipulation.reverseKey(keySquare.toCharArray()));
    }

    public static char[] reverseKey(char[] keySquare) {
        for (int i = 0; i < keySquare.length / 2; ++i) {
            char temp = keySquare[i];
            keySquare[i] = keySquare[keySquare.length - i - 1];
            keySquare[keySquare.length - i - 1] = temp;
        }
        return keySquare;
    }

    public static String modifyKeySquare(String keySquare, int columns, int rows) {
        double d = RandomUtil.pickDouble();
        if (d < 0.1) {
            if (d < 0.02) {
                return KeyManipulation.swapTwoRows(keySquare, columns, rows);
            }
            if (d < 0.04) {
                return KeyManipulation.swapTwoColumns(keySquare, columns, rows);
            }
            if (d < 0.06) {
                return KeyManipulation.reverseKey(keySquare);
            }
            if (d < 0.08) {
                return KeyManipulation.flipRows(keySquare, columns, rows);
            }
            return KeyManipulation.flipColumns(keySquare, columns, rows);
        }
        return KeyManipulation.swapTwoCharacters(keySquare);
    }

    public static Integer[] swapOrder(Integer[] order) {
        int i1 = RandomUtil.pickRandomInt((int)order.length);
        int i2 = RandomUtil.pickRandomInt((int)order.length);
        int temp = order[i1];
        order[i1] = order[i2];
        order[i2] = temp;
        return order;
    }

    public static Integer[] reverseOrder(Integer[] order) {
        for (int i = 0; i < order.length / 2; ++i) {
            int temp = order[i];
            order[i] = order[order.length - i - 1];
            order[order.length - i - 1] = temp;
        }
        return order;
    }

    public static Integer[] cutSwapOrder(Integer[] order) {
        int i;
        Integer[] newOrder = new Integer[order.length];
        int cut = RandomUtil.pickRandomInt((int)1, (int)(order.length - 2));
        int index = 0;
        for (i = cut; i < order.length; ++i) {
            newOrder[index++] = order[i];
        }
        for (i = 0; i < cut; ++i) {
            newOrder[index++] = order[i];
        }
        return newOrder;
    }

    public static Integer[] rotateOrder(Integer[] order) {
        Integer[] newOrder = new Integer[order.length];
        int rotate = RandomUtil.pickRandomInt((int)1, (int)(order.length - 1));
        for (int i = 0; i < order.length; ++i) {
            newOrder[(i + rotate) % order.length] = order[i];
        }
        return newOrder;
    }

    public static Integer[] modifyOrder(Integer[] order) {
        switch (RandomUtil.pickRandomInt((int)30)) {
            case 0: {
                return KeyManipulation.reverseOrder(order);
            }
            case 1: {
                return KeyManipulation.cutSwapOrder(order);
            }
            case 2: {
                return KeyManipulation.rotateOrder(order);
            }
        }
        return KeyManipulation.swapOrder(order);
    }

    public static Character[] swapMorseIndex(Character[] order) {
        order[RandomUtil.pickRandomInt((int)order.length)] = Character.valueOf(RandomUtil.pickRandomChar((CharSequence)"X.-"));
        return order;
    }
}

