/*
 * Decompiled with CFR 0.152.
 */
package com.alexbarter.ciphertool.base.interfaces;

import com.alexbarter.ciphertool.lib.characters.CharArrayWrapper;
import com.alexbarter.lib.Pair;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;

public interface ICipher<K> {
    default public CharSequence normaliseText(CharSequence plainText, K key) {
        return plainText;
    }

    public CharSequence encode(CharSequence var1, K var2);

    default public String encode(String plainText, K key) {
        return this.encode(this.normaliseText(plainText, key), key).toString();
    }

    default public CharSequence decode(CharSequence cipherText, K key) {
        return new CharArrayWrapper(this.decodeEfficently(cipherText, key));
    }

    default public String decode(String cipherText, K key) {
        return new String(this.decodeEfficently(cipherText, key));
    }

    public char[] decodeEfficently(CharSequence var1, @Nullable char[] var2, K var3);

    default public char[] decodeEfficently(CharSequence cipherText, K key) {
        return this.decodeEfficently(cipherText, new char[cipherText.length()], key);
    }

    default public boolean deterministic() {
        return true;
    }

    default public K randomiseKey(int length) {
        return this.randomiseKey();
    }

    @Deprecated
    public K randomiseKey();

    public boolean iterateKeys(Function<K, Boolean> var1);

    default public void iterateKeys(Consumer<K> consumer) {
        this.iterateKeys((K key) -> {
            consumer.accept(key);
            return true;
        });
    }

    default public K alterKey(K key, double temp, int count) {
        return key;
    }

    default public String prettifyKey(K key) {
        return key.toString();
    }

    default public K parseKey(String input) throws ParseException {
        throw new UnsupportedOperationException();
    }

    @Nullable
    default public String getHelp() {
        return null;
    }

    public boolean isValid(K var1);

    public BigInteger getNumOfKeys();

    @Nullable
    default public BigInteger getTotalNumOfKeys() {
        return null;
    }

    default public String randomEncode(String plainText) {
        return this.encode(plainText, this.randomiseKey(plainText.length()));
    }

    default public Pair<String, K> randomEncodePair(String plainText) {
        K key = this.randomiseKey(plainText.length());
        return new Pair((Object)this.encode(plainText, key), key);
    }

    default public Pair<String, String> randomEncodeKeyStr(String plainText) {
        K key = this.randomiseKey(plainText.length());
        return new Pair((Object)this.encode(plainText, key), (Object)this.prettifyKey(key));
    }

    default public Difficulty getDifficulty() {
        return Difficulty.EASY;
    }

    public static enum Difficulty {
        EASY(1),
        NORMAL(5),
        HARD(10);

        int level;

        private Difficulty(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }

        @Deprecated
        public boolean isEasierThan(int levelIn) {
            return this.level <= levelIn;
        }

        public boolean isEasierThan(Difficulty levelIn) {
            return this.level <= levelIn.level;
        }

        public boolean isHarderThan(Difficulty levelIn) {
            return this.level >= levelIn.level;
        }
    }
}

