/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.mapper.autoconfigure;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import org.apache.ibatis.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class MapperCacheDisabler
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(MapperCacheDisabler.class);

    public void afterPropertiesSet() {
        this.disableCaching();
    }

    private void disableCaching() {
        try {
            ClassLoader appClassLoader = this.getClass().getClassLoader();
            this.removeStaticCache(ClassUtils.forName((String)"tk.mybatis.mapper.util.MsUtil", (ClassLoader)appClassLoader), "CLASS_CACHE");
            this.removeStaticCache(ClassUtils.forName((String)"tk.mybatis.mapper.genid.GenIdUtil", (ClassLoader)appClassLoader));
            this.removeStaticCache(ClassUtils.forName((String)"tk.mybatis.mapper.version.VersionUtil", (ClassLoader)appClassLoader));
            this.removeEntityHelperCache(ClassUtils.forName((String)"tk.mybatis.mapper.mapperhelper.EntityHelper", (ClassLoader)appClassLoader));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void removeStaticCache(Class<?> utilClass) {
        this.removeStaticCache(utilClass, "CACHE");
    }

    private void removeStaticCache(Class<?> utilClass, String fieldName) {
        try {
            Field cacheField = ReflectionUtils.findField(utilClass, (String)fieldName);
            if (cacheField != null) {
                ReflectionUtils.makeAccessible((Field)cacheField);
                Object cache = ReflectionUtils.getField((Field)cacheField, null);
                if (cache instanceof Map) {
                    ((Map)cache).clear();
                } else if (cache instanceof Cache) {
                    ((Cache)cache).clear();
                } else {
                    throw new UnsupportedOperationException("cache field must be a java.util.Map or org.apache.ibatis.cache.Cache instance");
                }
                logger.info("Clear " + utilClass.getName() + " " + fieldName + " cache.");
            }
        }
        catch (Exception ex) {
            logger.warn("Failed to disable " + utilClass.getName() + " " + fieldName + " cache. ClassCastExceptions may occur", (Throwable)ex);
        }
    }

    private void removeEntityHelperCache(Class<?> entityHelper) {
        try {
            Field cacheField = ReflectionUtils.findField(entityHelper, (String)"entityTableMap");
            if (cacheField != null) {
                ReflectionUtils.makeAccessible((Field)cacheField);
                Map cache = (Map)ReflectionUtils.getField((Field)cacheField, null);
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                for (Object key : new ArrayList(cache.keySet())) {
                    Class entityClass = (Class)key;
                    if (entityClass.getClassLoader().equals(classLoader) || entityClass.getClassLoader().equals(classLoader.getParent())) continue;
                    cache.remove(entityClass);
                }
                logger.info("Clear EntityHelper entityTableMap cache.");
            }
        }
        catch (Exception ex) {
            logger.warn("Failed to disable Mapper MsUtil cache. ClassCastExceptions may occur", (Throwable)ex);
        }
    }
}

