/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.mapper.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.reflection.MetaObject;
import tk.mybatis.mapper.MapperException;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.entity.EntityTable;
import tk.mybatis.mapper.entity.IDynamicTableName;
import tk.mybatis.mapper.entity.SqlsCriteria;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.util.MetaObjectUtil;
import tk.mybatis.mapper.util.Sqls;
import tk.mybatis.mapper.util.StringUtil;

public class Example
implements IDynamicTableName {
    protected String orderByClause;
    protected boolean distinct;
    protected boolean exists;
    protected boolean notNull;
    protected boolean forUpdate;
    protected Set<String> selectColumns;
    protected Set<String> excludeColumns;
    protected String countColumn;
    protected List<Criteria> oredCriteria;
    protected Class<?> entityClass;
    protected EntityTable table;
    protected Map<String, EntityColumn> propertyMap;
    protected String tableName;
    protected OrderBy ORDERBY;

    public Example(Class<?> entityClass) {
        this(entityClass, true);
    }

    public Example(Class<?> entityClass, boolean exists) {
        this(entityClass, exists, false);
    }

    public Example(Class<?> entityClass, boolean exists, boolean notNull) {
        this.exists = exists;
        this.notNull = notNull;
        this.oredCriteria = new ArrayList<Criteria>();
        this.entityClass = entityClass;
        this.table = EntityHelper.getEntityTable(entityClass);
        this.propertyMap = this.table.getPropertyMap();
        this.ORDERBY = new OrderBy(this, this.propertyMap);
    }

    private Example(Builder builder) {
        this.exists = builder.exists;
        this.notNull = builder.notNull;
        this.distinct = builder.distinct;
        this.entityClass = builder.entityClass;
        this.propertyMap = builder.propertyMap;
        this.selectColumns = builder.selectColumns;
        this.excludeColumns = builder.excludeColumns;
        this.oredCriteria = builder.exampleCriterias;
        this.forUpdate = builder.forUpdate;
        this.tableName = builder.tableName;
        if (!StringUtil.isEmpty(builder.orderByClause.toString())) {
            this.orderByClause = builder.orderByClause.toString();
        }
    }

    public static Builder builder(Class<?> entityClass) {
        return new Builder(entityClass);
    }

    public OrderBy orderBy(String property) {
        this.ORDERBY.orderBy(property);
        return this.ORDERBY;
    }

    public Example excludeProperties(String ... properties) {
        if (properties != null && properties.length > 0) {
            if (this.excludeColumns == null) {
                this.excludeColumns = new LinkedHashSet<String>();
            }
            for (String property : properties) {
                if (!this.propertyMap.containsKey(property)) {
                    throw new MapperException("\u7c7b " + this.entityClass.getSimpleName() + " \u4e0d\u5305\u542b\u5c5e\u6027 '" + property + "'\uff0c\u6216\u8be5\u5c5e\u6027\u88ab@Transient\u6ce8\u91ca\uff01");
                }
                this.excludeColumns.add(this.propertyMap.get(property).getColumn());
            }
        }
        return this;
    }

    public Example selectProperties(String ... properties) {
        if (properties != null && properties.length > 0) {
            if (this.selectColumns == null) {
                this.selectColumns = new LinkedHashSet<String>();
            }
            for (String property : properties) {
                if (!this.propertyMap.containsKey(property)) {
                    throw new MapperException("\u7c7b " + this.entityClass.getSimpleName() + " \u4e0d\u5305\u542b\u5c5e\u6027 '" + property + "'\uff0c\u6216\u8be5\u5c5e\u6027\u88ab@Transient\u6ce8\u91ca\uff01");
                }
                this.selectColumns.add(this.propertyMap.get(property).getColumn());
            }
        }
        return this;
    }

    public void or(Criteria criteria) {
        criteria.setAndOr("or");
        this.oredCriteria.add(criteria);
    }

    public Criteria or() {
        Criteria criteria = this.createCriteriaInternal();
        criteria.setAndOr("or");
        this.oredCriteria.add(criteria);
        return criteria;
    }

    public void and(Criteria criteria) {
        criteria.setAndOr("and");
        this.oredCriteria.add(criteria);
    }

    public Criteria and() {
        Criteria criteria = this.createCriteriaInternal();
        criteria.setAndOr("and");
        this.oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = this.createCriteriaInternal();
        if (this.oredCriteria.size() == 0) {
            criteria.setAndOr("and");
            this.oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria(this.propertyMap, this.exists, this.notNull);
        return criteria;
    }

    public void clear() {
        this.oredCriteria.clear();
        this.orderByClause = null;
        this.distinct = false;
    }

    public String getCountColumn() {
        return this.countColumn;
    }

    @Override
    public String getDynamicTableName() {
        return this.tableName;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public String getOrderByClause() {
        return this.orderByClause;
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public List<Criteria> getOredCriteria() {
        return this.oredCriteria;
    }

    public Set<String> getSelectColumns() {
        if ((this.selectColumns == null || this.selectColumns.size() <= 0) && this.excludeColumns != null && this.excludeColumns.size() > 0) {
            Collection<EntityColumn> entityColumns = this.propertyMap.values();
            this.selectColumns = new LinkedHashSet<String>(entityColumns.size() - this.excludeColumns.size());
            for (EntityColumn column : entityColumns) {
                if (this.excludeColumns.contains(column.getColumn())) continue;
                this.selectColumns.add(column.getColumn());
            }
        }
        return this.selectColumns;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public void setForUpdate(boolean forUpdate) {
        this.forUpdate = forUpdate;
    }

    public void setCountProperty(String property) {
        if (this.propertyMap.containsKey(property)) {
            this.countColumn = this.propertyMap.get(property).getColumn();
        }
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public static class Builder {
        private final Class<?> entityClass;
        protected EntityTable table;
        protected Map<String, EntityColumn> propertyMap;
        private StringBuilder orderByClause;
        private boolean distinct;
        private boolean exists;
        private boolean notNull;
        private boolean forUpdate;
        private Set<String> selectColumns;
        private Set<String> excludeColumns;
        private String countColumn;
        private List<Sqls.Criteria> sqlsCriteria;
        private List<Criteria> exampleCriterias;
        private String tableName;

        public Builder(Class<?> entityClass) {
            this(entityClass, true);
        }

        public Builder(Class<?> entityClass, boolean exists) {
            this(entityClass, exists, false);
        }

        public Builder(Class<?> entityClass, boolean exists, boolean notNull) {
            this.entityClass = entityClass;
            this.exists = exists;
            this.notNull = notNull;
            this.orderByClause = new StringBuilder();
            this.table = EntityHelper.getEntityTable(entityClass);
            this.propertyMap = this.table.getPropertyMap();
            this.sqlsCriteria = new ArrayList<Sqls.Criteria>(2);
        }

        public Builder distinct() {
            return this.setDistinct(true);
        }

        public Builder forUpdate() {
            return this.setForUpdate(true);
        }

        public Builder selectDistinct(String ... properties) {
            this.select(properties);
            this.distinct = true;
            return this;
        }

        public Builder select(String ... properties) {
            if (properties != null && properties.length > 0) {
                if (this.selectColumns == null) {
                    this.selectColumns = new LinkedHashSet<String>();
                }
                for (String property : properties) {
                    if (!this.propertyMap.containsKey(property)) {
                        throw new MapperException("\u5f53\u524d\u5b9e\u4f53\u7c7b\u4e0d\u5305\u542b\u540d\u4e3a" + property + "\u7684\u5c5e\u6027!");
                    }
                    this.selectColumns.add(this.propertyMap.get(property).getColumn());
                }
            }
            return this;
        }

        public Builder notSelect(String ... properties) {
            if (properties != null && properties.length > 0) {
                if (this.excludeColumns == null) {
                    this.excludeColumns = new LinkedHashSet<String>();
                }
                for (String property : properties) {
                    if (!this.propertyMap.containsKey(property)) {
                        throw new MapperException("\u5f53\u524d\u5b9e\u4f53\u7c7b\u4e0d\u5305\u542b\u540d\u4e3a" + property + "\u7684\u5c5e\u6027!");
                    }
                    this.excludeColumns.add(this.propertyMap.get(property).getColumn());
                }
            }
            return this;
        }

        public Builder from(String tableName) {
            return this.setTableName(tableName);
        }

        public Builder where(Sqls sqls) {
            Sqls.Criteria criteria = sqls.getCriteria();
            criteria.setAndOr("and");
            this.sqlsCriteria.add(criteria);
            return this;
        }

        public Builder where(SqlsCriteria sqls) {
            Sqls.Criteria criteria = sqls.getCriteria();
            criteria.setAndOr("and");
            this.sqlsCriteria.add(criteria);
            return this;
        }

        public Builder andWhere(Sqls sqls) {
            Sqls.Criteria criteria = sqls.getCriteria();
            criteria.setAndOr("and");
            this.sqlsCriteria.add(criteria);
            return this;
        }

        public Builder andWhere(SqlsCriteria sqls) {
            Sqls.Criteria criteria = sqls.getCriteria();
            criteria.setAndOr("and");
            this.sqlsCriteria.add(criteria);
            return this;
        }

        public Builder orWhere(Sqls sqls) {
            Sqls.Criteria criteria = sqls.getCriteria();
            criteria.setAndOr("or");
            this.sqlsCriteria.add(criteria);
            return this;
        }

        public Builder orWhere(SqlsCriteria sqls) {
            Sqls.Criteria criteria = sqls.getCriteria();
            criteria.setAndOr("or");
            this.sqlsCriteria.add(criteria);
            return this;
        }

        public Builder orderBy(String ... properties) {
            return this.orderByAsc(properties);
        }

        public Builder orderByAsc(String ... properties) {
            this.contactOrderByClause(" Asc", properties);
            return this;
        }

        public Builder orderByDesc(String ... properties) {
            this.contactOrderByClause(" Desc", properties);
            return this;
        }

        private void contactOrderByClause(String order, String ... properties) {
            StringBuilder columns = new StringBuilder();
            for (String property : properties) {
                String column = this.propertyforOderBy(property);
                if (column == null) continue;
                columns.append(",").append(column);
            }
            columns.append(order);
            if (columns.length() > 0) {
                this.orderByClause.append((CharSequence)columns);
            }
        }

        public Example build() {
            this.exampleCriterias = new ArrayList<Criteria>();
            for (Sqls.Criteria criteria : this.sqlsCriteria) {
                Criteria exampleCriteria = new Criteria(this.propertyMap, this.exists, this.notNull);
                exampleCriteria.setAndOr(criteria.getAndOr());
                for (Sqls.Criterion criterion : criteria.getCriterions()) {
                    String condition = criterion.getCondition();
                    String andOr = criterion.getAndOr();
                    String property = criterion.getProperty();
                    Object[] values = criterion.getValues();
                    this.transformCriterion(exampleCriteria, condition, property, values, andOr);
                }
                this.exampleCriterias.add(exampleCriteria);
            }
            if (this.orderByClause.length() > 0) {
                this.orderByClause = new StringBuilder(this.orderByClause.substring(1, this.orderByClause.length()));
            }
            return new Example(this);
        }

        private void transformCriterion(Criteria exampleCriteria, String condition, String property, Object[] values, String andOr) {
            if (values.length == 0) {
                if ("and".equals(andOr)) {
                    exampleCriteria.addCriterion(this.column(property) + " " + condition);
                } else {
                    exampleCriteria.addOrCriterion(this.column(property) + " " + condition);
                }
            } else if (values.length == 1) {
                if ("and".equals(andOr)) {
                    exampleCriteria.addCriterion(this.column(property) + " " + condition, values[0], this.property(property));
                } else {
                    exampleCriteria.addOrCriterion(this.column(property) + " " + condition, values[0], this.property(property));
                }
            } else if (values.length == 2) {
                if ("and".equals(andOr)) {
                    exampleCriteria.addCriterion(this.column(property) + " " + condition, values[0], values[1], this.property(property));
                } else {
                    exampleCriteria.addOrCriterion(this.column(property) + " " + condition, values[0], values[1], this.property(property));
                }
            }
        }

        private String column(String property) {
            if (this.propertyMap.containsKey(property)) {
                return this.propertyMap.get(property).getColumn();
            }
            if (this.exists) {
                throw new MapperException("\u5f53\u524d\u5b9e\u4f53\u7c7b\u4e0d\u5305\u542b\u540d\u4e3a" + property + "\u7684\u5c5e\u6027!");
            }
            return null;
        }

        private String property(String property) {
            if (this.propertyMap.containsKey(property)) {
                return property;
            }
            if (this.exists) {
                throw new MapperException("\u5f53\u524d\u5b9e\u4f53\u7c7b\u4e0d\u5305\u542b\u540d\u4e3a" + property + "\u7684\u5c5e\u6027!");
            }
            return null;
        }

        private String propertyforOderBy(String property) {
            if (StringUtil.isEmpty(property) || StringUtil.isEmpty(property.trim())) {
                throw new MapperException("\u63a5\u6536\u7684property\u4e3a\u7a7a\uff01");
            }
            if (!this.propertyMap.containsKey(property = property.trim())) {
                throw new MapperException("\u5f53\u524d\u5b9e\u4f53\u7c7b\u4e0d\u5305\u542b\u540d\u4e3a" + property + "\u7684\u5c5e\u6027!");
            }
            return this.propertyMap.get(property).getColumn();
        }

        public Builder setDistinct(boolean distinct) {
            this.distinct = distinct;
            return this;
        }

        public Builder setForUpdate(boolean forUpdate) {
            this.forUpdate = forUpdate;
            return this;
        }

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }
    }

    public static class Criterion {
        private String condition;
        private Object value;
        private Object secondValue;
        private String andOr;
        private boolean noValue;
        private boolean singleValue;
        private boolean betweenValue;
        private boolean listValue;
        private String typeHandler;

        protected Criterion(String condition) {
            this(condition, false);
        }

        protected Criterion(String condition, Object value, String typeHandler) {
            this(condition, value, typeHandler, false);
        }

        protected Criterion(String condition, Object value) {
            this(condition, value, null, false);
        }

        protected Criterion(String condition, Object value, Object secondValue, String typeHandler) {
            this(condition, value, secondValue, typeHandler, false);
        }

        protected Criterion(String condition, Object value, Object secondValue) {
            this(condition, value, secondValue, null, false);
        }

        protected Criterion(String condition, boolean isOr) {
            this.condition = condition;
            this.typeHandler = null;
            this.noValue = true;
            this.andOr = isOr ? "or" : "and";
        }

        protected Criterion(String condition, Object value, String typeHandler, boolean isOr) {
            this.condition = condition;
            this.value = value;
            this.typeHandler = typeHandler;
            String string = this.andOr = isOr ? "or" : "and";
            if (value instanceof Collection) {
                this.listValue = true;
            } else {
                this.singleValue = true;
            }
        }

        protected Criterion(String condition, Object value, boolean isOr) {
            this(condition, value, null, isOr);
        }

        protected Criterion(String condition, Object value, Object secondValue, String typeHandler, boolean isOr) {
            this.condition = condition;
            this.value = value;
            this.secondValue = secondValue;
            this.typeHandler = typeHandler;
            this.betweenValue = true;
            this.andOr = isOr ? "or" : "and";
        }

        protected Criterion(String condition, Object value, Object secondValue, boolean isOr) {
            this(condition, value, secondValue, null, isOr);
        }

        public String getAndOr() {
            return this.andOr;
        }

        public void setAndOr(String andOr) {
            this.andOr = andOr;
        }

        public String getCondition() {
            return this.condition;
        }

        public Object getSecondValue() {
            return this.secondValue;
        }

        public String getTypeHandler() {
            return this.typeHandler;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isBetweenValue() {
            return this.betweenValue;
        }

        public boolean isListValue() {
            return this.listValue;
        }

        public boolean isNoValue() {
            return this.noValue;
        }

        public boolean isSingleValue() {
            return this.singleValue;
        }
    }

    public static class Criteria
    extends GeneratedCriteria {
        protected Criteria(Map<String, EntityColumn> propertyMap, boolean exists, boolean notNull) {
            super(propertyMap, exists, notNull);
        }
    }

    protected static abstract class GeneratedCriteria {
        protected List<Criterion> criteria;
        protected boolean exists;
        protected boolean notNull;
        protected String andOr;
        protected Map<String, EntityColumn> propertyMap;

        protected GeneratedCriteria(Map<String, EntityColumn> propertyMap, boolean exists, boolean notNull) {
            this.exists = exists;
            this.notNull = notNull;
            this.criteria = new ArrayList<Criterion>();
            this.propertyMap = propertyMap;
        }

        public Map<String, EntityColumn> getPropertyMap() {
            return this.propertyMap;
        }

        private String column(String property) {
            if (this.propertyMap.containsKey(property)) {
                return this.propertyMap.get(property).getColumn();
            }
            if (this.exists) {
                throw new MapperException("\u5f53\u524d\u5b9e\u4f53\u7c7b\u4e0d\u5305\u542b\u540d\u4e3a" + property + "\u7684\u5c5e\u6027!");
            }
            return null;
        }

        private String property(String property) {
            if (this.propertyMap.containsKey(property)) {
                return property;
            }
            if (this.exists) {
                throw new MapperException("\u5f53\u524d\u5b9e\u4f53\u7c7b\u4e0d\u5305\u542b\u540d\u4e3a" + property + "\u7684\u5c5e\u6027!");
            }
            return null;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new MapperException("Value for condition cannot be null");
            }
            if (condition.startsWith("null")) {
                return;
            }
            this.criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                if (this.notNull) {
                    throw new MapperException("Value for " + property + " cannot be null");
                }
                return;
            }
            if (property == null) {
                return;
            }
            this.criteria.add(new Criterion(condition, value));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                if (this.notNull) {
                    throw new MapperException("Between values for " + property + " cannot be null");
                }
                return;
            }
            if (property == null) {
                return;
            }
            this.criteria.add(new Criterion(condition, value1, value2));
        }

        protected void addOrCriterion(String condition) {
            if (condition == null) {
                throw new MapperException("Value for condition cannot be null");
            }
            if (condition.startsWith("null")) {
                return;
            }
            this.criteria.add(new Criterion(condition, true));
        }

        protected void addOrCriterion(String condition, Object value, String property) {
            if (value == null) {
                if (this.notNull) {
                    throw new MapperException("Value for " + property + " cannot be null");
                }
                return;
            }
            if (property == null) {
                return;
            }
            this.criteria.add(new Criterion(condition, value, true));
        }

        protected void addOrCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                if (this.notNull) {
                    throw new MapperException("Between values for " + property + " cannot be null");
                }
                return;
            }
            if (property == null) {
                return;
            }
            this.criteria.add(new Criterion(condition, value1, value2, true));
        }

        public Criteria andIsNull(String property) {
            this.addCriterion(this.column(property) + " is null");
            return (Criteria)this;
        }

        public Criteria andIsNotNull(String property) {
            this.addCriterion(this.column(property) + " is not null");
            return (Criteria)this;
        }

        public Criteria andEqualTo(String property, Object value) {
            this.addCriterion(this.column(property) + " =", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria andNotEqualTo(String property, Object value) {
            this.addCriterion(this.column(property) + " <>", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria andGreaterThan(String property, Object value) {
            this.addCriterion(this.column(property) + " >", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria andGreaterThanOrEqualTo(String property, Object value) {
            this.addCriterion(this.column(property) + " >=", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria andLessThan(String property, Object value) {
            this.addCriterion(this.column(property) + " <", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria andLessThanOrEqualTo(String property, Object value) {
            this.addCriterion(this.column(property) + " <=", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria andIn(String property, Iterable values) {
            this.addCriterion(this.column(property) + " in", values, this.property(property));
            return (Criteria)this;
        }

        public Criteria andNotIn(String property, Iterable values) {
            this.addCriterion(this.column(property) + " not in", values, this.property(property));
            return (Criteria)this;
        }

        public Criteria andBetween(String property, Object value1, Object value2) {
            this.addCriterion(this.column(property) + " between", value1, value2, this.property(property));
            return (Criteria)this;
        }

        public Criteria andNotBetween(String property, Object value1, Object value2) {
            this.addCriterion(this.column(property) + " not between", value1, value2, this.property(property));
            return (Criteria)this;
        }

        public Criteria andLike(String property, String value) {
            this.addCriterion(this.column(property) + "  like", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria andNotLike(String property, String value) {
            this.addCriterion(this.column(property) + "  not like", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria andCondition(String condition) {
            this.addCriterion(condition);
            return (Criteria)this;
        }

        public Criteria andCondition(String condition, Object value) {
            this.criteria.add(new Criterion(condition, value));
            return (Criteria)this;
        }

        public Criteria andEqualTo(Object param) {
            String[] properties;
            MetaObject metaObject = MetaObjectUtil.forObject(param);
            for (String property : properties = metaObject.getGetterNames()) {
                Object value;
                if (this.propertyMap.get(property) == null || (value = metaObject.getValue(property)) == null) continue;
                this.andEqualTo(property, value);
            }
            return (Criteria)this;
        }

        public Criteria andAllEqualTo(Object param) {
            String[] properties;
            MetaObject metaObject = MetaObjectUtil.forObject(param);
            for (String property : properties = metaObject.getGetterNames()) {
                if (this.propertyMap.get(property) == null) continue;
                Object value = metaObject.getValue(property);
                if (value != null) {
                    this.andEqualTo(property, value);
                    continue;
                }
                this.andIsNull(property);
            }
            return (Criteria)this;
        }

        public Criteria orIsNull(String property) {
            this.addOrCriterion(this.column(property) + " is null");
            return (Criteria)this;
        }

        public Criteria orIsNotNull(String property) {
            this.addOrCriterion(this.column(property) + " is not null");
            return (Criteria)this;
        }

        public Criteria orEqualTo(String property, Object value) {
            this.addOrCriterion(this.column(property) + " =", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria orNotEqualTo(String property, Object value) {
            this.addOrCriterion(this.column(property) + " <>", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria orGreaterThan(String property, Object value) {
            this.addOrCriterion(this.column(property) + " >", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria orGreaterThanOrEqualTo(String property, Object value) {
            this.addOrCriterion(this.column(property) + " >=", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria orLessThan(String property, Object value) {
            this.addOrCriterion(this.column(property) + " <", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria orLessThanOrEqualTo(String property, Object value) {
            this.addOrCriterion(this.column(property) + " <=", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria orIn(String property, Iterable values) {
            this.addOrCriterion(this.column(property) + " in", values, this.property(property));
            return (Criteria)this;
        }

        public Criteria orNotIn(String property, Iterable values) {
            this.addOrCriterion(this.column(property) + " not in", values, this.property(property));
            return (Criteria)this;
        }

        public Criteria orBetween(String property, Object value1, Object value2) {
            this.addOrCriterion(this.column(property) + " between", value1, value2, this.property(property));
            return (Criteria)this;
        }

        public Criteria orNotBetween(String property, Object value1, Object value2) {
            this.addOrCriterion(this.column(property) + " not between", value1, value2, this.property(property));
            return (Criteria)this;
        }

        public Criteria orLike(String property, String value) {
            this.addOrCriterion(this.column(property) + "  like", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria orNotLike(String property, String value) {
            this.addOrCriterion(this.column(property) + "  not like", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria orCondition(String condition) {
            this.addOrCriterion(condition);
            return (Criteria)this;
        }

        public Criteria orCondition(String condition, Object value) {
            this.criteria.add(new Criterion(condition, value, true));
            return (Criteria)this;
        }

        public Criteria orEqualTo(Object param) {
            String[] properties;
            MetaObject metaObject = MetaObjectUtil.forObject(param);
            for (String property : properties = metaObject.getGetterNames()) {
                Object value;
                if (this.propertyMap.get(property) == null || (value = metaObject.getValue(property)) == null) continue;
                this.orEqualTo(property, value);
            }
            return (Criteria)this;
        }

        public Criteria orAllEqualTo(Object param) {
            String[] properties;
            MetaObject metaObject = MetaObjectUtil.forObject(param);
            for (String property : properties = metaObject.getGetterNames()) {
                if (this.propertyMap.get(property) == null) continue;
                Object value = metaObject.getValue(property);
                if (value != null) {
                    this.orEqualTo(property, value);
                    continue;
                }
                this.orIsNull(property);
            }
            return (Criteria)this;
        }

        public List<Criterion> getAllCriteria() {
            return this.criteria;
        }

        public String getAndOr() {
            return this.andOr;
        }

        public void setAndOr(String andOr) {
            this.andOr = andOr;
        }

        public List<Criterion> getCriteria() {
            return this.criteria;
        }

        public boolean isValid() {
            return this.criteria.size() > 0;
        }
    }

    public static class OrderBy {
        protected Map<String, EntityColumn> propertyMap;
        private Example example;
        private Boolean isProperty;

        public OrderBy(Example example, Map<String, EntityColumn> propertyMap) {
            this.example = example;
            this.propertyMap = propertyMap;
        }

        private String property(String property) {
            if (StringUtil.isEmpty(property) || StringUtil.isEmpty(property.trim())) {
                throw new MapperException("\u63a5\u6536\u7684property\u4e3a\u7a7a\uff01");
            }
            if (!this.propertyMap.containsKey(property = property.trim())) {
                throw new MapperException("\u5f53\u524d\u5b9e\u4f53\u7c7b\u4e0d\u5305\u542b\u540d\u4e3a" + property + "\u7684\u5c5e\u6027!");
            }
            return this.propertyMap.get(property).getColumn();
        }

        public OrderBy orderBy(String property) {
            String column = this.property(property);
            if (column == null) {
                this.isProperty = false;
                return this;
            }
            if (StringUtil.isNotEmpty(this.example.getOrderByClause())) {
                this.example.setOrderByClause(this.example.getOrderByClause() + "," + column);
            } else {
                this.example.setOrderByClause(column);
            }
            this.isProperty = true;
            return this;
        }

        public OrderBy desc() {
            if (this.isProperty.booleanValue()) {
                this.example.setOrderByClause(this.example.getOrderByClause() + " DESC");
                this.isProperty = false;
            }
            return this;
        }

        public OrderBy asc() {
            if (this.isProperty.booleanValue()) {
                this.example.setOrderByClause(this.example.getOrderByClause() + " ASC");
                this.isProperty = false;
            }
            return this;
        }
    }
}

