/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.ui.pickers.views.language;

import android.content.Context;
import android.content.DialogInterface;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import java.util.ArrayList;
import tk.jamun.ui.pickers.R;
import tk.jamun.ui.pickers.adapters.RecyclerAdapterLanguage;
import tk.jamun.ui.pickers.extras.PickerListenerLanguage;
import tk.jamun.ui.pickers.extras.UtilityClassLanguage;
import tk.jamun.ui.pickers.models.ModelLanguage;
import tk.jamun.ui.pickers.models.ModelLanguageParent;

public class PickerLanguageDialog {
    private ArrayList<ModelLanguageParent> arrayList;
    private String searchData = "";
    private PickerListenerLanguage pickerListener;
    private RecyclerAdapterLanguage recyclerAdapterLanguage;
    private EditText editText;
    private UtilityClassLanguage utilityClass;
    private boolean found;
    private AlertDialog builder;
    private Context context;
    private int mode = 0;
    private boolean selectionModeMulti;
    private ArrayList<ModelLanguage> arrayListSelected;
    private String editTextHint;

    public PickerLanguageDialog(Context context) {
        this.context = context;
        this.arrayList = new ArrayList();
        this.utilityClass = new UtilityClassLanguage();
    }

    public PickerLanguageDialog bindListener(PickerListenerLanguage pickerListener) {
        this.pickerListener = pickerListener;
        return this;
    }

    public PickerLanguageDialog setEditTextHint(String editTextHint) {
        this.editTextHint = editTextHint;
        return this;
    }

    public PickerLanguageDialog setSelectionModeMulti(boolean selectionModeMulti) {
        this.selectionModeMulti = selectionModeMulti;
        if (selectionModeMulti) {
            this.arrayListSelected = new ArrayList();
        }
        return this;
    }

    public PickerLanguageDialog setMode(int mode) {
        this.mode = mode;
        return this;
    }

    public PickerLanguageDialog setData(ArrayList<ModelLanguageParent> arrayList) {
        this.arrayList = arrayList;
        return this;
    }

    public PickerLanguageDialog createSetUp() {
        this.builder = new AlertDialog.Builder(this.context).create();
        LayoutInflater layoutInflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
        if (layoutInflater != null) {
            View view = layoutInflater.inflate(R.layout.library_language, null);
            this.builder.setView(view);
            this.utilityClass.initializeData(this.arrayList, this.context, this.mode);
            this.initializeView(view);
        }
        return this;
    }

    private void initializeView(final View view) {
        if (this.selectionModeMulti) {
            view.findViewById(R.id.id_float).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    PickerLanguageDialog.this.pickerListener.multiModeData(PickerLanguageDialog.this.arrayListSelected);
                    PickerLanguageDialog.this.dismiss();
                }
            });
        }
        RecyclerView recyclerView = (RecyclerView)view.findViewById(R.id.id_recycler_view);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.context));
        this.utilityClass.setRecyclerViewCache(recyclerView, 20, true);
        this.recyclerAdapterLanguage = new RecyclerAdapterLanguage(this.arrayList, new PickerListenerLanguage(){

            @Override
            public void singleModeData(ModelLanguage modelLanguage) {
                super.singleModeData(modelLanguage);
                if (PickerLanguageDialog.this.selectionModeMulti) {
                    if (PickerLanguageDialog.this.arrayListSelected.indexOf(modelLanguage) == -1) {
                        PickerLanguageDialog.this.arrayListSelected.add(modelLanguage);
                    } else {
                        PickerLanguageDialog.this.arrayListSelected.remove(modelLanguage);
                    }
                    if (PickerLanguageDialog.this.arrayListSelected.isEmpty()) {
                        view.findViewById(R.id.id_float).setVisibility(8);
                    } else {
                        view.findViewById(R.id.id_float).setVisibility(0);
                    }
                } else {
                    PickerLanguageDialog.this.dismiss();
                    if (PickerLanguageDialog.this.pickerListener != null) {
                        PickerLanguageDialog.this.pickerListener.singleModeData(modelLanguage);
                    }
                }
            }
        }, this.context, this.selectionModeMulti);
        recyclerView.setAdapter((RecyclerView.Adapter)this.recyclerAdapterLanguage);
        this.editText = (EditText)view.findViewById(R.id.id_edit_search);
        final ArrayList newArrayListParent = new ArrayList();
        if (this.editTextHint != null) {
            this.editText.setHint((CharSequence)this.editTextHint);
        }
        this.editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (TextUtils.isEmpty((CharSequence)s)) {
                    PickerLanguageDialog.this.recyclerAdapterLanguage.updateAdapter(PickerLanguageDialog.this.arrayList);
                    view.findViewById(R.id.id_image_clear).setVisibility(8);
                } else {
                    PickerLanguageDialog.this.searchData = PickerLanguageDialog.this.utilityClass.fixText(s.toString());
                    view.findViewById(R.id.id_image_clear).setVisibility(0);
                    newArrayListParent.clear();
                    for (ModelLanguageParent modelLanguageParent : PickerLanguageDialog.this.arrayList) {
                        ArrayList<ModelLanguage> newArrayList = new ArrayList<ModelLanguage>();
                        for (ModelLanguage modelLanguage : modelLanguageParent.getArrayList()) {
                            if (!modelLanguage.getTitle().contains(PickerLanguageDialog.this.searchData)) continue;
                            ModelLanguage modelLanguageNew = new ModelLanguage();
                            modelLanguageNew.setId(modelLanguage.getId());
                            modelLanguageNew.setLanguage(modelLanguage.getLanguage());
                            modelLanguageNew.setSelected(modelLanguage.isSelected());
                            PickerLanguageDialog.this.found = true;
                            modelLanguageNew.setTitle(PickerLanguageDialog.this.utilityClass.implementThingsForSearch(modelLanguage.getTitle(), PickerLanguageDialog.this.searchData));
                            newArrayList.add(modelLanguageNew);
                        }
                        if (!PickerLanguageDialog.this.found) continue;
                        newArrayListParent.add(new ModelLanguageParent(newArrayList, modelLanguageParent.getTitle()));
                        PickerLanguageDialog.this.found = false;
                    }
                    PickerLanguageDialog.this.recyclerAdapterLanguage.updateAdapter(newArrayListParent);
                }
            }

            public void afterTextChanged(Editable s) {
            }
        });
        this.editText.setText((CharSequence)this.searchData);
        view.findViewById(R.id.id_image_back).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!TextUtils.isEmpty((CharSequence)PickerLanguageDialog.this.editText.getText())) {
                    PickerLanguageDialog.this.editText.setText((CharSequence)"");
                    PickerLanguageDialog.this.searchData = "";
                } else if (PickerLanguageDialog.this.selectionModeMulti && PickerLanguageDialog.this.arrayListSelected != null && !PickerLanguageDialog.this.arrayListSelected.isEmpty()) {
                    new AlertDialog.Builder(PickerLanguageDialog.this.context).setMessage(R.string.library_string_are_you_sure).setCancelable(true).setPositiveButton(R.string.library_string_button_name_yes, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                            PickerLanguageDialog.this.dismiss();
                        }
                    }).setNegativeButton(R.string.library_string_button_name_no, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                        }
                    }).show();
                } else {
                    PickerLanguageDialog.this.dismiss();
                }
            }
        });
        view.findViewById(R.id.id_image_clear).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PickerLanguageDialog.this.editText.setText((CharSequence)"");
            }
        });
        this.recyclerAdapterLanguage.updateAdapter(this.arrayList);
    }

    public void clear() {
        if (this.builder != null && this.builder.isShowing()) {
            this.builder.dismiss();
        }
        if (this.arrayList != null) {
            this.arrayList.clear();
            this.arrayList = null;
        }
        this.pickerListener = null;
        this.builder = null;
    }

    public boolean isShowing() {
        return this.builder.isShowing();
    }

    private void dismiss() {
        if (this.builder != null && this.builder.isShowing()) {
            this.builder.dismiss();
        }
    }

    public void show() {
        if (this.builder != null) {
            this.builder.show();
        }
    }
}

