/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.ui.pickers.views.country;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.app.ActionBarDrawerToggle;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.AppCompatImageView;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import java.util.ArrayList;
import org.json.JSONArray;
import tk.jamun.ui.pickers.R;
import tk.jamun.ui.pickers.adapters.RecyclerAdapterCountry;
import tk.jamun.ui.pickers.database.DBCountry;
import tk.jamun.ui.pickers.extras.InterfaceCountryListener;
import tk.jamun.ui.pickers.extras.PickerListenerCountry;
import tk.jamun.ui.pickers.extras.UtilityClassCountry;
import tk.jamun.ui.pickers.models.ModelCountry;
import tk.jamun.ui.pickers.models.ModelCountryDetails;
import tk.jamun.volley.classes.VolleyJsonArrayRequest;
import tk.jamun.volley.helpers.VolleyCancel;
import tk.jamun.volley.helpers.VolleyNeeds;
import tk.jamun.volley.helpers.VolleyResponse;
import tk.jamun.volley.main.VolleySingleton;

public class PickerCountryNavigation
extends Fragment {
    private DBCountry dbCountry;
    private boolean lockMode;
    private ArrayList<ModelCountry> arrayList;
    private VolleyJsonArrayRequest jsonArrayRequest;
    private String searchData = "";
    private InterfaceCountryListener pickerListener;
    private RecyclerAdapterCountry recyclerAdapterCountry;
    private EditText editText;
    private ModelCountryDetails modelCountryDetails;
    private DrawerLayout drawerLayout;
    private UtilityClassCountry utilityClass;
    private View view;
    private ActionBarDrawerToggle actionBarDrawerToggle;
    private ArrayList<ModelCountry> arrayListSelected;
    private boolean selectionModeMulti;
    private int closeDrawerGravity = 0x800003;

    public static PickerCountryNavigation getInstance(InterfaceCountryListener pickerListener, ModelCountryDetails modelCountryDetails, boolean selectionModeMulti) {
        PickerCountryNavigation pickerCountryNavigation = new PickerCountryNavigation();
        Bundle bundle = new Bundle();
        bundle.putParcelable("data", (Parcelable)modelCountryDetails);
        bundle.putBoolean("selMode", selectionModeMulti);
        pickerCountryNavigation.setArguments(bundle);
        pickerCountryNavigation.bindListener(pickerListener);
        return pickerCountryNavigation;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.arrayList = new ArrayList();
        this.dbCountry = new DBCountry();
        VolleySingleton.setInstance((Context)this.getContext());
        this.arrayList = this.dbCountry.getAllCountry(this.arrayList);
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (this.getArguments() != null) {
            return inflater.inflate(R.layout.library_country_frag, container, false);
        }
        return inflater.inflate(R.layout.library_country, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.view = view;
        this.utilityClass = new UtilityClassCountry(view);
        this.initializeData();
    }

    private void initializeData() {
        this.modelCountryDetails = new ModelCountryDetails();
        this.utilityClass.initializeData(this.modelCountryDetails);
        if (this.getArguments() != null) {
            ModelCountryDetails modelCountryDetailsNew = (ModelCountryDetails)this.getArguments().getParcelable("data");
            if (modelCountryDetailsNew != null) {
                this.setTags(modelCountryDetailsNew);
            }
            this.selectionModeMulti = this.getArguments().getBoolean("selMode");
            if (this.selectionModeMulti) {
                this.arrayListSelected = new ArrayList();
            }
            this.initializeView(true);
        }
    }

    public void setTags(ModelCountryDetails modelCountryDetailsNew) {
        this.utilityClass.validateData(this.modelCountryDetails, modelCountryDetailsNew);
    }

    public void setUpDrawer(final DrawerLayout drawerLayout, Toolbar toolbar, final boolean enableLockMode, InterfaceCountryListener pickerListener, int drawerGravity) {
        this.drawerLayout = drawerLayout;
        this.actionBarDrawerToggle = new ActionBarDrawerToggle((Activity)this.getActivity(), drawerLayout, toolbar, R.string.library_drawer_open, R.string.library_drawer_close){

            public void onDrawerOpened(View drawerView) {
                super.onDrawerOpened(drawerView);
                if (enableLockMode) {
                    drawerLayout.setDrawerLockMode(2);
                }
            }

            public void onDrawerClosed(View drawerView) {
                super.onDrawerClosed(drawerView);
                if (enableLockMode) {
                    drawerLayout.setDrawerLockMode(1);
                }
            }
        };
        this.actionBarDrawerToggle.setDrawerIndicatorEnabled(false);
        drawerLayout.addDrawerListener((DrawerLayout.DrawerListener)this.actionBarDrawerToggle);
        drawerLayout.post(new Runnable(){

            @Override
            public void run() {
                PickerCountryNavigation.this.actionBarDrawerToggle.syncState();
            }
        });
        drawerLayout.setDrawerLockMode(1);
        this.closeDrawerGravity = drawerGravity;
        if (drawerGravity == 0x800005) {
            AppCompatImageView appCompatImageViewArrow = (AppCompatImageView)this.view.findViewById(R.id.id_image_back);
            appCompatImageViewArrow.setImageResource(R.drawable.library_icon_vd_arrow_forword);
        }
        this.lockMode = enableLockMode;
        this.bindListener(pickerListener);
        this.initializeView(false);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.actionBarDrawerToggle != null) {
            this.actionBarDrawerToggle.onConfigurationChanged(newConfig);
        }
    }

    public void setSelectionModeMulti(boolean selectionModeMulti) {
        this.selectionModeMulti = selectionModeMulti;
        if (selectionModeMulti) {
            this.arrayListSelected = new ArrayList();
        }
    }

    private void initializeView(final boolean comeFromActivity) {
        if (!comeFromActivity) {
            this.view.findViewById(R.id.id_float).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    PickerCountryNavigation.this.pickerListener.multiModeData(PickerCountryNavigation.this.arrayListSelected);
                    if (PickerCountryNavigation.this.drawerLayout != null) {
                        if (PickerCountryNavigation.this.lockMode) {
                            PickerCountryNavigation.this.drawerLayout.setDrawerLockMode(0);
                        }
                        PickerCountryNavigation.this.drawerLayout.closeDrawer(PickerCountryNavigation.this.closeDrawerGravity);
                    }
                }
            });
        }
        RecyclerView recyclerView = (RecyclerView)this.view.findViewById(R.id.id_recycler_view);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.utilityClass.setRecyclerViewCache(recyclerView, 20, true);
        this.recyclerAdapterCountry = new RecyclerAdapterCountry(this.arrayList, this.modelCountryDetails.getUrlImageDownload(), new PickerListenerCountry(){

            @Override
            public void singleModeData(ModelCountry modelCountry) {
                super.singleModeData(modelCountry);
                if (PickerCountryNavigation.this.selectionModeMulti) {
                    if (PickerCountryNavigation.this.arrayListSelected.indexOf(modelCountry) == -1) {
                        PickerCountryNavigation.this.arrayListSelected.add(modelCountry);
                    } else {
                        PickerCountryNavigation.this.arrayListSelected.remove(modelCountry);
                    }
                    if (!comeFromActivity) {
                        if (PickerCountryNavigation.this.arrayListSelected.isEmpty()) {
                            PickerCountryNavigation.this.view.findViewById(R.id.id_float).setVisibility(8);
                        } else {
                            PickerCountryNavigation.this.view.findViewById(R.id.id_float).setVisibility(0);
                        }
                    }
                } else {
                    if (PickerCountryNavigation.this.pickerListener != null) {
                        PickerCountryNavigation.this.pickerListener.singleModeData(modelCountry);
                    }
                    if (!comeFromActivity) {
                        PickerCountryNavigation.this.closeDrawer();
                    }
                }
            }

            @Override
            public void apiError(int statusCode, String errorMessage) {
            }
        }, this.selectionModeMulti);
        recyclerView.setAdapter((RecyclerView.Adapter)this.recyclerAdapterCountry);
        this.editText = (EditText)this.view.findViewById(R.id.id_edit_search);
        final ArrayList newArrayList = new ArrayList();
        this.editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (TextUtils.isEmpty((CharSequence)s)) {
                    PickerCountryNavigation.this.recyclerAdapterCountry.setDataChanged(PickerCountryNavigation.this.arrayList);
                    PickerCountryNavigation.this.view.findViewById(R.id.id_image_clear).setVisibility(8);
                } else {
                    PickerCountryNavigation.this.view.findViewById(R.id.id_image_clear).setVisibility(0);
                    newArrayList.clear();
                    for (ModelCountry modelCountry : PickerCountryNavigation.this.arrayList) {
                        if (!modelCountry.getCountryName().toLowerCase().contains(s.toString().toLowerCase())) continue;
                        newArrayList.add(modelCountry);
                    }
                    PickerCountryNavigation.this.recyclerAdapterCountry.setDataChanged(newArrayList);
                }
                PickerCountryNavigation.this.searchData = s.toString();
            }

            public void afterTextChanged(Editable s) {
            }
        });
        this.editText.setText((CharSequence)this.searchData);
        this.editText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus) {
                    PickerCountryNavigation.this.view.findViewById(R.id.id_view_keyboard).setVisibility(0);
                } else {
                    PickerCountryNavigation.this.view.findViewById(R.id.id_view_keyboard).setVisibility(8);
                }
            }
        });
        this.view.findViewById(R.id.id_image_back).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!TextUtils.isEmpty((CharSequence)PickerCountryNavigation.this.editText.getText())) {
                    PickerCountryNavigation.this.editText.setText((CharSequence)"");
                    PickerCountryNavigation.this.searchData = "";
                } else if (PickerCountryNavigation.this.selectionModeMulti && PickerCountryNavigation.this.arrayListSelected != null && !PickerCountryNavigation.this.arrayListSelected.isEmpty()) {
                    new AlertDialog.Builder(PickerCountryNavigation.this.getContext()).setMessage(R.string.library_string_are_you_sure).setCancelable(true).setPositiveButton(R.string.library_string_button_name_yes, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                            PickerCountryNavigation.this.closeDrawer();
                        }
                    }).setNegativeButton(R.string.library_string_button_name_no, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                        }
                    }).show();
                } else {
                    PickerCountryNavigation.this.closeDrawer();
                }
            }
        });
        this.view.findViewById(R.id.id_image_clear).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PickerCountryNavigation.this.editText.setText((CharSequence)"");
            }
        });
        if (this.arrayList.isEmpty()) {
            this.getCountry();
        } else {
            this.recyclerAdapterCountry.update(this.arrayList);
        }
    }

    public void bindListener(InterfaceCountryListener pickerListener) {
        this.pickerListener = pickerListener;
    }

    public void clear() {
        VolleyCancel.closeDefaultObject((VolleyJsonArrayRequest)this.jsonArrayRequest);
        if (this.arrayList != null) {
            this.arrayList.clear();
        }
        this.arrayList = null;
        this.pickerListener = null;
    }

    public ModelCountry findByCode(String isoCode) {
        if (!this.dbCountry.IsEmpty()) {
            for (ModelCountry modelCountry : this.arrayList) {
                if (!modelCountry.getCountryISO().equals(isoCode)) continue;
                return modelCountry;
            }
        }
        return null;
    }

    public ModelCountry findByCode(int countryCode) {
        if (!this.dbCountry.IsEmpty()) {
            for (ModelCountry modelCountry : this.arrayList) {
                if (modelCountry.getCountryCode() != countryCode) continue;
                return modelCountry;
            }
        }
        return null;
    }

    private void closeDrawer() {
        if (this.drawerLayout != null) {
            if (this.lockMode) {
                this.drawerLayout.setDrawerLockMode(0);
            }
            this.drawerLayout.closeDrawer(this.closeDrawerGravity);
        } else {
            this.getActivity().finish();
        }
    }

    public ModelCountry findByName(String countryName) {
        if (!this.dbCountry.IsEmpty()) {
            for (ModelCountry modelCountry : this.arrayList) {
                if (!modelCountry.getCountryName().equals(countryName)) continue;
                return modelCountry;
            }
        }
        return null;
    }

    private void getCountry() {
        if (this.dbCountry.IsEmpty()) {
            this.utilityClass.startProgressBar();
            this.startCountryApi();
        } else {
            this.arrayList = this.dbCountry.getAllCountry(this.arrayList);
            this.recyclerAdapterCountry.update(this.arrayList);
        }
    }

    private void startCountryApi() {
        this.editText.setEnabled(false);
        this.jsonArrayRequest = new VolleyJsonArrayRequest(0, this.modelCountryDetails.getUrlGetCountry(), null, (VolleyResponse.Listener)new VolleyResponse.Listener<JSONArray>(){

            public void onResponse(JSONArray response) {
                PickerCountryNavigation.this.editText.setEnabled(true);
                PickerCountryNavigation.this.utilityClass.parseJsonResponse(PickerCountryNavigation.this.arrayList, response, PickerCountryNavigation.this.dbCountry, PickerCountryNavigation.this.modelCountryDetails);
                PickerCountryNavigation.this.recyclerAdapterCountry.update(PickerCountryNavigation.this.arrayList);
                PickerCountryNavigation.this.utilityClass.closeProgressBar();
            }
        }, new VolleyResponse.ErrorListener(){

            public void onErrorResponse(int statusCode, String errorMessage) {
                PickerCountryNavigation.this.utilityClass.closeProgressBar();
                if (PickerCountryNavigation.this.pickerListener != null) {
                    PickerCountryNavigation.this.pickerListener.apiError(statusCode, errorMessage);
                }
            }
        });
        VolleyNeeds.getInstance().setVolleyExtraCalls(this.jsonArrayRequest);
    }

    public void refreshDatabase() {
        this.dbCountry.deleteAll();
        this.getCountry();
    }
}

