/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.ui.pickers.views.country;

import android.content.Context;
import android.content.DialogInterface;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import java.util.ArrayList;
import org.json.JSONArray;
import tk.jamun.ui.pickers.R;
import tk.jamun.ui.pickers.adapters.RecyclerAdapterCountry;
import tk.jamun.ui.pickers.database.DBCountry;
import tk.jamun.ui.pickers.extras.InterfaceCountryListener;
import tk.jamun.ui.pickers.extras.PickerListenerCountry;
import tk.jamun.ui.pickers.extras.UtilityClassCountry;
import tk.jamun.ui.pickers.models.ModelCountry;
import tk.jamun.ui.pickers.models.ModelCountryDetails;
import tk.jamun.volley.classes.VolleyJsonArrayRequest;
import tk.jamun.volley.helpers.VolleyCancel;
import tk.jamun.volley.helpers.VolleyNeeds;
import tk.jamun.volley.helpers.VolleyResponse;
import tk.jamun.volley.main.VolleySingleton;

public class PickerCountryDialog {
    private DBCountry dbCountry;
    private ArrayList<ModelCountry> arrayList;
    private VolleyJsonArrayRequest jsonArrayRequest;
    private String searchData = "";
    private InterfaceCountryListener pickerListener;
    private RecyclerAdapterCountry recyclerAdapterCountry;
    private EditText editText;
    private UtilityClassCountry utilityClass;
    private ModelCountryDetails modelCountryDetails;
    private AlertDialog builder;
    private Context context;
    private ArrayList<ModelCountry> arrayListSelected;
    private boolean selectionModeMulti;
    private String editTextHint;

    public PickerCountryDialog(Context context) {
        this.context = context;
        this.arrayList = new ArrayList();
        this.dbCountry = new DBCountry();
        this.utilityClass = new UtilityClassCountry();
        this.modelCountryDetails = new ModelCountryDetails();
        this.utilityClass.initializeData(this.modelCountryDetails);
        VolleySingleton.setInstance((Context)context);
        this.arrayList = this.dbCountry.getAllCountry(this.arrayList);
    }

    public PickerCountryDialog bindListener(InterfaceCountryListener pickerListener) {
        this.pickerListener = pickerListener;
        return this;
    }

    public PickerCountryDialog setSelectionModeMulti(boolean selectionModeMulti) {
        this.selectionModeMulti = selectionModeMulti;
        if (selectionModeMulti) {
            this.arrayListSelected = new ArrayList();
        }
        return this;
    }

    public PickerCountryDialog setEditTextHint(String editTextHint) {
        this.editTextHint = editTextHint;
        return this;
    }

    public PickerCountryDialog setTags(ModelCountryDetails modelCountryDetailsNew) {
        this.utilityClass.validateData(this.modelCountryDetails, modelCountryDetailsNew);
        return this;
    }

    public PickerCountryDialog createSetUp() {
        this.builder = new AlertDialog.Builder(this.context).create();
        LayoutInflater layoutInflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
        if (layoutInflater != null) {
            View view = layoutInflater.inflate(R.layout.library_country, null);
            this.builder.setView(view);
            this.initializeView(view);
        }
        return this;
    }

    private void initializeView(final View view) {
        if (this.selectionModeMulti) {
            view.findViewById(R.id.id_float).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    PickerCountryDialog.this.pickerListener.multiModeData(PickerCountryDialog.this.arrayListSelected);
                    PickerCountryDialog.this.dismiss();
                }
            });
        }
        this.utilityClass.setView(view);
        RecyclerView recyclerView = (RecyclerView)view.findViewById(R.id.id_recycler_view);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.context));
        this.utilityClass.setRecyclerViewCache(recyclerView, 20, true);
        this.recyclerAdapterCountry = new RecyclerAdapterCountry(this.arrayList, this.modelCountryDetails.getUrlImageDownload(), new PickerListenerCountry(){

            @Override
            public void singleModeData(ModelCountry modelCountry) {
                super.singleModeData(modelCountry);
                if (PickerCountryDialog.this.selectionModeMulti) {
                    if (PickerCountryDialog.this.arrayListSelected.indexOf(modelCountry) == -1) {
                        PickerCountryDialog.this.arrayListSelected.add(modelCountry);
                    } else {
                        PickerCountryDialog.this.arrayListSelected.remove(modelCountry);
                    }
                    if (PickerCountryDialog.this.arrayListSelected.isEmpty()) {
                        view.findViewById(R.id.id_float).setVisibility(8);
                    } else {
                        view.findViewById(R.id.id_float).setVisibility(0);
                    }
                } else {
                    PickerCountryDialog.this.dismiss();
                    if (PickerCountryDialog.this.pickerListener != null) {
                        PickerCountryDialog.this.pickerListener.singleModeData(modelCountry);
                    }
                }
            }

            @Override
            public void apiError(int statusCode, String errorMessage) {
            }
        }, this.selectionModeMulti);
        recyclerView.setAdapter((RecyclerView.Adapter)this.recyclerAdapterCountry);
        this.editText = (EditText)view.findViewById(R.id.id_edit_search);
        if (this.editTextHint != null) {
            this.editText.setHint((CharSequence)this.editTextHint);
        }
        final ArrayList newArrayList = new ArrayList();
        this.editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (TextUtils.isEmpty((CharSequence)s)) {
                    PickerCountryDialog.this.recyclerAdapterCountry.setDataChanged(PickerCountryDialog.this.arrayList);
                    view.findViewById(R.id.id_image_clear).setVisibility(8);
                } else {
                    view.findViewById(R.id.id_image_clear).setVisibility(0);
                    newArrayList.clear();
                    for (ModelCountry modelCountry : PickerCountryDialog.this.arrayList) {
                        if (!modelCountry.getCountryName().toLowerCase().contains(s.toString().toLowerCase())) continue;
                        newArrayList.add(modelCountry);
                    }
                    PickerCountryDialog.this.recyclerAdapterCountry.setDataChanged(newArrayList);
                }
                PickerCountryDialog.this.searchData = s.toString();
            }

            public void afterTextChanged(Editable s) {
            }
        });
        this.editText.setText((CharSequence)this.searchData);
        view.findViewById(R.id.id_image_back).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!TextUtils.isEmpty((CharSequence)PickerCountryDialog.this.editText.getText())) {
                    PickerCountryDialog.this.editText.setText((CharSequence)"");
                    PickerCountryDialog.this.searchData = "";
                } else if (PickerCountryDialog.this.selectionModeMulti && PickerCountryDialog.this.arrayListSelected != null && !PickerCountryDialog.this.arrayListSelected.isEmpty()) {
                    new AlertDialog.Builder(PickerCountryDialog.this.context).setMessage(R.string.library_string_are_you_sure).setCancelable(true).setPositiveButton(R.string.library_string_button_name_yes, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                            PickerCountryDialog.this.dismiss();
                        }
                    }).setNegativeButton(R.string.library_string_button_name_no, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                        }
                    }).show();
                } else {
                    PickerCountryDialog.this.dismiss();
                }
            }
        });
        view.findViewById(R.id.id_image_clear).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PickerCountryDialog.this.editText.setText((CharSequence)"");
            }
        });
        if (this.arrayList.isEmpty()) {
            this.getCountry();
        } else {
            this.recyclerAdapterCountry.update(this.arrayList);
        }
    }

    public ModelCountry findByCode(String isoCode) {
        if (!this.dbCountry.IsEmpty()) {
            for (ModelCountry modelCountry : this.arrayList) {
                if (!modelCountry.getCountryISO().equals(isoCode)) continue;
                return modelCountry;
            }
        }
        return null;
    }

    public ModelCountry findByCode(int countryCode) {
        if (!this.dbCountry.IsEmpty()) {
            for (ModelCountry modelCountry : this.arrayList) {
                if (modelCountry.getCountryCode() != countryCode) continue;
                return modelCountry;
            }
        }
        return null;
    }

    public ModelCountry findByName(String countryName) {
        if (!this.dbCountry.IsEmpty()) {
            for (ModelCountry modelCountry : this.arrayList) {
                if (!modelCountry.getCountryName().equals(countryName)) continue;
                return modelCountry;
            }
        }
        return null;
    }

    private void getCountry() {
        if (this.dbCountry.IsEmpty()) {
            this.utilityClass.startProgressBar();
            this.startCountryApi();
        } else {
            this.arrayList = this.dbCountry.getAllCountry(this.arrayList);
            this.recyclerAdapterCountry.update(this.arrayList);
        }
    }

    private void startCountryApi() {
        this.editText.setEnabled(false);
        this.jsonArrayRequest = new VolleyJsonArrayRequest(0, this.modelCountryDetails.getUrlGetCountry(), null, (VolleyResponse.Listener)new VolleyResponse.Listener<JSONArray>(){

            public void onResponse(JSONArray response) {
                PickerCountryDialog.this.editText.setEnabled(true);
                PickerCountryDialog.this.utilityClass.parseJsonResponse(PickerCountryDialog.this.arrayList, response, PickerCountryDialog.this.dbCountry, PickerCountryDialog.this.modelCountryDetails);
                PickerCountryDialog.this.recyclerAdapterCountry.update(PickerCountryDialog.this.arrayList);
                PickerCountryDialog.this.utilityClass.closeProgressBar();
            }
        }, new VolleyResponse.ErrorListener(){

            public void onErrorResponse(int statusCode, String errorMessage) {
                PickerCountryDialog.this.utilityClass.closeProgressBar();
                if (PickerCountryDialog.this.pickerListener != null) {
                    PickerCountryDialog.this.pickerListener.apiError(statusCode, errorMessage);
                }
                PickerCountryDialog.this.dismiss();
            }
        });
        VolleyNeeds.getInstance().setVolleyExtraCalls(this.jsonArrayRequest);
    }

    public void refreshDatabase() {
        this.dbCountry.deleteAll();
        this.getCountry();
    }

    public void clear() {
        VolleyCancel.closeDefaultObject((VolleyJsonArrayRequest)this.jsonArrayRequest);
        if (this.builder != null && this.builder.isShowing()) {
            this.builder.dismiss();
        }
        if (this.arrayList != null) {
            this.arrayList.clear();
            this.arrayList = null;
        }
        this.pickerListener = null;
        this.builder = null;
    }

    public boolean isShowing() {
        return this.builder.isShowing();
    }

    private void dismiss() {
        if (this.builder != null && this.builder.isShowing()) {
            this.builder.dismiss();
        }
    }

    public void show() {
        if (this.builder != null) {
            this.builder.show();
        }
    }

    public void clearSelectedList() {
        if (this.arrayListSelected != null) {
            this.arrayListSelected.clear();
        }
    }
}

