/*
 * Decompiled with CFR 0.152.
 */
package tk.jamun.ui.pickers.database;

import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import java.util.ArrayList;
import tk.jamun.ui.pickers.database.DatabaseHandler;
import tk.jamun.ui.pickers.models.ModelCountry;

public class DBCountry {
    public void insertCountry(ArrayList<ModelCountry> arrayList) {
        SQLiteDatabase sqLiteDatabase = DatabaseHandler.getInstance().getWritableDatabase();
        sqLiteDatabase.beginTransactionNonExclusive();
        try {
            String sql = "INSERT OR REPLACE INTO " + DatabaseHandler.DATABASE_TABLE_COUNTRY + " VALUES (?,?,?,?);";
            SQLiteStatement statement = sqLiteDatabase.compileStatement(sql);
            for (int i = 0; i < arrayList.size(); ++i) {
                ModelCountry modelCountry = arrayList.get(i);
                statement.clearBindings();
                statement.bindLong(1, (long)modelCountry.getCountryCode());
                statement.bindString(2, modelCountry.getCountryName());
                statement.bindString(3, modelCountry.getCountryISO());
                statement.bindString(4, modelCountry.getFlagUrl());
                statement.execute();
            }
            statement.close();
            this.closeSqlite(sqLiteDatabase, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ArrayList<ModelCountry> getAllCountry(ArrayList<ModelCountry> arrayList) {
        String[] columns = new String[]{DatabaseHandler._CODE, DatabaseHandler._NAME, DatabaseHandler._ISO, DatabaseHandler._IMAGE};
        SQLiteDatabase sqLiteDatabase = DatabaseHandler.getInstance().getWritableDatabase();
        sqLiteDatabase.beginTransactionNonExclusive();
        Cursor cursor = sqLiteDatabase.query(DatabaseHandler.DATABASE_TABLE_COUNTRY, columns, null, null, null, null, null);
        if (cursor != null && cursor.moveToFirst()) {
            do {
                arrayList.add(new ModelCountry(cursor.getString(cursor.getColumnIndex(columns[1])), cursor.getInt(cursor.getColumnIndex(columns[0])), cursor.getString(cursor.getColumnIndex(columns[2])), cursor.getString(cursor.getColumnIndex(columns[3]))));
            } while (cursor.moveToNext());
        }
        this.closeSqlite(sqLiteDatabase, cursor);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean IsEmpty() {
        SQLiteDatabase sqLiteDatabase = DatabaseHandler.getInstance().getWritableDatabase();
        long count = 0L;
        try {
            sqLiteDatabase.beginTransactionNonExclusive();
            count = DatabaseUtils.queryNumEntries((SQLiteDatabase)sqLiteDatabase, (String)DatabaseHandler.DATABASE_TABLE_COUNTRY);
        }
        catch (Exception ignored) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeSqlite(sqLiteDatabase, null);
        }
        return count == 0L;
    }

    public void deleteAll() {
        SQLiteDatabase sqLiteDatabase = DatabaseHandler.getInstance().getWritableDatabase();
        sqLiteDatabase.beginTransactionNonExclusive();
        try {
            sqLiteDatabase.execSQL("DELETE FROM " + DatabaseHandler.DATABASE_TABLE_COUNTRY);
        }
        catch (Exception exception) {
        }
        finally {
            this.closeSqlite(sqLiteDatabase, null);
        }
    }

    private void closeSqlite(SQLiteDatabase sqLiteDatabase, Cursor cursor) {
        if (cursor != null) {
            cursor.close();
        }
        sqLiteDatabase.setTransactionSuccessful();
        sqLiteDatabase.endTransaction();
        sqLiteDatabase.close();
    }
}

