/*
 * Decompiled with CFR 0.152.
 */
package threads.webrtc;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.widget.Button;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.core.util.Preconditions;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentActivity;
import java.util.concurrent.atomic.AtomicBoolean;
import threads.core.Preferences;
import threads.webrtc.R;
import threads.webrtc.RTCSoundPool;

public class RTCCallingDialogFragment
extends DialogFragment {
    public static final String TAG = RTCCallingDialogFragment.class.getSimpleName();
    private static final String TOPIC = "TOPIC";
    private static final String VIDEO = "VIDEO";
    private final AtomicBoolean triggerTimeoutCall = new AtomicBoolean(true);
    private ActionListener mListener;
    private Context mContext;
    private RTCSoundPool soundPoolManager;

    static RTCCallingDialogFragment newInstance(@NonNull String topic, boolean video) {
        Preconditions.checkNotNull((Object)topic);
        Bundle bundle = new Bundle();
        bundle.putString(TOPIC, topic);
        bundle.putBoolean(VIDEO, video);
        RTCCallingDialogFragment fragment = new RTCCallingDialogFragment();
        fragment.setArguments(bundle);
        return fragment;
    }

    public void onDetach() {
        super.onDetach();
        this.mContext = null;
        this.soundPoolManager.release();
        this.triggerTimeoutCall.set(false);
    }

    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        this.mContext = context;
        try {
            this.mListener = (ActionListener)this.getActivity();
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        this.soundPoolManager = RTCSoundPool.create(this.mContext, R.raw.incoming, true);
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        FragmentActivity activity = this.getActivity();
        Preconditions.checkNotNull((Object)activity);
        Bundle args = this.getArguments();
        Preconditions.checkNotNull((Object)args);
        String topic = args.getString(TOPIC);
        Preconditions.checkNotNull((Object)topic);
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext);
        boolean video = args.getBoolean(VIDEO);
        if (video) {
            builder.setIcon(R.drawable.text_video_call);
        } else {
            builder.setIcon(R.drawable.text_phone);
        }
        builder.setTitle((CharSequence)this.getString(R.string.incoming_call));
        builder.setPositiveButton((CharSequence)this.getString(R.string.accept), (dialog, which) -> {
            this.soundPoolManager.stop();
            this.triggerTimeoutCall.set(false);
            this.mListener.acceptCall(topic);
            dialog.dismiss();
        });
        builder.setNegativeButton((CharSequence)this.getString(R.string.reject), (dialog, which) -> {
            this.soundPoolManager.stop();
            this.triggerTimeoutCall.set(false);
            this.mListener.rejectCall(topic);
            dialog.dismiss();
        });
        builder.setMessage((CharSequence)topic);
        AlertDialog dialog2 = builder.create();
        dialog2.setCancelable(false);
        dialog2.setCanceledOnTouchOutside(false);
        dialog2.requestWindowFeature(1);
        Preconditions.checkNotNull((Object)dialog2.getWindow());
        dialog2.getWindow().setFlags(1024, 1024);
        dialog2.getWindow().addFlags(0x400000);
        dialog2.getWindow().addFlags(524288);
        dialog2.getWindow().addFlags(1024);
        dialog2.getWindow().getDecorView().getRootView().setSystemUiVisibility(3846);
        dialog2.getWindow().addFlags(8);
        dialog2.setOnShowListener(dialogInterface -> {
            Button positive = dialog2.getButton(-1);
            Button negative = dialog2.getButton(-2);
            positive.setCompoundDrawablesRelativeWithIntrinsicBounds(R.drawable.phone_in_talk, 0, 0, 0);
            positive.setCompoundDrawablePadding(16);
            negative.setCompoundDrawablesRelativeWithIntrinsicBounds(R.drawable.phone_reject, 0, 0, 0);
            negative.setCompoundDrawablePadding(16);
        });
        int timeout = Preferences.getConnectionTimeout((Context)this.mContext) * 1000;
        new Handler().postDelayed(() -> {
            try {
                if (this.triggerTimeoutCall.get()) {
                    this.mListener.timeoutCall(topic);
                }
                dialog2.dismiss();
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
            }
        }, (long)timeout);
        this.soundPoolManager.play();
        return dialog2;
    }

    public void onDismiss(@NonNull DialogInterface dialog) {
        super.onDismiss(dialog);
    }

    public static interface ActionListener {
        public void acceptCall(@NonNull String var1);

        public void rejectCall(@NonNull String var1);

        public void timeoutCall(@NonNull String var1);
    }
}

