/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import com.google.gson.Gson;
import java.util.HashMap;
import threads.core.api.Additionals;
import threads.core.api.Addresses;
import threads.core.api.Content;
import threads.core.api.PeerInfo;

public class PeerInfoEncoder {
    @NonNull
    public static String convert(@NonNull PeerInfo peer) {
        Preconditions.checkNotNull((Object)peer);
        Content content = new Content();
        Gson gson = new Gson();
        try {
            Addresses addresses = peer.getAddresses();
            Preconditions.checkNotNull((Object)addresses);
            if (!addresses.isEmpty()) {
                String peers = Addresses.toString(addresses);
                Preconditions.checkNotNull((Object)peers);
                content.put("peers", peers);
            }
            HashMap<String, String> additions = peer.getExternalAdditions();
            Preconditions.checkNotNull(additions);
            content.put("adds", Additionals.toString(additions));
            content.put("date", String.valueOf(peer.getTimestamp()));
            return gson.toJson((Object)content);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

