/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import com.google.gson.Gson;
import java.util.HashMap;
import threads.core.api.Additionals;
import threads.core.api.Addresses;
import threads.core.api.Content;
import threads.core.api.PeerInfo;
import threads.iota.Entity;
import threads.ipfs.api.PID;

public class PeerInfoDecoder {
    private static final String TAG = PeerInfoDecoder.class.getSimpleName();

    @Nullable
    public static PeerInfo convert(@NonNull PID owner, @NonNull Entity entity) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull((Object)entity);
        Gson gson = new Gson();
        try {
            Content content = (Content)gson.fromJson(entity.getContent(), Content.class);
            PeerInfo peer = PeerInfoDecoder.convert(owner, content);
            if (peer != null) {
                peer.setHash(entity.getHash());
            }
            return peer;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static PeerInfo convert(@NonNull PID owner, @NonNull Content content) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull((Object)content);
        try {
            PeerInfo peer = PeerInfo.createPeerInfo(owner);
            String peers = (String)content.get("peers");
            if (peers != null) {
                Addresses addresses = Addresses.toAddresses(peers);
                Preconditions.checkNotNull((Object)addresses);
                peer.setAddresses(addresses);
            }
            String date = (String)content.get("date");
            Preconditions.checkNotNull((Object)date);
            long timestamp = Long.valueOf(date);
            peer.setTimestamp(timestamp);
            String additions = (String)content.get("adds");
            Preconditions.checkNotNull((Object)additions);
            if (!additions.isEmpty()) {
                HashMap<String, String> adds = Additionals.toHashMap(additions);
                Preconditions.checkNotNull(adds);
                peer.setExternalAdditions(adds);
            }
            return peer;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            return null;
        }
    }
}

