/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.lifecycle.LiveData;
import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.TypeConverters;
import androidx.room.Update;
import java.util.List;
import threads.core.api.Converter;
import threads.core.api.Peer;
import threads.ipfs.api.CID;

@Dao
public interface PeerDao {
    @Insert(onConflict=1)
    public void insertPeer(Peer var1);

    @Update(onConflict=1)
    public void updatePeer(Peer var1);

    @Delete
    public void deletePeer(Peer var1);

    @Query(value="DELETE FROM Peer")
    public void clear();

    @Query(value="SELECT * FROM Peer WHERE pid = :pid")
    public Peer getPeerByPid(String var1);

    @Query(value="SELECT * FROM Peer WHERE isRelay = 1")
    public List<Peer> getRelayPeers();

    @Query(value="SELECT * FROM Peer WHERE isAutonat = 1")
    public List<Peer> getAutonatPeers();

    @Query(value="SELECT * FROM Peer WHERE isPubsub = 1")
    public List<Peer> getPubsubPeers();

    @Query(value="SELECT * FROM Peer")
    public LiveData<List<Peer>> getLiveDataPeers();

    @Query(value="SELECT COUNT(pid) FROM Peer WHERE image =:cid")
    @TypeConverters(value={Converter.class})
    public int references(CID var1);

    @Query(value="UPDATE Peer SET connected = 0")
    public void resetPeersConnected();

    @Query(value="UPDATE Peer SET connected = :connected WHERE pid = :pid")
    public void setConnected(String var1, boolean var2);

    @Query(value="SELECT connected FROM Peer WHERE pid = :pid ")
    public boolean isConnected(String var1);

    @Query(value="SELECT * FROM Peer")
    public List<Peer> getPeers();

    @Query(value="UPDATE Peer SET timestamp = :timestamp WHERE pid = :pid")
    public void setTimestamp(String var1, long var2);
}

