/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import threads.core.api.Additionals;
import threads.core.api.Converter;
import threads.core.api.Kind;
import threads.core.api.Members;
import threads.core.api.Status;
import threads.core.api.Thread;
import threads.core.api.ThreadDao;
import threads.ipfs.api.CID;
import threads.ipfs.api.PID;

public final class ThreadDao_Impl
implements ThreadDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfThread;
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfThread;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfThread;
    private final SharedSQLiteStatement __preparedStmtOfClear;
    private final SharedSQLiteStatement __preparedStmtOfSetStatus;
    private final SharedSQLiteStatement __preparedStmtOfSetPublishing;
    private final SharedSQLiteStatement __preparedStmtOfSetLeaching;
    private final SharedSQLiteStatement __preparedStmtOfSetThreadDate;
    private final SharedSQLiteStatement __preparedStmtOfSetSenderAlias;
    private final SharedSQLiteStatement __preparedStmtOfSetPinned;
    private final SharedSQLiteStatement __preparedStmtOfSetSenderAlias_1;
    private final SharedSQLiteStatement __preparedStmtOfSetStatus_1;
    private final SharedSQLiteStatement __preparedStmtOfResetThreadsNumber;
    private final SharedSQLiteStatement __preparedStmtOfResetThreadsPublishing;
    private final SharedSQLiteStatement __preparedStmtOfResetThreadsLeaching;
    private final SharedSQLiteStatement __preparedStmtOfSetCid;
    private final SharedSQLiteStatement __preparedStmtOfSetMimeType;
    private final SharedSQLiteStatement __preparedStmtOfSetHash;
    private final SharedSQLiteStatement __preparedStmtOfSetImage;
    private final SharedSQLiteStatement __preparedStmtOfSetMarkedFlag;
    private final SharedSQLiteStatement __preparedStmtOfSetSenderBlocked;

    public ThreadDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfThread = new EntityInsertionAdapter<Thread>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `Thread`(`thread`,`kind`,`senderPid`,`senderKey`,`sesKey`,`date`,`senderAlias`,`idx`,`image`,`marked`,`number`,`cid`,`expire`,`status`,`members`,`mimeType`,`pinned`,`publishing`,`leaching`,`request`,`blocked`,`title`,`additionals`,`hash`,`timestamp`) VALUES (?,?,?,?,?,?,?,nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Thread value) {
                stmt.bindLong(1, value.getThread());
                Integer _tmp = Kind.toInteger(value.getKind());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindLong(2, (long)_tmp.intValue());
                }
                String _tmp_1 = Converter.toString(value.getSenderPid());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                if (value.getSenderKey() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getSenderKey());
                }
                if (value.getSesKey() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getSesKey());
                }
                stmt.bindLong(6, value.getDate());
                if (value.getSenderAlias() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getSenderAlias());
                }
                stmt.bindLong(8, value.getIdx());
                String _tmp_2 = Converter.toString(value.getImage());
                if (_tmp_2 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_2);
                }
                int _tmp_3 = value.isMarked() ? 1 : 0;
                stmt.bindLong(10, (long)_tmp_3);
                stmt.bindLong(11, (long)value.getNumber());
                String _tmp_4 = Converter.toString(value.getCid());
                if (_tmp_4 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_4);
                }
                stmt.bindLong(13, value.getExpire());
                Integer _tmp_5 = Status.toInteger(value.getStatus());
                if (_tmp_5 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindLong(14, (long)_tmp_5.intValue());
                }
                String _tmp_6 = Members.toString(value.getMembers());
                if (_tmp_6 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, _tmp_6);
                }
                if (value.getMimeType() == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, value.getMimeType());
                }
                int _tmp_7 = value.isPinned() ? 1 : 0;
                stmt.bindLong(17, (long)_tmp_7);
                int _tmp_8 = value.isPublishing() ? 1 : 0;
                stmt.bindLong(18, (long)_tmp_8);
                int _tmp_9 = value.isLeaching() ? 1 : 0;
                stmt.bindLong(19, (long)_tmp_9);
                int _tmp_10 = value.isRequest() ? 1 : 0;
                stmt.bindLong(20, (long)_tmp_10);
                int _tmp_11 = value.isBlocked() ? 1 : 0;
                stmt.bindLong(21, (long)_tmp_11);
                if (value.getTitle() == null) {
                    stmt.bindNull(22);
                } else {
                    stmt.bindString(22, value.getTitle());
                }
                String _tmp_12 = Additionals.toString(value.getAdditionals());
                if (_tmp_12 == null) {
                    stmt.bindNull(23);
                } else {
                    stmt.bindString(23, _tmp_12);
                }
                if (value.getHash() == null) {
                    stmt.bindNull(24);
                } else {
                    stmt.bindString(24, value.getHash());
                }
                stmt.bindLong(25, value.getTimestamp());
            }
        };
        this.__deletionAdapterOfThread = new EntityDeletionOrUpdateAdapter<Thread>(__db){

            public String createQuery() {
                return "DELETE FROM `Thread` WHERE `idx` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Thread value) {
                stmt.bindLong(1, value.getIdx());
            }
        };
        this.__updateAdapterOfThread = new EntityDeletionOrUpdateAdapter<Thread>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `Thread` SET `thread` = ?,`kind` = ?,`senderPid` = ?,`senderKey` = ?,`sesKey` = ?,`date` = ?,`senderAlias` = ?,`idx` = ?,`image` = ?,`marked` = ?,`number` = ?,`cid` = ?,`expire` = ?,`status` = ?,`members` = ?,`mimeType` = ?,`pinned` = ?,`publishing` = ?,`leaching` = ?,`request` = ?,`blocked` = ?,`title` = ?,`additionals` = ?,`hash` = ?,`timestamp` = ? WHERE `idx` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Thread value) {
                stmt.bindLong(1, value.getThread());
                Integer _tmp = Kind.toInteger(value.getKind());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindLong(2, (long)_tmp.intValue());
                }
                String _tmp_1 = Converter.toString(value.getSenderPid());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                if (value.getSenderKey() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getSenderKey());
                }
                if (value.getSesKey() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getSesKey());
                }
                stmt.bindLong(6, value.getDate());
                if (value.getSenderAlias() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getSenderAlias());
                }
                stmt.bindLong(8, value.getIdx());
                String _tmp_2 = Converter.toString(value.getImage());
                if (_tmp_2 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_2);
                }
                int _tmp_3 = value.isMarked() ? 1 : 0;
                stmt.bindLong(10, (long)_tmp_3);
                stmt.bindLong(11, (long)value.getNumber());
                String _tmp_4 = Converter.toString(value.getCid());
                if (_tmp_4 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_4);
                }
                stmt.bindLong(13, value.getExpire());
                Integer _tmp_5 = Status.toInteger(value.getStatus());
                if (_tmp_5 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindLong(14, (long)_tmp_5.intValue());
                }
                String _tmp_6 = Members.toString(value.getMembers());
                if (_tmp_6 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, _tmp_6);
                }
                if (value.getMimeType() == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, value.getMimeType());
                }
                int _tmp_7 = value.isPinned() ? 1 : 0;
                stmt.bindLong(17, (long)_tmp_7);
                int _tmp_8 = value.isPublishing() ? 1 : 0;
                stmt.bindLong(18, (long)_tmp_8);
                int _tmp_9 = value.isLeaching() ? 1 : 0;
                stmt.bindLong(19, (long)_tmp_9);
                int _tmp_10 = value.isRequest() ? 1 : 0;
                stmt.bindLong(20, (long)_tmp_10);
                int _tmp_11 = value.isBlocked() ? 1 : 0;
                stmt.bindLong(21, (long)_tmp_11);
                if (value.getTitle() == null) {
                    stmt.bindNull(22);
                } else {
                    stmt.bindString(22, value.getTitle());
                }
                String _tmp_12 = Additionals.toString(value.getAdditionals());
                if (_tmp_12 == null) {
                    stmt.bindNull(23);
                } else {
                    stmt.bindString(23, _tmp_12);
                }
                if (value.getHash() == null) {
                    stmt.bindNull(24);
                } else {
                    stmt.bindString(24, value.getHash());
                }
                stmt.bindLong(25, value.getTimestamp());
                stmt.bindLong(26, value.getIdx());
            }
        };
        this.__preparedStmtOfClear = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM Thread";
                return "DELETE FROM Thread";
            }
        };
        this.__preparedStmtOfSetStatus = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Thread SET status = ?  WHERE idx = ?";
                return "UPDATE Thread SET status = ?  WHERE idx = ?";
            }
        };
        this.__preparedStmtOfSetPublishing = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Thread SET publishing = ?  WHERE idx = ?";
                return "UPDATE Thread SET publishing = ?  WHERE idx = ?";
            }
        };
        this.__preparedStmtOfSetLeaching = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Thread SET leaching = ?  WHERE idx = ?";
                return "UPDATE Thread SET leaching = ?  WHERE idx = ?";
            }
        };
        this.__preparedStmtOfSetThreadDate = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Thread SET date = ?  WHERE idx = ?";
                return "UPDATE Thread SET date = ?  WHERE idx = ?";
            }
        };
        this.__preparedStmtOfSetSenderAlias = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Thread SET senderAlias = ?  WHERE idx = ?";
                return "UPDATE Thread SET senderAlias = ?  WHERE idx = ?";
            }
        };
        this.__preparedStmtOfSetPinned = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Thread SET pinned = ?  WHERE idx = ?";
                return "UPDATE Thread SET pinned = ?  WHERE idx = ?";
            }
        };
        this.__preparedStmtOfSetSenderAlias_1 = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Thread SET senderAlias = ?  WHERE senderPid = ?";
                return "UPDATE Thread SET senderAlias = ?  WHERE senderPid = ?";
            }
        };
        this.__preparedStmtOfSetStatus_1 = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Thread SET status = ?  WHERE status = ?";
                return "UPDATE Thread SET status = ?  WHERE status = ?";
            }
        };
        this.__preparedStmtOfResetThreadsNumber = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Thread SET number = 0";
                return "UPDATE Thread SET number = 0";
            }
        };
        this.__preparedStmtOfResetThreadsPublishing = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Thread SET publishing = 0";
                return "UPDATE Thread SET publishing = 0";
            }
        };
        this.__preparedStmtOfResetThreadsLeaching = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Thread SET leaching = 0";
                return "UPDATE Thread SET leaching = 0";
            }
        };
        this.__preparedStmtOfSetCid = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Thread SET cid =?  WHERE idx = ?";
                return "UPDATE Thread SET cid =?  WHERE idx = ?";
            }
        };
        this.__preparedStmtOfSetMimeType = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Thread SET mimeType =?  WHERE idx = ?";
                return "UPDATE Thread SET mimeType =?  WHERE idx = ?";
            }
        };
        this.__preparedStmtOfSetHash = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Thread SET hash = ? WHERE idx = ?";
                return "UPDATE Thread SET hash = ? WHERE idx = ?";
            }
        };
        this.__preparedStmtOfSetImage = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Thread SET image = ? WHERE idx = ?";
                return "UPDATE Thread SET image = ? WHERE idx = ?";
            }
        };
        this.__preparedStmtOfSetMarkedFlag = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Thread SET marked = ? WHERE idx = ?";
                return "UPDATE Thread SET marked = ? WHERE idx = ?";
            }
        };
        this.__preparedStmtOfSetSenderBlocked = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Thread SET blocked = ? WHERE senderPid = ?";
                return "UPDATE Thread SET blocked = ? WHERE senderPid = ?";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insertThread(Thread thread) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result = this.__insertionAdapterOfThread.insertAndReturnId((Object)thread);
            this.__db.setTransactionSuccessful();
            long l = _result;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertThreads(Thread ... threads) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfThread.insert((Object[])threads);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void removeThreads(Thread ... threads) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfThread.handleMultiple((Object[])threads);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateThreads(Thread ... threads) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfThread.handleMultiple((Object[])threads);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void clear() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClear.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClear.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatus(long idx, Status status) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetStatus.acquire();
        int _argIndex = 1;
        Integer _tmp = Status.toInteger(status);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, idx);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetStatus.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPublishing(long idx, boolean publish) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetPublishing.acquire();
        int _argIndex = 1;
        int _tmp = publish ? 1 : 0;
        _stmt.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, idx);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetPublishing.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLeaching(long idx, boolean leaching) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetLeaching.acquire();
        int _argIndex = 1;
        int _tmp = leaching ? 1 : 0;
        _stmt.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, idx);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetLeaching.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setThreadDate(long idx, long date) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetThreadDate.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, date);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, idx);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetThreadDate.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSenderAlias(long idx, String alias) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetSenderAlias.acquire();
        int _argIndex = 1;
        if (alias == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, alias);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, idx);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetSenderAlias.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPinned(long idx, boolean pinned) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetPinned.acquire();
        int _argIndex = 1;
        int _tmp = pinned ? 1 : 0;
        _stmt.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, idx);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetPinned.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSenderAlias(PID pid, String alias) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetSenderAlias_1.acquire();
        int _argIndex = 1;
        if (alias == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, alias);
        }
        _argIndex = 2;
        String _tmp = Converter.toString(pid);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, _tmp);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetSenderAlias_1.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatus(Status oldStatus, Status newStatus) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetStatus_1.acquire();
        int _argIndex = 1;
        Integer _tmp = Status.toInteger(newStatus);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 2;
        Integer _tmp_1 = Status.toInteger(oldStatus);
        if (_tmp_1 == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetStatus_1.release(_stmt);
        }
    }

    @Override
    public void resetThreadsNumber() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfResetThreadsNumber.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfResetThreadsNumber.release(_stmt);
        }
    }

    @Override
    public void resetThreadsPublishing() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfResetThreadsPublishing.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfResetThreadsPublishing.release(_stmt);
        }
    }

    @Override
    public void resetThreadsLeaching() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfResetThreadsLeaching.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfResetThreadsLeaching.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCid(long idx, CID cid) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetCid.acquire();
        int _argIndex = 1;
        String _tmp = Converter.toString(cid);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, idx);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetCid.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMimeType(long idx, String mimeType) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetMimeType.acquire();
        int _argIndex = 1;
        if (mimeType == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, mimeType);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, idx);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetMimeType.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHash(long idx, String hash) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetHash.acquire();
        int _argIndex = 1;
        if (hash == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, hash);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, idx);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetHash.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setImage(long idx, CID image) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetImage.acquire();
        int _argIndex = 1;
        String _tmp = Converter.toString(image);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, idx);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetImage.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMarkedFlag(long idx, boolean marked) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetMarkedFlag.acquire();
        int _argIndex = 1;
        int _tmp = marked ? 1 : 0;
        _stmt.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, idx);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetMarkedFlag.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSenderBlocked(PID pid, boolean blocked) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetSenderBlocked.acquire();
        int _argIndex = 1;
        int _tmp = blocked ? 1 : 0;
        _stmt.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        String _tmp_1 = Converter.toString(pid);
        if (_tmp_1 == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, _tmp_1);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetSenderBlocked.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Thread> getThreads() {
        String _sql = "SELECT * FROM Thread";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Thread", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfMarked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"marked");
            int _cursorIndexOfNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"number");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfExpire = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expire");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinned");
            int _cursorIndexOfPublishing = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publishing");
            int _cursorIndexOfLeaching = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaching");
            int _cursorIndexOfRequest = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"request");
            int _cursorIndexOfBlocked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blocked");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Thread> _result = new ArrayList<Thread>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpThread = _cursor.getLong(_cursorIndexOfThread);
                Integer _tmp = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp);
                String _tmp_1 = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp_1);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                long _tmpDate = _cursor.getLong(_cursorIndexOfDate);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_2 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                Status _tmpStatus = Status.toStatus(_tmp_2);
                Thread _item = new Thread(_tmpStatus, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpKind, _tmpDate, _tmpThread);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _item.setIdx(_tmpIdx);
                String _tmp_3 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_3);
                _item.setImage(_tmpImage);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfMarked);
                boolean _tmpMarked = _tmp_4 != 0;
                _item.setMarked(_tmpMarked);
                int _tmpNumber = _cursor.getInt(_cursorIndexOfNumber);
                _item.setNumber(_tmpNumber);
                String _tmp_5 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_5);
                _item.setCid(_tmpCid);
                long _tmpExpire = _cursor.getLong(_cursorIndexOfExpire);
                _item.setExpire(_tmpExpire);
                String _tmp_6 = _cursor.getString(_cursorIndexOfMembers);
                Members _tmpMembers = Members.toMembers(_tmp_6);
                _item.setMembers(_tmpMembers);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _item.setMimeType(_tmpMimeType);
                int _tmp_7 = _cursor.getInt(_cursorIndexOfPinned);
                boolean _tmpPinned = _tmp_7 != 0;
                _item.setPinned(_tmpPinned);
                int _tmp_8 = _cursor.getInt(_cursorIndexOfPublishing);
                boolean _tmpPublishing = _tmp_8 != 0;
                _item.setPublishing(_tmpPublishing);
                int _tmp_9 = _cursor.getInt(_cursorIndexOfLeaching);
                boolean _tmpLeaching = _tmp_9 != 0;
                _item.setLeaching(_tmpLeaching);
                int _tmp_10 = _cursor.getInt(_cursorIndexOfRequest);
                boolean _tmpRequest = _tmp_10 != 0;
                _item.setRequest(_tmpRequest);
                int _tmp_11 = _cursor.getInt(_cursorIndexOfBlocked);
                boolean _tmpBlocked = _tmp_11 != 0;
                _item.setBlocked(_tmpBlocked);
                String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                _item.setTitle(_tmpTitle);
                String _tmp_12 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_12);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Thread> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<List<Thread>> getLiveDataThreads() {
        String _sql = "SELECT * FROM Thread";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Thread", (int)0);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"Thread"}, false, (Callable)new Callable<List<Thread>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Thread> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ThreadDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false);){
                    int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
                    int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
                    int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
                    int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
                    int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
                    int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
                    int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
                    int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
                    int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
                    int _cursorIndexOfMarked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"marked");
                    int _cursorIndexOfNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"number");
                    int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                    int _cursorIndexOfExpire = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expire");
                    int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
                    int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
                    int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
                    int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinned");
                    int _cursorIndexOfPublishing = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publishing");
                    int _cursorIndexOfLeaching = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaching");
                    int _cursorIndexOfRequest = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"request");
                    int _cursorIndexOfBlocked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blocked");
                    int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
                    int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
                    int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    ArrayList<Thread> _result = new ArrayList<Thread>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpThread = _cursor.getLong(_cursorIndexOfThread);
                        Integer _tmp = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                        Kind _tmpKind = Kind.toKind(_tmp);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfSenderPid);
                        PID _tmpSenderPid = Converter.toPID(_tmp_1);
                        String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                        String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                        long _tmpDate = _cursor.getLong(_cursorIndexOfDate);
                        String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                        Integer _tmp_2 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                        Status _tmpStatus = Status.toStatus(_tmp_2);
                        Thread _item = new Thread(_tmpStatus, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpKind, _tmpDate, _tmpThread);
                        long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                        _item.setIdx(_tmpIdx);
                        String _tmp_3 = _cursor.getString(_cursorIndexOfImage);
                        CID _tmpImage = Converter.toCID(_tmp_3);
                        _item.setImage(_tmpImage);
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfMarked);
                        boolean _tmpMarked = _tmp_4 != 0;
                        _item.setMarked(_tmpMarked);
                        int _tmpNumber = _cursor.getInt(_cursorIndexOfNumber);
                        _item.setNumber(_tmpNumber);
                        String _tmp_5 = _cursor.getString(_cursorIndexOfCid);
                        CID _tmpCid = Converter.toCID(_tmp_5);
                        _item.setCid(_tmpCid);
                        long _tmpExpire = _cursor.getLong(_cursorIndexOfExpire);
                        _item.setExpire(_tmpExpire);
                        String _tmp_6 = _cursor.getString(_cursorIndexOfMembers);
                        Members _tmpMembers = Members.toMembers(_tmp_6);
                        _item.setMembers(_tmpMembers);
                        String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                        _item.setMimeType(_tmpMimeType);
                        int _tmp_7 = _cursor.getInt(_cursorIndexOfPinned);
                        boolean _tmpPinned = _tmp_7 != 0;
                        _item.setPinned(_tmpPinned);
                        int _tmp_8 = _cursor.getInt(_cursorIndexOfPublishing);
                        boolean _tmpPublishing = _tmp_8 != 0;
                        _item.setPublishing(_tmpPublishing);
                        int _tmp_9 = _cursor.getInt(_cursorIndexOfLeaching);
                        boolean _tmpLeaching = _tmp_9 != 0;
                        _item.setLeaching(_tmpLeaching);
                        int _tmp_10 = _cursor.getInt(_cursorIndexOfRequest);
                        boolean _tmpRequest = _tmp_10 != 0;
                        _item.setRequest(_tmpRequest);
                        int _tmp_11 = _cursor.getInt(_cursorIndexOfBlocked);
                        boolean _tmpBlocked = _tmp_11 != 0;
                        _item.setBlocked(_tmpBlocked);
                        String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                        _item.setTitle(_tmpTitle);
                        String _tmp_12 = _cursor.getString(_cursorIndexOfAdditionals);
                        Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_12);
                        _item.setAdditionals(_tmpAdditionals);
                        String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                        _item.setHash(_tmpHash);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        _item.setTimestamp(_tmpTimestamp);
                        _result.add(_item);
                    }
                    ArrayList<Thread> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Thread> getThreadsByDate(long date) {
        String _sql = "SELECT * FROM Thread WHERE date =?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Thread WHERE date =?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, date);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfMarked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"marked");
            int _cursorIndexOfNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"number");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfExpire = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expire");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinned");
            int _cursorIndexOfPublishing = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publishing");
            int _cursorIndexOfLeaching = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaching");
            int _cursorIndexOfRequest = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"request");
            int _cursorIndexOfBlocked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blocked");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Thread> _result = new ArrayList<Thread>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpThread = _cursor.getLong(_cursorIndexOfThread);
                Integer _tmp = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp);
                String _tmp_1 = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp_1);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                long _tmpDate = _cursor.getLong(_cursorIndexOfDate);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_2 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                Status _tmpStatus = Status.toStatus(_tmp_2);
                Thread _item = new Thread(_tmpStatus, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpKind, _tmpDate, _tmpThread);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _item.setIdx(_tmpIdx);
                String _tmp_3 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_3);
                _item.setImage(_tmpImage);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfMarked);
                boolean _tmpMarked = _tmp_4 != 0;
                _item.setMarked(_tmpMarked);
                int _tmpNumber = _cursor.getInt(_cursorIndexOfNumber);
                _item.setNumber(_tmpNumber);
                String _tmp_5 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_5);
                _item.setCid(_tmpCid);
                long _tmpExpire = _cursor.getLong(_cursorIndexOfExpire);
                _item.setExpire(_tmpExpire);
                String _tmp_6 = _cursor.getString(_cursorIndexOfMembers);
                Members _tmpMembers = Members.toMembers(_tmp_6);
                _item.setMembers(_tmpMembers);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _item.setMimeType(_tmpMimeType);
                int _tmp_7 = _cursor.getInt(_cursorIndexOfPinned);
                boolean _tmpPinned = _tmp_7 != 0;
                _item.setPinned(_tmpPinned);
                int _tmp_8 = _cursor.getInt(_cursorIndexOfPublishing);
                boolean _tmpPublishing = _tmp_8 != 0;
                _item.setPublishing(_tmpPublishing);
                int _tmp_9 = _cursor.getInt(_cursorIndexOfLeaching);
                boolean _tmpLeaching = _tmp_9 != 0;
                _item.setLeaching(_tmpLeaching);
                int _tmp_10 = _cursor.getInt(_cursorIndexOfRequest);
                boolean _tmpRequest = _tmp_10 != 0;
                _item.setRequest(_tmpRequest);
                int _tmp_11 = _cursor.getInt(_cursorIndexOfBlocked);
                boolean _tmpBlocked = _tmp_11 != 0;
                _item.setBlocked(_tmpBlocked);
                String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                _item.setTitle(_tmpTitle);
                String _tmp_12 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_12);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Thread> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Thread> getExpiredThreads(long date) {
        String _sql = "SELECT * FROM Thread WHERE expire < ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Thread WHERE expire < ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, date);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfMarked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"marked");
            int _cursorIndexOfNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"number");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfExpire = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expire");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinned");
            int _cursorIndexOfPublishing = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publishing");
            int _cursorIndexOfLeaching = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaching");
            int _cursorIndexOfRequest = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"request");
            int _cursorIndexOfBlocked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blocked");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Thread> _result = new ArrayList<Thread>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpThread = _cursor.getLong(_cursorIndexOfThread);
                Integer _tmp = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp);
                String _tmp_1 = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp_1);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                long _tmpDate = _cursor.getLong(_cursorIndexOfDate);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_2 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                Status _tmpStatus = Status.toStatus(_tmp_2);
                Thread _item = new Thread(_tmpStatus, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpKind, _tmpDate, _tmpThread);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _item.setIdx(_tmpIdx);
                String _tmp_3 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_3);
                _item.setImage(_tmpImage);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfMarked);
                boolean _tmpMarked = _tmp_4 != 0;
                _item.setMarked(_tmpMarked);
                int _tmpNumber = _cursor.getInt(_cursorIndexOfNumber);
                _item.setNumber(_tmpNumber);
                String _tmp_5 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_5);
                _item.setCid(_tmpCid);
                long _tmpExpire = _cursor.getLong(_cursorIndexOfExpire);
                _item.setExpire(_tmpExpire);
                String _tmp_6 = _cursor.getString(_cursorIndexOfMembers);
                Members _tmpMembers = Members.toMembers(_tmp_6);
                _item.setMembers(_tmpMembers);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _item.setMimeType(_tmpMimeType);
                int _tmp_7 = _cursor.getInt(_cursorIndexOfPinned);
                boolean _tmpPinned = _tmp_7 != 0;
                _item.setPinned(_tmpPinned);
                int _tmp_8 = _cursor.getInt(_cursorIndexOfPublishing);
                boolean _tmpPublishing = _tmp_8 != 0;
                _item.setPublishing(_tmpPublishing);
                int _tmp_9 = _cursor.getInt(_cursorIndexOfLeaching);
                boolean _tmpLeaching = _tmp_9 != 0;
                _item.setLeaching(_tmpLeaching);
                int _tmp_10 = _cursor.getInt(_cursorIndexOfRequest);
                boolean _tmpRequest = _tmp_10 != 0;
                _item.setRequest(_tmpRequest);
                int _tmp_11 = _cursor.getInt(_cursorIndexOfBlocked);
                boolean _tmpBlocked = _tmp_11 != 0;
                _item.setBlocked(_tmpBlocked);
                String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                _item.setTitle(_tmpTitle);
                String _tmp_12 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_12);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Thread> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Thread> getThreadsByKindAndThreadStatus(Kind kind, Status status) {
        String _sql = "SELECT * FROM Thread WHERE kind LIKE ? AND status = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Thread WHERE kind LIKE ? AND status = ?", (int)2);
        int _argIndex = 1;
        Integer _tmp = Kind.toInteger(kind);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 2;
        Integer _tmp_1 = Status.toInteger(status);
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfMarked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"marked");
            int _cursorIndexOfNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"number");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfExpire = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expire");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinned");
            int _cursorIndexOfPublishing = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publishing");
            int _cursorIndexOfLeaching = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaching");
            int _cursorIndexOfRequest = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"request");
            int _cursorIndexOfBlocked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blocked");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Thread> _result = new ArrayList<Thread>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpThread = _cursor.getLong(_cursorIndexOfThread);
                Integer _tmp_2 = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp_2);
                String _tmp_3 = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp_3);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                long _tmpDate = _cursor.getLong(_cursorIndexOfDate);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_4 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                Status _tmpStatus = Status.toStatus(_tmp_4);
                Thread _item = new Thread(_tmpStatus, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpKind, _tmpDate, _tmpThread);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _item.setIdx(_tmpIdx);
                String _tmp_5 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_5);
                _item.setImage(_tmpImage);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfMarked);
                boolean _tmpMarked = _tmp_6 != 0;
                _item.setMarked(_tmpMarked);
                int _tmpNumber = _cursor.getInt(_cursorIndexOfNumber);
                _item.setNumber(_tmpNumber);
                String _tmp_7 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_7);
                _item.setCid(_tmpCid);
                long _tmpExpire = _cursor.getLong(_cursorIndexOfExpire);
                _item.setExpire(_tmpExpire);
                String _tmp_8 = _cursor.getString(_cursorIndexOfMembers);
                Members _tmpMembers = Members.toMembers(_tmp_8);
                _item.setMembers(_tmpMembers);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _item.setMimeType(_tmpMimeType);
                int _tmp_9 = _cursor.getInt(_cursorIndexOfPinned);
                boolean _tmpPinned = _tmp_9 != 0;
                _item.setPinned(_tmpPinned);
                int _tmp_10 = _cursor.getInt(_cursorIndexOfPublishing);
                boolean _tmpPublishing = _tmp_10 != 0;
                _item.setPublishing(_tmpPublishing);
                int _tmp_11 = _cursor.getInt(_cursorIndexOfLeaching);
                boolean _tmpLeaching = _tmp_11 != 0;
                _item.setLeaching(_tmpLeaching);
                int _tmp_12 = _cursor.getInt(_cursorIndexOfRequest);
                boolean _tmpRequest = _tmp_12 != 0;
                _item.setRequest(_tmpRequest);
                int _tmp_13 = _cursor.getInt(_cursorIndexOfBlocked);
                boolean _tmpBlocked = _tmp_13 != 0;
                _item.setBlocked(_tmpBlocked);
                String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                _item.setTitle(_tmpTitle);
                String _tmp_14 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_14);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Thread> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Thread> getThreadsByPinned(boolean pinned) {
        String _sql = "SELECT * FROM Thread WHERE pinned = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Thread WHERE pinned = ?", (int)1);
        int _argIndex = 1;
        int _tmp = pinned ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfMarked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"marked");
            int _cursorIndexOfNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"number");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfExpire = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expire");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinned");
            int _cursorIndexOfPublishing = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publishing");
            int _cursorIndexOfLeaching = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaching");
            int _cursorIndexOfRequest = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"request");
            int _cursorIndexOfBlocked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blocked");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Thread> _result = new ArrayList<Thread>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpThread = _cursor.getLong(_cursorIndexOfThread);
                Integer _tmp_1 = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp_1);
                String _tmp_2 = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp_2);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                long _tmpDate = _cursor.getLong(_cursorIndexOfDate);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_3 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                Status _tmpStatus = Status.toStatus(_tmp_3);
                Thread _item = new Thread(_tmpStatus, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpKind, _tmpDate, _tmpThread);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _item.setIdx(_tmpIdx);
                String _tmp_4 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_4);
                _item.setImage(_tmpImage);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfMarked);
                boolean _tmpMarked = _tmp_5 != 0;
                _item.setMarked(_tmpMarked);
                int _tmpNumber = _cursor.getInt(_cursorIndexOfNumber);
                _item.setNumber(_tmpNumber);
                String _tmp_6 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_6);
                _item.setCid(_tmpCid);
                long _tmpExpire = _cursor.getLong(_cursorIndexOfExpire);
                _item.setExpire(_tmpExpire);
                String _tmp_7 = _cursor.getString(_cursorIndexOfMembers);
                Members _tmpMembers = Members.toMembers(_tmp_7);
                _item.setMembers(_tmpMembers);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _item.setMimeType(_tmpMimeType);
                int _tmp_8 = _cursor.getInt(_cursorIndexOfPinned);
                boolean _tmpPinned = _tmp_8 != 0;
                _item.setPinned(_tmpPinned);
                int _tmp_9 = _cursor.getInt(_cursorIndexOfPublishing);
                boolean _tmpPublishing = _tmp_9 != 0;
                _item.setPublishing(_tmpPublishing);
                int _tmp_10 = _cursor.getInt(_cursorIndexOfLeaching);
                boolean _tmpLeaching = _tmp_10 != 0;
                _item.setLeaching(_tmpLeaching);
                int _tmp_11 = _cursor.getInt(_cursorIndexOfRequest);
                boolean _tmpRequest = _tmp_11 != 0;
                _item.setRequest(_tmpRequest);
                int _tmp_12 = _cursor.getInt(_cursorIndexOfBlocked);
                boolean _tmpBlocked = _tmp_12 != 0;
                _item.setBlocked(_tmpBlocked);
                String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                _item.setTitle(_tmpTitle);
                String _tmp_13 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_13);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Thread> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMimeType(long idx) {
        String _sql = "SELECT mimeType FROM Thread WHERE idx = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT mimeType FROM Thread WHERE idx = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, idx);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            String _result = _cursor.moveToFirst() ? _cursor.getString(0) : null;
            String string = _result;
            return string;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CID getCID(long idx) {
        String _sql = "SELECT cid FROM Thread WHERE idx = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT cid FROM Thread WHERE idx = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, idx);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            CID _result;
            if (_cursor.moveToFirst()) {
                String _tmp = _cursor.getString(0);
                _result = Converter.toCID(_tmp);
            } else {
                _result = null;
            }
            CID cID = _result;
            return cID;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPinned(long idx) {
        String _sql = "SELECT pinned FROM Thread WHERE idx = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT pinned FROM Thread WHERE idx = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, idx);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _tmp;
            boolean _result = _cursor.moveToFirst() ? (_tmp = _cursor.getInt(0)) != 0 : false;
            boolean bl = _result;
            return bl;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Thread> getThreadsByStatus(Status status) {
        String _sql = "SELECT * FROM Thread WHERE status = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Thread WHERE status = ?", (int)1);
        int _argIndex = 1;
        Integer _tmp = Status.toInteger(status);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfMarked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"marked");
            int _cursorIndexOfNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"number");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfExpire = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expire");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinned");
            int _cursorIndexOfPublishing = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publishing");
            int _cursorIndexOfLeaching = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaching");
            int _cursorIndexOfRequest = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"request");
            int _cursorIndexOfBlocked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blocked");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Thread> _result = new ArrayList<Thread>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpThread = _cursor.getLong(_cursorIndexOfThread);
                Integer _tmp_1 = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp_1);
                String _tmp_2 = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp_2);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                long _tmpDate = _cursor.getLong(_cursorIndexOfDate);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_3 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                Status _tmpStatus = Status.toStatus(_tmp_3);
                Thread _item = new Thread(_tmpStatus, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpKind, _tmpDate, _tmpThread);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _item.setIdx(_tmpIdx);
                String _tmp_4 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_4);
                _item.setImage(_tmpImage);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfMarked);
                boolean _tmpMarked = _tmp_5 != 0;
                _item.setMarked(_tmpMarked);
                int _tmpNumber = _cursor.getInt(_cursorIndexOfNumber);
                _item.setNumber(_tmpNumber);
                String _tmp_6 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_6);
                _item.setCid(_tmpCid);
                long _tmpExpire = _cursor.getLong(_cursorIndexOfExpire);
                _item.setExpire(_tmpExpire);
                String _tmp_7 = _cursor.getString(_cursorIndexOfMembers);
                Members _tmpMembers = Members.toMembers(_tmp_7);
                _item.setMembers(_tmpMembers);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _item.setMimeType(_tmpMimeType);
                int _tmp_8 = _cursor.getInt(_cursorIndexOfPinned);
                boolean _tmpPinned = _tmp_8 != 0;
                _item.setPinned(_tmpPinned);
                int _tmp_9 = _cursor.getInt(_cursorIndexOfPublishing);
                boolean _tmpPublishing = _tmp_9 != 0;
                _item.setPublishing(_tmpPublishing);
                int _tmp_10 = _cursor.getInt(_cursorIndexOfLeaching);
                boolean _tmpLeaching = _tmp_10 != 0;
                _item.setLeaching(_tmpLeaching);
                int _tmp_11 = _cursor.getInt(_cursorIndexOfRequest);
                boolean _tmpRequest = _tmp_11 != 0;
                _item.setRequest(_tmpRequest);
                int _tmp_12 = _cursor.getInt(_cursorIndexOfBlocked);
                boolean _tmpBlocked = _tmp_12 != 0;
                _item.setBlocked(_tmpBlocked);
                String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                _item.setTitle(_tmpTitle);
                String _tmp_13 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_13);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Thread> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Thread> getThreadsByCid(CID cid) {
        String _sql = "SELECT * FROM Thread WHERE cid = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Thread WHERE cid = ?", (int)1);
        int _argIndex = 1;
        String _tmp = Converter.toString(cid);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfMarked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"marked");
            int _cursorIndexOfNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"number");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfExpire = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expire");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinned");
            int _cursorIndexOfPublishing = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publishing");
            int _cursorIndexOfLeaching = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaching");
            int _cursorIndexOfRequest = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"request");
            int _cursorIndexOfBlocked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blocked");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Thread> _result = new ArrayList<Thread>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpThread = _cursor.getLong(_cursorIndexOfThread);
                Integer _tmp_1 = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp_1);
                String _tmp_2 = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp_2);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                long _tmpDate = _cursor.getLong(_cursorIndexOfDate);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_3 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                Status _tmpStatus = Status.toStatus(_tmp_3);
                Thread _item = new Thread(_tmpStatus, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpKind, _tmpDate, _tmpThread);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _item.setIdx(_tmpIdx);
                String _tmp_4 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_4);
                _item.setImage(_tmpImage);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfMarked);
                boolean _tmpMarked = _tmp_5 != 0;
                _item.setMarked(_tmpMarked);
                int _tmpNumber = _cursor.getInt(_cursorIndexOfNumber);
                _item.setNumber(_tmpNumber);
                String _tmp_6 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_6);
                _item.setCid(_tmpCid);
                long _tmpExpire = _cursor.getLong(_cursorIndexOfExpire);
                _item.setExpire(_tmpExpire);
                String _tmp_7 = _cursor.getString(_cursorIndexOfMembers);
                Members _tmpMembers = Members.toMembers(_tmp_7);
                _item.setMembers(_tmpMembers);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _item.setMimeType(_tmpMimeType);
                int _tmp_8 = _cursor.getInt(_cursorIndexOfPinned);
                boolean _tmpPinned = _tmp_8 != 0;
                _item.setPinned(_tmpPinned);
                int _tmp_9 = _cursor.getInt(_cursorIndexOfPublishing);
                boolean _tmpPublishing = _tmp_9 != 0;
                _item.setPublishing(_tmpPublishing);
                int _tmp_10 = _cursor.getInt(_cursorIndexOfLeaching);
                boolean _tmpLeaching = _tmp_10 != 0;
                _item.setLeaching(_tmpLeaching);
                int _tmp_11 = _cursor.getInt(_cursorIndexOfRequest);
                boolean _tmpRequest = _tmp_11 != 0;
                _item.setRequest(_tmpRequest);
                int _tmp_12 = _cursor.getInt(_cursorIndexOfBlocked);
                boolean _tmpBlocked = _tmp_12 != 0;
                _item.setBlocked(_tmpBlocked);
                String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                _item.setTitle(_tmpTitle);
                String _tmp_13 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_13);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Thread> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Thread> getThreadsByCidAndThread(CID cid, long thread) {
        String _sql = "SELECT * FROM Thread WHERE cid = ? AND thread = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Thread WHERE cid = ? AND thread = ?", (int)2);
        int _argIndex = 1;
        String _tmp = Converter.toString(cid);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        _statement.bindLong(_argIndex, thread);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfMarked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"marked");
            int _cursorIndexOfNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"number");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfExpire = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expire");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinned");
            int _cursorIndexOfPublishing = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publishing");
            int _cursorIndexOfLeaching = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaching");
            int _cursorIndexOfRequest = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"request");
            int _cursorIndexOfBlocked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blocked");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Thread> _result = new ArrayList<Thread>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpThread = _cursor.getLong(_cursorIndexOfThread);
                Integer _tmp_1 = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp_1);
                String _tmp_2 = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp_2);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                long _tmpDate = _cursor.getLong(_cursorIndexOfDate);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_3 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                Status _tmpStatus = Status.toStatus(_tmp_3);
                Thread _item = new Thread(_tmpStatus, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpKind, _tmpDate, _tmpThread);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _item.setIdx(_tmpIdx);
                String _tmp_4 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_4);
                _item.setImage(_tmpImage);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfMarked);
                boolean _tmpMarked = _tmp_5 != 0;
                _item.setMarked(_tmpMarked);
                int _tmpNumber = _cursor.getInt(_cursorIndexOfNumber);
                _item.setNumber(_tmpNumber);
                String _tmp_6 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_6);
                _item.setCid(_tmpCid);
                long _tmpExpire = _cursor.getLong(_cursorIndexOfExpire);
                _item.setExpire(_tmpExpire);
                String _tmp_7 = _cursor.getString(_cursorIndexOfMembers);
                Members _tmpMembers = Members.toMembers(_tmp_7);
                _item.setMembers(_tmpMembers);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _item.setMimeType(_tmpMimeType);
                int _tmp_8 = _cursor.getInt(_cursorIndexOfPinned);
                boolean _tmpPinned = _tmp_8 != 0;
                _item.setPinned(_tmpPinned);
                int _tmp_9 = _cursor.getInt(_cursorIndexOfPublishing);
                boolean _tmpPublishing = _tmp_9 != 0;
                _item.setPublishing(_tmpPublishing);
                int _tmp_10 = _cursor.getInt(_cursorIndexOfLeaching);
                boolean _tmpLeaching = _tmp_10 != 0;
                _item.setLeaching(_tmpLeaching);
                int _tmp_11 = _cursor.getInt(_cursorIndexOfRequest);
                boolean _tmpRequest = _tmp_11 != 0;
                _item.setRequest(_tmpRequest);
                int _tmp_12 = _cursor.getInt(_cursorIndexOfBlocked);
                boolean _tmpBlocked = _tmp_12 != 0;
                _item.setBlocked(_tmpBlocked);
                String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                _item.setTitle(_tmpTitle);
                String _tmp_13 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_13);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Thread> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getThreadsNumber() {
        String _sql = "Select SUM(number) FROM THREAD";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"Select SUM(number) FROM THREAD", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int references(CID cid) {
        String _sql = "SELECT COUNT(idx) FROM Thread WHERE cid =? OR image =?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT COUNT(idx) FROM Thread WHERE cid =? OR image =?", (int)2);
        int _argIndex = 1;
        String _tmp = Converter.toString(cid);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        String _tmp_1 = Converter.toString(cid);
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp_1);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Thread> getThreadsByThread(long thread) {
        String _sql = "SELECT * FROM Thread WHERE thread =?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Thread WHERE thread =?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, thread);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfMarked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"marked");
            int _cursorIndexOfNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"number");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfExpire = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expire");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinned");
            int _cursorIndexOfPublishing = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publishing");
            int _cursorIndexOfLeaching = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaching");
            int _cursorIndexOfRequest = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"request");
            int _cursorIndexOfBlocked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blocked");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Thread> _result = new ArrayList<Thread>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpThread = _cursor.getLong(_cursorIndexOfThread);
                Integer _tmp = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp);
                String _tmp_1 = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp_1);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                long _tmpDate = _cursor.getLong(_cursorIndexOfDate);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_2 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                Status _tmpStatus = Status.toStatus(_tmp_2);
                Thread _item = new Thread(_tmpStatus, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpKind, _tmpDate, _tmpThread);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _item.setIdx(_tmpIdx);
                String _tmp_3 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_3);
                _item.setImage(_tmpImage);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfMarked);
                boolean _tmpMarked = _tmp_4 != 0;
                _item.setMarked(_tmpMarked);
                int _tmpNumber = _cursor.getInt(_cursorIndexOfNumber);
                _item.setNumber(_tmpNumber);
                String _tmp_5 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_5);
                _item.setCid(_tmpCid);
                long _tmpExpire = _cursor.getLong(_cursorIndexOfExpire);
                _item.setExpire(_tmpExpire);
                String _tmp_6 = _cursor.getString(_cursorIndexOfMembers);
                Members _tmpMembers = Members.toMembers(_tmp_6);
                _item.setMembers(_tmpMembers);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _item.setMimeType(_tmpMimeType);
                int _tmp_7 = _cursor.getInt(_cursorIndexOfPinned);
                boolean _tmpPinned = _tmp_7 != 0;
                _item.setPinned(_tmpPinned);
                int _tmp_8 = _cursor.getInt(_cursorIndexOfPublishing);
                boolean _tmpPublishing = _tmp_8 != 0;
                _item.setPublishing(_tmpPublishing);
                int _tmp_9 = _cursor.getInt(_cursorIndexOfLeaching);
                boolean _tmpLeaching = _tmp_9 != 0;
                _item.setLeaching(_tmpLeaching);
                int _tmp_10 = _cursor.getInt(_cursorIndexOfRequest);
                boolean _tmpRequest = _tmp_10 != 0;
                _item.setRequest(_tmpRequest);
                int _tmp_11 = _cursor.getInt(_cursorIndexOfBlocked);
                boolean _tmpBlocked = _tmp_11 != 0;
                _item.setBlocked(_tmpBlocked);
                String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                _item.setTitle(_tmpTitle);
                String _tmp_12 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_12);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Thread> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getThreadReferences(long thread) {
        String _sql = "SELECT COUNT(idx) FROM Thread WHERE thread =?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT COUNT(idx) FROM Thread WHERE thread =?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, thread);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Thread getThreadByIdx(long idx) {
        String _sql = "SELECT * FROM Thread WHERE idx =?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Thread WHERE idx =?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, idx);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            Thread _result;
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfMarked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"marked");
            int _cursorIndexOfNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"number");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfExpire = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expire");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinned");
            int _cursorIndexOfPublishing = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publishing");
            int _cursorIndexOfLeaching = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaching");
            int _cursorIndexOfRequest = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"request");
            int _cursorIndexOfBlocked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blocked");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            if (_cursor.moveToFirst()) {
                long _tmpThread = _cursor.getLong(_cursorIndexOfThread);
                Integer _tmp = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp);
                String _tmp_1 = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp_1);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                long _tmpDate = _cursor.getLong(_cursorIndexOfDate);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_2 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                Status _tmpStatus = Status.toStatus(_tmp_2);
                _result = new Thread(_tmpStatus, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpKind, _tmpDate, _tmpThread);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _result.setIdx(_tmpIdx);
                String _tmp_3 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_3);
                _result.setImage(_tmpImage);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfMarked);
                boolean _tmpMarked = _tmp_4 != 0;
                _result.setMarked(_tmpMarked);
                int _tmpNumber = _cursor.getInt(_cursorIndexOfNumber);
                _result.setNumber(_tmpNumber);
                String _tmp_5 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_5);
                _result.setCid(_tmpCid);
                long _tmpExpire = _cursor.getLong(_cursorIndexOfExpire);
                _result.setExpire(_tmpExpire);
                String _tmp_6 = _cursor.getString(_cursorIndexOfMembers);
                Members _tmpMembers = Members.toMembers(_tmp_6);
                _result.setMembers(_tmpMembers);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _result.setMimeType(_tmpMimeType);
                int _tmp_7 = _cursor.getInt(_cursorIndexOfPinned);
                boolean _tmpPinned = _tmp_7 != 0;
                _result.setPinned(_tmpPinned);
                int _tmp_8 = _cursor.getInt(_cursorIndexOfPublishing);
                boolean _tmpPublishing = _tmp_8 != 0;
                _result.setPublishing(_tmpPublishing);
                int _tmp_9 = _cursor.getInt(_cursorIndexOfLeaching);
                boolean _tmpLeaching = _tmp_9 != 0;
                _result.setLeaching(_tmpLeaching);
                int _tmp_10 = _cursor.getInt(_cursorIndexOfRequest);
                boolean _tmpRequest = _tmp_10 != 0;
                _result.setRequest(_tmpRequest);
                int _tmp_11 = _cursor.getInt(_cursorIndexOfBlocked);
                boolean _tmpBlocked = _tmp_11 != 0;
                _result.setBlocked(_tmpBlocked);
                String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                _result.setTitle(_tmpTitle);
                String _tmp_12 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_12);
                _result.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _result.setHash(_tmpHash);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _result.setTimestamp(_tmpTimestamp);
            } else {
                _result = null;
            }
            Thread thread = _result;
            return thread;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Thread getThreadByTimestamp(long timestamp) {
        String _sql = "SELECT * FROM Thread WHERE timestamp =?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Thread WHERE timestamp =?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, timestamp);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            Thread _result;
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfMarked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"marked");
            int _cursorIndexOfNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"number");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfExpire = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expire");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinned");
            int _cursorIndexOfPublishing = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publishing");
            int _cursorIndexOfLeaching = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaching");
            int _cursorIndexOfRequest = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"request");
            int _cursorIndexOfBlocked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blocked");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            if (_cursor.moveToFirst()) {
                long _tmpThread = _cursor.getLong(_cursorIndexOfThread);
                Integer _tmp = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp);
                String _tmp_1 = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp_1);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                long _tmpDate = _cursor.getLong(_cursorIndexOfDate);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_2 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                Status _tmpStatus = Status.toStatus(_tmp_2);
                _result = new Thread(_tmpStatus, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpKind, _tmpDate, _tmpThread);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _result.setIdx(_tmpIdx);
                String _tmp_3 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_3);
                _result.setImage(_tmpImage);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfMarked);
                boolean _tmpMarked = _tmp_4 != 0;
                _result.setMarked(_tmpMarked);
                int _tmpNumber = _cursor.getInt(_cursorIndexOfNumber);
                _result.setNumber(_tmpNumber);
                String _tmp_5 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_5);
                _result.setCid(_tmpCid);
                long _tmpExpire = _cursor.getLong(_cursorIndexOfExpire);
                _result.setExpire(_tmpExpire);
                String _tmp_6 = _cursor.getString(_cursorIndexOfMembers);
                Members _tmpMembers = Members.toMembers(_tmp_6);
                _result.setMembers(_tmpMembers);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _result.setMimeType(_tmpMimeType);
                int _tmp_7 = _cursor.getInt(_cursorIndexOfPinned);
                boolean _tmpPinned = _tmp_7 != 0;
                _result.setPinned(_tmpPinned);
                int _tmp_8 = _cursor.getInt(_cursorIndexOfPublishing);
                boolean _tmpPublishing = _tmp_8 != 0;
                _result.setPublishing(_tmpPublishing);
                int _tmp_9 = _cursor.getInt(_cursorIndexOfLeaching);
                boolean _tmpLeaching = _tmp_9 != 0;
                _result.setLeaching(_tmpLeaching);
                int _tmp_10 = _cursor.getInt(_cursorIndexOfRequest);
                boolean _tmpRequest = _tmp_10 != 0;
                _result.setRequest(_tmpRequest);
                int _tmp_11 = _cursor.getInt(_cursorIndexOfBlocked);
                boolean _tmpBlocked = _tmp_11 != 0;
                _result.setBlocked(_tmpBlocked);
                String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                _result.setTitle(_tmpTitle);
                String _tmp_12 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_12);
                _result.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _result.setHash(_tmpHash);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _result.setTimestamp(_tmpTimestamp);
            } else {
                _result = null;
            }
            Thread thread = _result;
            return thread;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Thread> getThreadByIdxs(long ... idxs) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM Thread WHERE idx IN(");
        int _inputSize = idxs.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (long _item : idxs) {
            _statement.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfMarked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"marked");
            int _cursorIndexOfNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"number");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfExpire = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expire");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinned");
            int _cursorIndexOfPublishing = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publishing");
            int _cursorIndexOfLeaching = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaching");
            int _cursorIndexOfRequest = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"request");
            int _cursorIndexOfBlocked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blocked");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Thread> _result = new ArrayList<Thread>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpThread = _cursor.getLong(_cursorIndexOfThread);
                Integer _tmp = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp);
                String _tmp_1 = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp_1);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                long _tmpDate = _cursor.getLong(_cursorIndexOfDate);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_2 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                Status _tmpStatus = Status.toStatus(_tmp_2);
                Thread _item_1 = new Thread(_tmpStatus, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpKind, _tmpDate, _tmpThread);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _item_1.setIdx(_tmpIdx);
                String _tmp_3 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_3);
                _item_1.setImage(_tmpImage);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfMarked);
                boolean _tmpMarked = _tmp_4 != 0;
                _item_1.setMarked(_tmpMarked);
                int _tmpNumber = _cursor.getInt(_cursorIndexOfNumber);
                _item_1.setNumber(_tmpNumber);
                String _tmp_5 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_5);
                _item_1.setCid(_tmpCid);
                long _tmpExpire = _cursor.getLong(_cursorIndexOfExpire);
                _item_1.setExpire(_tmpExpire);
                String _tmp_6 = _cursor.getString(_cursorIndexOfMembers);
                Members _tmpMembers = Members.toMembers(_tmp_6);
                _item_1.setMembers(_tmpMembers);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _item_1.setMimeType(_tmpMimeType);
                int _tmp_7 = _cursor.getInt(_cursorIndexOfPinned);
                boolean _tmpPinned = _tmp_7 != 0;
                _item_1.setPinned(_tmpPinned);
                int _tmp_8 = _cursor.getInt(_cursorIndexOfPublishing);
                boolean _tmpPublishing = _tmp_8 != 0;
                _item_1.setPublishing(_tmpPublishing);
                int _tmp_9 = _cursor.getInt(_cursorIndexOfLeaching);
                boolean _tmpLeaching = _tmp_9 != 0;
                _item_1.setLeaching(_tmpLeaching);
                int _tmp_10 = _cursor.getInt(_cursorIndexOfRequest);
                boolean _tmpRequest = _tmp_10 != 0;
                _item_1.setRequest(_tmpRequest);
                int _tmp_11 = _cursor.getInt(_cursorIndexOfBlocked);
                boolean _tmpBlocked = _tmp_11 != 0;
                _item_1.setBlocked(_tmpBlocked);
                String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                _item_1.setTitle(_tmpTitle);
                String _tmp_12 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_12);
                _item_1.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item_1.setHash(_tmpHash);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item_1.setTimestamp(_tmpTimestamp);
                _result.add(_item_1);
            }
            ArrayList<Thread> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Thread getThreadByHash(String hash) {
        String _sql = "SELECT * FROM Thread WHERE hash = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Thread WHERE hash = ?", (int)1);
        int _argIndex = 1;
        if (hash == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, hash);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            Thread _result;
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfMarked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"marked");
            int _cursorIndexOfNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"number");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfExpire = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expire");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinned");
            int _cursorIndexOfPublishing = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publishing");
            int _cursorIndexOfLeaching = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaching");
            int _cursorIndexOfRequest = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"request");
            int _cursorIndexOfBlocked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blocked");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            if (_cursor.moveToFirst()) {
                long _tmpThread = _cursor.getLong(_cursorIndexOfThread);
                Integer _tmp = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp);
                String _tmp_1 = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp_1);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                long _tmpDate = _cursor.getLong(_cursorIndexOfDate);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_2 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                Status _tmpStatus = Status.toStatus(_tmp_2);
                _result = new Thread(_tmpStatus, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpKind, _tmpDate, _tmpThread);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _result.setIdx(_tmpIdx);
                String _tmp_3 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_3);
                _result.setImage(_tmpImage);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfMarked);
                boolean _tmpMarked = _tmp_4 != 0;
                _result.setMarked(_tmpMarked);
                int _tmpNumber = _cursor.getInt(_cursorIndexOfNumber);
                _result.setNumber(_tmpNumber);
                String _tmp_5 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_5);
                _result.setCid(_tmpCid);
                long _tmpExpire = _cursor.getLong(_cursorIndexOfExpire);
                _result.setExpire(_tmpExpire);
                String _tmp_6 = _cursor.getString(_cursorIndexOfMembers);
                Members _tmpMembers = Members.toMembers(_tmp_6);
                _result.setMembers(_tmpMembers);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _result.setMimeType(_tmpMimeType);
                int _tmp_7 = _cursor.getInt(_cursorIndexOfPinned);
                boolean _tmpPinned = _tmp_7 != 0;
                _result.setPinned(_tmpPinned);
                int _tmp_8 = _cursor.getInt(_cursorIndexOfPublishing);
                boolean _tmpPublishing = _tmp_8 != 0;
                _result.setPublishing(_tmpPublishing);
                int _tmp_9 = _cursor.getInt(_cursorIndexOfLeaching);
                boolean _tmpLeaching = _tmp_9 != 0;
                _result.setLeaching(_tmpLeaching);
                int _tmp_10 = _cursor.getInt(_cursorIndexOfRequest);
                boolean _tmpRequest = _tmp_10 != 0;
                _result.setRequest(_tmpRequest);
                int _tmp_11 = _cursor.getInt(_cursorIndexOfBlocked);
                boolean _tmpBlocked = _tmp_11 != 0;
                _result.setBlocked(_tmpBlocked);
                String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                _result.setTitle(_tmpTitle);
                String _tmp_12 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_12);
                _result.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _result.setHash(_tmpHash);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _result.setTimestamp(_tmpTimestamp);
            } else {
                _result = null;
            }
            Thread thread = _result;
            return thread;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Thread> getThreadsBySenderPid(PID senderPid) {
        String _sql = "SELECT * FROM Thread WHERE senderPid =?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Thread WHERE senderPid =?", (int)1);
        int _argIndex = 1;
        String _tmp = Converter.toString(senderPid);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfMarked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"marked");
            int _cursorIndexOfNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"number");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfExpire = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expire");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinned");
            int _cursorIndexOfPublishing = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publishing");
            int _cursorIndexOfLeaching = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaching");
            int _cursorIndexOfRequest = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"request");
            int _cursorIndexOfBlocked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blocked");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Thread> _result = new ArrayList<Thread>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpThread = _cursor.getLong(_cursorIndexOfThread);
                Integer _tmp_1 = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp_1);
                String _tmp_2 = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp_2);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                long _tmpDate = _cursor.getLong(_cursorIndexOfDate);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_3 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                Status _tmpStatus = Status.toStatus(_tmp_3);
                Thread _item = new Thread(_tmpStatus, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpKind, _tmpDate, _tmpThread);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _item.setIdx(_tmpIdx);
                String _tmp_4 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_4);
                _item.setImage(_tmpImage);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfMarked);
                boolean _tmpMarked = _tmp_5 != 0;
                _item.setMarked(_tmpMarked);
                int _tmpNumber = _cursor.getInt(_cursorIndexOfNumber);
                _item.setNumber(_tmpNumber);
                String _tmp_6 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_6);
                _item.setCid(_tmpCid);
                long _tmpExpire = _cursor.getLong(_cursorIndexOfExpire);
                _item.setExpire(_tmpExpire);
                String _tmp_7 = _cursor.getString(_cursorIndexOfMembers);
                Members _tmpMembers = Members.toMembers(_tmp_7);
                _item.setMembers(_tmpMembers);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                _item.setMimeType(_tmpMimeType);
                int _tmp_8 = _cursor.getInt(_cursorIndexOfPinned);
                boolean _tmpPinned = _tmp_8 != 0;
                _item.setPinned(_tmpPinned);
                int _tmp_9 = _cursor.getInt(_cursorIndexOfPublishing);
                boolean _tmpPublishing = _tmp_9 != 0;
                _item.setPublishing(_tmpPublishing);
                int _tmp_10 = _cursor.getInt(_cursorIndexOfLeaching);
                boolean _tmpLeaching = _tmp_10 != 0;
                _item.setLeaching(_tmpLeaching);
                int _tmp_11 = _cursor.getInt(_cursorIndexOfRequest);
                boolean _tmpRequest = _tmp_11 != 0;
                _item.setRequest(_tmpRequest);
                int _tmp_12 = _cursor.getInt(_cursorIndexOfBlocked);
                boolean _tmpBlocked = _tmp_12 != 0;
                _item.setBlocked(_tmpBlocked);
                String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                _item.setTitle(_tmpTitle);
                String _tmp_13 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_13);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Thread> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<List<Thread>> getLiveDataThreadsByThread(long thread) {
        String _sql = "SELECT * FROM Thread WHERE thread =?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Thread WHERE thread =?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, thread);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"Thread"}, false, (Callable)new Callable<List<Thread>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Thread> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)ThreadDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false);){
                    int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
                    int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
                    int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
                    int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
                    int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
                    int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
                    int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
                    int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
                    int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
                    int _cursorIndexOfMarked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"marked");
                    int _cursorIndexOfNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"number");
                    int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                    int _cursorIndexOfExpire = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expire");
                    int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
                    int _cursorIndexOfMembers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"members");
                    int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
                    int _cursorIndexOfPinned = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pinned");
                    int _cursorIndexOfPublishing = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publishing");
                    int _cursorIndexOfLeaching = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"leaching");
                    int _cursorIndexOfRequest = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"request");
                    int _cursorIndexOfBlocked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blocked");
                    int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
                    int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
                    int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    ArrayList<Thread> _result = new ArrayList<Thread>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpThread = _cursor.getLong(_cursorIndexOfThread);
                        Integer _tmp = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                        Kind _tmpKind = Kind.toKind(_tmp);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfSenderPid);
                        PID _tmpSenderPid = Converter.toPID(_tmp_1);
                        String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                        String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                        long _tmpDate = _cursor.getLong(_cursorIndexOfDate);
                        String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                        Integer _tmp_2 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                        Status _tmpStatus = Status.toStatus(_tmp_2);
                        Thread _item = new Thread(_tmpStatus, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpKind, _tmpDate, _tmpThread);
                        long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                        _item.setIdx(_tmpIdx);
                        String _tmp_3 = _cursor.getString(_cursorIndexOfImage);
                        CID _tmpImage = Converter.toCID(_tmp_3);
                        _item.setImage(_tmpImage);
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfMarked);
                        boolean _tmpMarked = _tmp_4 != 0;
                        _item.setMarked(_tmpMarked);
                        int _tmpNumber = _cursor.getInt(_cursorIndexOfNumber);
                        _item.setNumber(_tmpNumber);
                        String _tmp_5 = _cursor.getString(_cursorIndexOfCid);
                        CID _tmpCid = Converter.toCID(_tmp_5);
                        _item.setCid(_tmpCid);
                        long _tmpExpire = _cursor.getLong(_cursorIndexOfExpire);
                        _item.setExpire(_tmpExpire);
                        String _tmp_6 = _cursor.getString(_cursorIndexOfMembers);
                        Members _tmpMembers = Members.toMembers(_tmp_6);
                        _item.setMembers(_tmpMembers);
                        String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                        _item.setMimeType(_tmpMimeType);
                        int _tmp_7 = _cursor.getInt(_cursorIndexOfPinned);
                        boolean _tmpPinned = _tmp_7 != 0;
                        _item.setPinned(_tmpPinned);
                        int _tmp_8 = _cursor.getInt(_cursorIndexOfPublishing);
                        boolean _tmpPublishing = _tmp_8 != 0;
                        _item.setPublishing(_tmpPublishing);
                        int _tmp_9 = _cursor.getInt(_cursorIndexOfLeaching);
                        boolean _tmpLeaching = _tmp_9 != 0;
                        _item.setLeaching(_tmpLeaching);
                        int _tmp_10 = _cursor.getInt(_cursorIndexOfRequest);
                        boolean _tmpRequest = _tmp_10 != 0;
                        _item.setRequest(_tmpRequest);
                        int _tmp_11 = _cursor.getInt(_cursorIndexOfBlocked);
                        boolean _tmpBlocked = _tmp_11 != 0;
                        _item.setBlocked(_tmpBlocked);
                        String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                        _item.setTitle(_tmpTitle);
                        String _tmp_12 = _cursor.getString(_cursorIndexOfAdditionals);
                        Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_12);
                        _item.setAdditionals(_tmpAdditionals);
                        String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                        _item.setHash(_tmpHash);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        _item.setTimestamp(_tmpTimestamp);
                        _result.add(_item);
                    }
                    ArrayList<Thread> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status getStatus(long idx) {
        String _sql = "SELECT status FROM Thread WHERE idx = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT status FROM Thread WHERE idx = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, idx);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            Status _result;
            if (_cursor.moveToFirst()) {
                Integer _tmp = _cursor.isNull(0) ? null : Integer.valueOf(_cursor.getInt(0));
                _result = Status.toStatus(_tmp);
            } else {
                _result = null;
            }
            Status status = _result;
            return status;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMarkedFlag(long idx) {
        String _sql = "SELECT marked FROM Thread WHERE idx = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT marked FROM Thread WHERE idx = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, idx);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _tmp;
            boolean _result = _cursor.moveToFirst() ? (_tmp = _cursor.getInt(0)) != 0 : false;
            boolean bl = _result;
            return bl;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setThreadsStatus(Status status, long ... idxs) {
        this.__db.assertNotSuspendingTransaction();
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("UPDATE Thread SET status = ");
        _stringBuilder.append("?");
        _stringBuilder.append("  WHERE idx IN (");
        int _inputSize = idxs.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        Integer _tmp = Status.toInteger(status);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 2;
        for (long _item : idxs) {
            _stmt.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setThreadsPublishing(boolean publish, long ... idxs) {
        this.__db.assertNotSuspendingTransaction();
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("UPDATE Thread SET publishing = ");
        _stringBuilder.append("?");
        _stringBuilder.append("  WHERE idx IN (");
        int _inputSize = idxs.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        int _tmp = publish ? 1 : 0;
        _stmt.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        for (long _item : idxs) {
            _stmt.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setThreadsLeaching(boolean leaching, long ... idxs) {
        this.__db.assertNotSuspendingTransaction();
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("UPDATE Thread SET leaching = ");
        _stringBuilder.append("?");
        _stringBuilder.append("  WHERE idx IN (");
        int _inputSize = idxs.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        int _tmp = leaching ? 1 : 0;
        _stmt.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        for (long _item : idxs) {
            _stmt.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetNumber(long ... idxs) {
        this.__db.assertNotSuspendingTransaction();
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("UPDATE Thread SET number = 0 WHERE idx IN (");
        int _inputSize = idxs.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        for (long _item : idxs) {
            _stmt.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetThreadNumber(long ... threads) {
        this.__db.assertNotSuspendingTransaction();
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("UPDATE Thread SET number = 0 WHERE thread IN (");
        int _inputSize = threads.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        for (long _item : threads) {
            _stmt.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementNumber(long ... idxs) {
        this.__db.assertNotSuspendingTransaction();
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("UPDATE Thread SET number = number + 1  WHERE idx IN(");
        int _inputSize = idxs.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        for (long _item : idxs) {
            _stmt.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }
}

