/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import java.util.HashMap;
import threads.core.api.Additionals;
import threads.core.api.Content;
import threads.core.api.Note;
import threads.core.api.Thread;
import threads.ipfs.api.CID;
import threads.ipfs.api.Encryption;

public class NoteRequestEncoder {
    @NonNull
    public static Content convert(@NonNull Thread thread, @NonNull Note note, @NonNull String publicKey, boolean addImage, boolean addTitle) throws Exception {
        String title;
        CID image;
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)publicKey);
        Preconditions.checkNotNull((Object)note);
        Preconditions.checkArgument((!publicKey.isEmpty() ? 1 : 0) != 0);
        Content content = new Content();
        String sesKey = note.getSesKey();
        content.put("pid", note.getSenderPid().getPid());
        content.put("pkey", note.getSenderKey());
        content.put("alias", Encryption.encrypt((String)note.getSenderAlias(), (String)sesKey));
        if (!sesKey.isEmpty()) {
            content.put("skey", Encryption.encryptRSA((String)sesKey, (String)publicKey));
        }
        content.put("id", String.valueOf(thread.getTimestamp()));
        if (addImage && (image = thread.getImage()) != null) {
            content.put("img", image.getCid());
        }
        if (addTitle && (title = thread.getTitle()) != null) {
            content.put("title", Encryption.encrypt((String)title, (String)sesKey));
        }
        HashMap<String, String> additions = note.getExternalAdditions();
        Preconditions.checkNotNull(additions);
        if (!additions.isEmpty()) {
            content.put("adds", Encryption.encrypt((String)Additionals.toString(additions), (String)sesKey));
        }
        return content;
    }
}

