/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import com.google.gson.Gson;
import java.util.HashMap;
import threads.core.api.Additionals;
import threads.core.api.Content;
import threads.core.api.Kind;
import threads.core.api.Note;
import threads.core.api.NoteType;
import threads.core.api.Status;
import threads.core.api.Thread;
import threads.iota.Entity;
import threads.ipfs.api.CID;
import threads.ipfs.api.Encryption;
import threads.ipfs.api.PID;

public class NoteDecoder {
    private static final String TAG = NoteDecoder.class.getSimpleName();

    @Nullable
    public static Note convert(@NonNull Thread thread, @NonNull Entity entity) {
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)entity);
        Gson gson = new Gson();
        Content content = (Content)gson.fromJson(entity.getContent(), Content.class);
        Note note = NoteDecoder.convert(thread, content);
        if (note != null) {
            note.setHash(entity.getHash());
        }
        return note;
    }

    @Nullable
    public static Note convert(@NonNull Thread thread, @NonNull Content content) {
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)content);
        try {
            String sesKey = thread.getSesKey();
            String estType = (String)content.get("est");
            Preconditions.checkNotNull((Object)estType);
            NoteType noteType = NoteType.toNoteType(Integer.valueOf(estType));
            String senderPid = (String)content.get("pid");
            Preconditions.checkNotNull((Object)senderPid);
            String senderKey = (String)content.get("pkey");
            Preconditions.checkNotNull((Object)senderKey);
            String date = (String)content.get("date");
            Preconditions.checkNotNull((Object)date);
            long timestamp = Long.valueOf(date);
            String additions = (String)content.get("adds");
            Preconditions.checkNotNull((Object)additions);
            additions = Encryption.decrypt((String)additions, (String)sesKey);
            CID cid = null;
            String cidValue = (String)content.get("cid");
            if (cidValue != null) {
                cidValue = Encryption.decrypt((String)cidValue, (String)sesKey);
                cid = CID.create((String)cidValue);
            }
            CID image = null;
            String imgValue = (String)content.get("img");
            if (imgValue != null) {
                imgValue = Encryption.decrypt((String)imgValue, (String)sesKey);
                image = CID.create((String)imgValue);
            }
            String senderAlias = (String)content.get("alias");
            Preconditions.checkNotNull((Object)senderAlias);
            senderAlias = Encryption.decrypt((String)senderAlias, (String)sesKey);
            String mimeType = (String)content.get("type");
            Preconditions.checkNotNull((Object)mimeType);
            mimeType = Encryption.decrypt((String)mimeType, (String)sesKey);
            Note note = Note.createNote(thread.getIdx(), PID.create((String)senderPid), senderAlias, senderKey, sesKey, Status.INIT, Kind.IN, noteType, mimeType, timestamp);
            note.setCid(cid);
            note.setImage(image);
            note.setTimestamp(timestamp);
            if (!additions.isEmpty()) {
                HashMap<String, String> adds = Additionals.toHashMap(additions);
                Preconditions.checkNotNull(adds);
                note.setExternalAdditions(adds);
            }
            return note;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            return null;
        }
    }
}

