/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.util.Base64;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import com.google.gson.Gson;
import java.util.HashMap;
import threads.core.api.Additionals;
import threads.core.api.Content;
import threads.core.api.Kind;
import threads.core.api.Status;
import threads.core.api.Thread;
import threads.iota.Entity;
import threads.ipfs.api.CID;
import threads.ipfs.api.Encryption;
import threads.ipfs.api.PID;

public class NoteRequestDecoder {
    private static final String TAG = NoteRequestDecoder.class.getSimpleName();

    @Nullable
    public static Thread convert(@NonNull Entity entity, @NonNull String privateKey) {
        Preconditions.checkNotNull((Object)privateKey);
        Preconditions.checkNotNull((Object)entity);
        Gson gson = new Gson();
        Content content = (Content)gson.fromJson(entity.getContent(), Content.class);
        Thread thread = NoteRequestDecoder.convert(content, privateKey);
        if (thread != null) {
            thread.setHash(entity.getHash());
        }
        return thread;
    }

    @Nullable
    public static Thread convert(@NonNull Content content, @NonNull String privateKey) {
        Preconditions.checkNotNull((Object)privateKey);
        Preconditions.checkNotNull((Object)content);
        try {
            String title;
            String sesKey = "";
            String encSesKey = (String)content.get("skey");
            if (encSesKey != null) {
                sesKey = Encryption.decryptRSA((String)encSesKey, (String)privateKey);
            }
            String senderPid = (String)content.get("pid");
            Preconditions.checkNotNull((Object)senderPid);
            String senderKey = (String)content.get("pkey");
            Preconditions.checkNotNull((Object)senderKey);
            String senderAlias = (String)content.get("alias");
            Preconditions.checkNotNull((Object)senderAlias);
            senderAlias = new String(Base64.decode((String)senderAlias, (int)0));
            String id = (String)content.get("id");
            Preconditions.checkNotNull((Object)id);
            long timestamp = Long.valueOf(id);
            String additions = (String)content.get("adds");
            CID image = null;
            String imgValue = (String)content.get("img");
            if (imgValue != null) {
                image = CID.create((String)imgValue);
            }
            if ((title = (String)content.get("title")) != null) {
                title = new String(Base64.decode((String)title, (int)0));
            }
            Thread newThread = Thread.createThread(Status.INIT, PID.create((String)senderPid), senderAlias, senderKey, sesKey, Kind.IN, timestamp, 0L);
            newThread.setRequest(true);
            newThread.setTitle(title);
            newThread.setImage(image);
            newThread.setTimestamp(timestamp);
            newThread.addMember(PID.create((String)senderPid));
            if (additions != null && additions.isEmpty()) {
                HashMap<String, String> adds = Additionals.toHashMap(additions);
                Preconditions.checkNotNull(adds);
                newThread.setExternalAdditions(adds);
            }
            return newThread;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            return null;
        }
    }
}

