/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import java.util.HashMap;
import threads.core.api.Additionals;
import threads.core.api.Content;
import threads.core.api.Note;
import threads.core.api.Thread;
import threads.ipfs.api.CID;
import threads.ipfs.api.Encryption;

public class NoteRequestEncoder {
    @NonNull
    public static Content convert(@NonNull Thread thread, @NonNull Note note, @NonNull String publicKey) throws Exception {
        String title;
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)publicKey);
        Preconditions.checkNotNull((Object)note);
        Preconditions.checkArgument((!publicKey.isEmpty() ? 1 : 0) != 0);
        Content content = new Content();
        String sesKey = note.getSesKey();
        content.put("pid", note.getSenderPid().getPid());
        content.put("pubKey", note.getSenderKey());
        content.put("alias", Base64.encodeToString((byte[])note.getSenderAlias().getBytes(), (int)0));
        if (!sesKey.isEmpty()) {
            content.put("sesKey", Encryption.encryptRSA((String)sesKey, (String)publicKey));
        }
        CID cid = thread.getCid();
        Preconditions.checkNotNull((Object)cid);
        content.put("thread", cid.getCid());
        CID image = thread.getImage();
        if (image != null) {
            content.put("img", image.getCid());
        }
        if ((title = thread.getTitle()) != null) {
            content.put("title", Base64.encodeToString((byte[])title.getBytes(), (int)0));
        }
        HashMap<String, String> additions = note.getExternalAdditions();
        Preconditions.checkNotNull(additions);
        if (!additions.isEmpty()) {
            content.put("adds", Additionals.toString(additions));
        }
        return content;
    }
}

