/*
 * Decompiled with CFR 0.152.
 */
package threads.core;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import threads.core.IdentityService;
import threads.core.Network;
import threads.core.Preferences;
import threads.core.Singleton;
import threads.core.api.Addresses;
import threads.core.api.Members;
import threads.core.api.PeerInfo;
import threads.core.api.Thread;
import threads.ipfs.IPFS;
import threads.ipfs.api.PID;

public class ConnectService {
    private static final String TAG = ConnectService.class.getSimpleName();

    public static boolean connectPeer(@NonNull Context context, @NonNull PID pid, @NonNull String aesKey, boolean supportDiscovery, boolean updateUser, int timeout) {
        PeerInfo peer;
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)aesKey);
        Preconditions.checkNotNull((Object)pid);
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0);
        if (!Network.isConnected(context)) {
            return false;
        }
        if (supportDiscovery && (peer = IdentityService.getPeerInfo(context, pid, aesKey, updateUser)) != null && ConnectService.swarmConnect(context, peer, "")) {
            return true;
        }
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        if (ipfs != null) {
            ipfs.swarmConnect(pid, timeout);
            return ipfs.isConnected(pid);
        }
        return false;
    }

    public static void swarmUnProtect(@NonNull Context context, @NonNull PeerInfo peer, @NonNull String tag) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)peer);
        Preconditions.checkNotNull((Object)tag);
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        if (ipfs != null) {
            Addresses addresses = peer.getAddresses();
            for (String relay : addresses.keySet()) {
                PID pid = PID.create((String)relay);
                if (tag.isEmpty()) continue;
                ipfs.unProtectPeer(pid, tag);
            }
        }
    }

    public static boolean swarmConnect(@NonNull Context context, @NonNull PeerInfo peer, @NonNull String tag) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)peer);
        int timeout = Preferences.getSwarmTimeout(context);
        Singleton.ConsoleListener consoleListener = Singleton.getInstance(context).getConsoleListener();
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        if (ipfs != null) {
            Addresses addresses = peer.getAddresses();
            for (String relay : addresses.keySet()) {
                try {
                    String ma = (String)addresses.get(relay);
                    Preconditions.checkNotNull((Object)ma);
                    PID relayPID = PID.create((String)relay);
                    boolean relayConnected = ipfs.isConnected(relayPID);
                    if (!relayConnected) {
                        relayConnected = ipfs.swarmConnect(ma + "/" + IPFS.Style.p2p.name() + "/" + relay, timeout);
                    }
                    if (relayConnected && !tag.isEmpty()) {
                        ipfs.protectPeer(PID.create((String)relay), tag);
                    }
                    if (!relayConnected) continue;
                    String address = ipfs.relayAddress(ma, relayPID, peer.getPID());
                    ipfs.swarmConnect(address, timeout);
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            return ipfs.isConnected(peer.getPID());
        }
        return false;
    }

    public static List<Future<Boolean>> connectMembersAsync(@NonNull Context context, @NonNull Thread thread, @NonNull String aesKey, boolean supportDiscovery, boolean updateUser, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)aesKey);
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0);
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        Members members = thread.getMembers();
        for (PID pid : members) {
            Future<Boolean> future = executorService.submit(() -> {
                try {
                    return ConnectService.connectPeer(context, pid, aesKey, supportDiscovery, updateUser, timeout);
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                    return false;
                }
            });
            futures.add(future);
        }
        return futures;
    }

    public static boolean connectMembers(@NonNull Context context, @NonNull Thread thread, @NonNull String aesKey, boolean supportDiscovery, boolean updateUser, int timeout, boolean shortcut) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)aesKey);
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0);
        boolean result = true;
        List<Future<Boolean>> futures = ConnectService.connectMembersAsync(context, thread, aesKey, supportDiscovery, updateUser, timeout);
        for (Future<Boolean> future : futures) {
            try {
                if (future.get().booleanValue()) continue;
                result = false;
                if (!shortcut) continue;
                return result;
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                result = false;
            }
        }
        return result;
    }
}

