package threads.core.api;

import androidx.annotation.NonNull;

import java.util.HashMap;

import threads.ipfs.api.CID;
import threads.ipfs.api.Encryption;

import static androidx.core.util.Preconditions.checkArgument;
import static androidx.core.util.Preconditions.checkNotNull;

public class NoteRequestEncoder {


    @NonNull
    public static Content convert(@NonNull Thread thread,
                                  @NonNull Note note,
                                  @NonNull String publicKey) throws Exception {
        checkNotNull(thread);
        checkNotNull(publicKey);
        checkNotNull(note);
        checkArgument(!publicKey.isEmpty());
        Content content = new Content();

        String sesKey = note.getSesKey();

        // NOT ENCRYPTED
        content.put(Content.PID, note.getSenderPid().getPid());

        // NOT ENCRYPTED
        content.put(Content.PKEY, note.getSenderKey());

        // NOT ENCRYPTED
        content.put(Content.DATE, String.valueOf(note.getDate()));

        // ENCRYPTED
        content.put(Content.ALIAS, Encryption.encrypt(note.getSenderAlias(), sesKey));

        // ENCRYPTED
        if (!sesKey.isEmpty()) {
            content.put(Content.SKEY, Encryption.encryptRSA(sesKey, publicKey));
        }

        // NOT ENCRYPTED
        CID cid = thread.getCid();
        checkNotNull(cid);
        content.put(Content.THREAD, cid.getCid());

        // NOT ENCRYPTED
        CID image = thread.getImage();
        if (image != null) {
            content.put(Content.IMG, image.getCid());
        }

        String title = thread.getTitle();
        if (title != null) {
            content.put(Content.TITLE, title);
        }

        // NOT ENCRYPTED
        HashMap<String, String> additions = note.getExternalAdditions();
        checkNotNull(additions);
        if (!additions.isEmpty()) {
            content.put(Content.ADDS, Additionals.toString(additions));
        }

        return content;
    }
}
