/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import androidx.room.ColumnInfo;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverters;
import java.util.Comparator;
import java.util.Objects;
import threads.core.api.Converter;
import threads.core.api.Entity;
import threads.core.api.IPeer;
import threads.ipfs.api.CID;
import threads.ipfs.api.PID;

@androidx.room.Entity
public class Peer
extends Entity
implements IPeer,
Comparable<Peer> {
    public static Comparator<Peer> PeerComparator = (peer1, peer2) -> peer1.compareTo((Peer)peer2);
    @PrimaryKey
    @NonNull
    @ColumnInfo(name="pid")
    private final String pid;
    @NonNull
    @ColumnInfo(name="multiAddress")
    private String multiAddress;
    @ColumnInfo(name="isRelay")
    private boolean isRelay;
    @ColumnInfo(name="isAutonat")
    private boolean isAutonat;
    @ColumnInfo(name="isPubsub")
    private boolean isPubsub;
    @ColumnInfo(name="rating")
    private int rating;
    @NonNull
    @ColumnInfo(name="alias")
    private String alias;
    @Nullable
    @ColumnInfo(name="image")
    @TypeConverters(value={Converter.class})
    private CID image;
    @ColumnInfo(name="connected")
    private boolean connected;

    Peer(@NonNull String pid, @NonNull String multiAddress) {
        this.pid = pid;
        this.multiAddress = multiAddress;
        this.isRelay = false;
        this.isAutonat = false;
        this.isPubsub = false;
        this.rating = 0;
        this.alias = pid;
        this.image = null;
        this.connected = false;
    }

    public static Peer createPeer(@NonNull PID pid, @NonNull String multiAddress) {
        Preconditions.checkNotNull((Object)pid);
        Preconditions.checkNotNull((Object)multiAddress);
        return new Peer(pid.getPid(), multiAddress);
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    @Override
    public boolean isDialing() {
        return false;
    }

    @Override
    @NonNull
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(@NonNull String alias) {
        this.alias = alias;
    }

    @Override
    @Nullable
    public CID getImage() {
        return this.image;
    }

    public void setImage(@Nullable CID image) {
        this.image = image;
    }

    public boolean isPubsub() {
        return this.isPubsub;
    }

    public void setPubsub(boolean pubsub) {
        this.isPubsub = pubsub;
    }

    public boolean isAutonat() {
        return this.isAutonat;
    }

    public void setAutonat(boolean autonat) {
        this.isAutonat = autonat;
    }

    public int getRating() {
        return this.rating;
    }

    public void setRating(int rating) {
        this.rating = rating;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Peer peer = (Peer)o;
        return this.pid.equals(peer.pid);
    }

    public String toString() {
        return "Peer{pid='" + this.pid + '\'' + ", multiAddress='" + this.multiAddress + '\'' + ", isRelay=" + this.isRelay + ", isAutonat=" + this.isAutonat + ", isPubsub=" + this.isPubsub + ", rating=" + this.rating + '}';
    }

    public int hashCode() {
        return Objects.hash(this.pid);
    }

    @NonNull
    public String getPid() {
        return this.pid;
    }

    public boolean isRelay() {
        return this.isRelay;
    }

    public void setRelay(boolean relay) {
        this.isRelay = relay;
    }

    @NonNull
    public String getMultiAddress() {
        return this.multiAddress;
    }

    public void setMultiAddress(@NonNull String multiAddress) {
        Preconditions.checkNotNull((Object)multiAddress);
        this.multiAddress = multiAddress;
    }

    @Override
    public int compareTo(@NonNull Peer peer) {
        return Double.compare(peer.rating, this.rating);
    }

    @Override
    public PID getPID() {
        return PID.create((String)this.getPid());
    }

    public boolean areItemsTheSame(@NonNull Peer peer) {
        Preconditions.checkNotNull((Object)peer);
        return this.pid.equals(peer.pid);
    }

    @Override
    public boolean isBlocked() {
        return true;
    }

    public boolean sameContent(@NonNull Peer peer) {
        Preconditions.checkNotNull((Object)peer);
        if (this == peer) {
            return true;
        }
        return Objects.equals(this.connected, peer.isConnected()) && Objects.equals(this.alias, peer.getAlias()) && Objects.equals(true, peer.isBlocked()) && Objects.equals(this.image, peer.getImage());
    }

    @Override
    public boolean areItemsTheSame(@NonNull IPeer peer) {
        Preconditions.checkNotNull((Object)peer);
        if (peer instanceof Peer) {
            return this.areItemsTheSame((Peer)peer);
        }
        return false;
    }

    @Override
    public boolean sameContent(@NonNull IPeer peer) {
        Preconditions.checkNotNull((Object)peer);
        if (peer instanceof Peer) {
            return this.sameContent((Peer)peer);
        }
        return false;
    }
}

