/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import com.google.gson.Gson;
import threads.core.api.Additionals;
import threads.core.api.Content;
import threads.core.api.Kind;
import threads.core.api.Status;
import threads.core.api.Thread;
import threads.iota.Entity;
import threads.ipfs.api.CID;
import threads.ipfs.api.Encryption;
import threads.ipfs.api.PID;

public class NoteRequestDecoder {
    private static final String TAG = NoteRequestDecoder.class.getSimpleName();

    @Nullable
    public static Thread convert(@NonNull Entity entity, @NonNull String privateKey) {
        Preconditions.checkNotNull((Object)privateKey);
        Preconditions.checkNotNull((Object)entity);
        Gson gson = new Gson();
        Content content = (Content)gson.fromJson(entity.getContent(), Content.class);
        Thread thread = NoteRequestDecoder.convert(content, privateKey);
        if (thread != null) {
            thread.setHash(entity.getHash());
        }
        return thread;
    }

    @Nullable
    public static Thread convert(@NonNull Content content, @NonNull String privateKey) {
        Preconditions.checkNotNull((Object)privateKey);
        Preconditions.checkNotNull((Object)content);
        try {
            String sesKey = "";
            String encSesKey = (String)content.get("sesKey");
            if (encSesKey != null) {
                sesKey = Encryption.decryptRSA((String)encSesKey, (String)privateKey);
            }
            String senderPid = (String)content.get("pid");
            Preconditions.checkNotNull((Object)senderPid);
            String senderKey = (String)content.get("pubKey");
            Preconditions.checkNotNull((Object)senderKey);
            String date = (String)content.get("date");
            Preconditions.checkNotNull((Object)date);
            long timestamp = Long.valueOf(date);
            String senderAlias = (String)content.get("alias");
            Preconditions.checkNotNull((Object)senderAlias);
            senderAlias = Encryption.decrypt((String)senderAlias, (String)sesKey);
            String thread = (String)content.get("thread");
            Preconditions.checkNotNull((Object)thread);
            thread = Encryption.decrypt((String)thread, (String)sesKey);
            String additions = (String)content.get("adds");
            Preconditions.checkNotNull((Object)additions);
            additions = Encryption.decrypt((String)additions, (String)sesKey);
            CID image = null;
            String imgValue = (String)content.get("img");
            if (imgValue != null) {
                imgValue = Encryption.decrypt((String)imgValue, (String)sesKey);
                image = CID.create((String)imgValue);
            }
            Thread newThread = Thread.createThread(Status.INIT, PID.create((String)senderPid), senderAlias, senderKey, sesKey, Kind.IN, Long.valueOf(date), 0L);
            newThread.setRequest(true);
            newThread.setCid(CID.create((String)thread));
            newThread.setImage(image);
            newThread.setTimestamp(timestamp);
            newThread.addMember(PID.create((String)senderPid));
            if (!additions.isEmpty()) {
                newThread.setExternalAdditions(Additionals.toHashMap(additions));
            }
            return newThread;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            return null;
        }
    }
}

