/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import androidx.room.ColumnInfo;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverters;
import java.util.Objects;
import threads.core.api.AddressType;
import threads.core.api.Converter;
import threads.core.api.Entity;
import threads.core.api.Kind;
import threads.core.api.Members;
import threads.core.api.Status;
import threads.ipfs.api.CID;
import threads.ipfs.api.PID;

@androidx.room.Entity
public class Thread
extends Entity {
    @ColumnInfo(name="thread")
    private final long thread;
    @NonNull
    @TypeConverters(value={Kind.class})
    @ColumnInfo(name="kind")
    private final Kind kind;
    @NonNull
    @TypeConverters(value={Converter.class})
    @ColumnInfo(name="senderPid")
    private final PID senderPid;
    @NonNull
    @ColumnInfo(name="senderKey")
    private final String senderKey;
    @NonNull
    @ColumnInfo(name="sesKey")
    private final String sesKey;
    @ColumnInfo(name="date")
    private long date;
    @NonNull
    @ColumnInfo(name="senderAlias")
    private String senderAlias;
    @PrimaryKey(autoGenerate=true)
    private long idx;
    @Nullable
    @ColumnInfo(name="image")
    @TypeConverters(value={Converter.class})
    private CID image;
    @ColumnInfo(name="marked")
    private boolean marked;
    @ColumnInfo(name="number")
    private int number = 0;
    @Nullable
    @TypeConverters(value={Converter.class})
    @ColumnInfo(name="cid")
    private CID cid;
    @ColumnInfo(name="expire")
    private long expire;
    @NonNull
    @TypeConverters(value={Status.class})
    @ColumnInfo(name="status")
    private Status status;
    @NonNull
    @TypeConverters(value={Members.class})
    @ColumnInfo(name="members")
    private Members members = new Members();
    @NonNull
    @ColumnInfo(name="mimeType")
    private String mimeType;
    @ColumnInfo(name="pinned")
    private boolean pinned;
    @ColumnInfo(name="publishing")
    private boolean publishing;
    @ColumnInfo(name="leaching")
    private boolean leaching;
    @ColumnInfo(name="request")
    private boolean request;
    @ColumnInfo(name="blocked")
    private boolean blocked;

    Thread(@NonNull Status status, @NonNull PID senderPid, @NonNull String senderAlias, @NonNull String senderKey, @NonNull String sesKey, @NonNull Kind kind, long date, long thread) {
        this.thread = thread;
        this.senderPid = senderPid;
        this.senderAlias = senderAlias;
        this.senderKey = senderKey;
        this.sesKey = sesKey;
        this.kind = kind;
        this.expire = System.currentTimeMillis();
        this.status = status;
        this.marked = false;
        this.date = date;
        this.mimeType = "text/plain";
        this.pinned = false;
        this.publishing = false;
        this.request = false;
        this.blocked = false;
        this.leaching = false;
    }

    public static Thread createThread(@NonNull Status status, @NonNull PID senderPid, @NonNull String senderAlias, @NonNull String senderKey, @NonNull String sesKey, @NonNull Kind kind, long date, long thread) {
        Preconditions.checkNotNull((Object)((Object)status));
        Preconditions.checkNotNull((Object)senderPid);
        Preconditions.checkNotNull((Object)senderAlias);
        Preconditions.checkNotNull((Object)senderKey);
        Preconditions.checkNotNull((Object)sesKey);
        Preconditions.checkNotNull((Object)((Object)kind));
        return new Thread(status, senderPid, senderAlias, senderKey, sesKey, kind, date, thread);
    }

    public boolean isLeaching() {
        return this.leaching;
    }

    public void setLeaching(boolean leaching) {
        this.leaching = leaching;
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void setMarked(boolean marked) {
        this.marked = marked;
    }

    public long getDate() {
        return this.date;
    }

    public void setDate(long date) {
        this.date = date;
    }

    public long getExpire() {
        return this.expire;
    }

    public void setExpire(long expire) {
        this.expire = expire;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public boolean isRequest() {
        return this.request;
    }

    public void setRequest(boolean request) {
        this.request = request;
    }

    public boolean isPublishing() {
        return this.publishing;
    }

    public void setPublishing(boolean publishing) {
        this.publishing = publishing;
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public void setPinned(boolean pinned) {
        this.pinned = pinned;
    }

    public long getIdx() {
        return this.idx;
    }

    void setIdx(long idx) {
        this.idx = idx;
    }

    @NonNull
    public String getSenderBox() {
        return AddressType.getAddress(this.getSenderPid(), AddressType.INBOX);
    }

    @NonNull
    public String getSenderKey() {
        return this.senderKey;
    }

    @NonNull
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(@NonNull String mimeType) {
        this.mimeType = mimeType;
    }

    @NonNull
    public PID getSenderPid() {
        return this.senderPid;
    }

    public long getExpireDate() {
        return this.expire;
    }

    public void setExpireDate(long expireDate) {
        this.expire = expireDate;
    }

    @NonNull
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(@NonNull Status status) {
        Preconditions.checkNotNull((Object)((Object)status));
        this.status = status;
    }

    @NonNull
    public Kind getKind() {
        return this.kind;
    }

    @NonNull
    public Members getMembers() {
        return this.members;
    }

    public void setMembers(@NonNull Members members) {
        this.members = members;
    }

    public boolean addMember(@NonNull PID pid) {
        Preconditions.checkNotNull((Object)pid);
        return this.members.add(pid);
    }

    public boolean removeMember(@NonNull PID pid) {
        Preconditions.checkNotNull((Object)pid);
        return this.members.remove(pid);
    }

    public boolean sameThread(@NonNull Thread o) {
        Preconditions.checkNotNull((Object)o);
        if (this == o) {
            return true;
        }
        return Objects.equals(this.cid, o.getCid()) && Objects.equals(this.senderPid, o.getSenderPid()) && Objects.equals(this.image, o.getImage()) && Objects.equals(this.date, o.getDate());
    }

    public boolean sameContent(@NonNull Thread o) {
        Preconditions.checkNotNull((Object)o);
        if (this == o) {
            return true;
        }
        return this.number == o.getNumber() && this.marked == o.isMarked() && this.status == o.getStatus() && this.pinned == o.isPinned() && this.publishing == o.isPublishing() && this.leaching == o.isLeaching() && this.request == o.isRequest() && this.blocked == o.isBlocked() && Objects.equals(this.cid, o.getCid()) && Objects.equals(this.senderAlias, o.getSenderAlias()) && Objects.equals(this.image, o.getImage()) && Objects.equals(this.date, o.getDate());
    }

    @Nullable
    public CID getImage() {
        return this.image;
    }

    public void setImage(@Nullable CID image) {
        this.image = image;
    }

    public boolean areItemsTheSame(@NonNull Thread thread) {
        Preconditions.checkNotNull((Object)thread);
        return this.idx == thread.getIdx();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Thread thread = (Thread)o;
        return this.getIdx() == thread.getIdx();
    }

    public int hashCode() {
        return Objects.hash(this.getIdx());
    }

    @Nullable
    public CID getCid() {
        return this.cid;
    }

    public void setCid(@Nullable CID cid) {
        this.cid = cid;
    }

    @NonNull
    public String getSenderAlias() {
        return this.senderAlias;
    }

    public void setSenderAlias(@NonNull String senderAlias) {
        Preconditions.checkNotNull((Object)senderAlias);
        this.senderAlias = senderAlias;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public long getThread() {
        return this.thread;
    }

    @NonNull
    public String getSesKey() {
        return this.sesKey;
    }

    public void increaseUnreadMessagesNumber() {
        ++this.number;
    }

    public boolean isEncrypted() {
        return !this.sesKey.isEmpty();
    }

    public boolean isExpired() {
        return this.getExpire() < System.currentTimeMillis();
    }
}

