/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.lifecycle.LiveData;
import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.TypeConverters;
import androidx.room.Update;
import java.util.List;
import threads.core.api.Converter;
import threads.core.api.Kind;
import threads.core.api.Note;
import threads.core.api.NoteType;
import threads.core.api.Status;
import threads.ipfs.api.CID;
import threads.ipfs.api.PID;

@Dao
public interface NoteDao {
    @Insert(onConflict=1)
    public long insertNote(Note var1);

    @Insert(onConflict=1)
    public void insertNotes(Note ... var1);

    @Query(value="SELECT * FROM Note WHERE kind LIKE :kind AND status LIKE :status")
    @TypeConverters(value={Kind.class, Status.class})
    public List<Note> getNotesByKindAndStatus(Kind var1, Status var2);

    @Query(value="SELECT hash FROM Note WHERE idx = :idx ")
    public String getHash(long var1);

    @Query(value="UPDATE Note SET status = :status WHERE idx = :idx")
    @TypeConverters(value={Status.class})
    public void setStatus(long var1, Status var3);

    @Query(value="UPDATE Note SET status = :status WHERE idx IN(:idxs)")
    @TypeConverters(value={Status.class})
    public void setNotesStatus(Status var1, long ... var2);

    @Query(value="UPDATE Note SET status = :newStatus WHERE status = :oldStatus")
    @TypeConverters(value={Status.class})
    public void setStatus(Status var1, Status var2);

    @Query(value="UPDATE Note SET cid = :cid WHERE idx = :idx")
    @TypeConverters(value={Converter.class})
    public void setCid(long var1, CID var3);

    @Query(value="UPDATE Note SET publishing = 0")
    public void resetNotesPublishing();

    @Query(value="UPDATE Note SET leaching = 0")
    public void resetNotesLeaching();

    @Query(value="UPDATE Note SET publishing = :publish  WHERE idx = :idx")
    public void setPublishing(long var1, boolean var3);

    @Query(value="UPDATE Note SET leaching = :leaching  WHERE idx = :idx")
    public void setLeaching(long var1, boolean var3);

    @Query(value="UPDATE Note SET publishing = :publish  WHERE idx IN (:idxs)")
    public void setNotesPublishing(boolean var1, long ... var2);

    @Query(value="UPDATE Note SET leaching = :leaching  WHERE idx IN (:idxs)")
    public void setNotesLeaching(boolean var1, long ... var2);

    @Query(value="UPDATE Note SET senderAlias = :alias  WHERE idx = :idx")
    public void setSenderAlias(long var1, String var3);

    @Query(value="UPDATE Note SET senderAlias = :alias  WHERE senderPid = :pid")
    @TypeConverters(value={Converter.class})
    public void setSenderAlias(PID var1, String var2);

    @Query(value="UPDATE Note SET hash = :hash WHERE idx = :idx")
    public void setHash(long var1, String var3);

    @Query(value="SELECT * FROM Note")
    public List<Note> getNotes();

    @Query(value="UPDATE Note SET mimeType =:mimeType  WHERE idx = :idx")
    public void setMimeType(long var1, String var3);

    @Query(value="SELECT * FROM Note WHERE cid = :cid")
    @TypeConverters(value={Converter.class})
    public List<Note> getNotesByCID(CID var1);

    @Query(value="SELECT * FROM Note WHERE senderPid = :pid AND status = :status")
    @TypeConverters(value={Converter.class, Status.class})
    public List<Note> getNotesBySenderPIDAndStatus(PID var1, Status var2);

    @Query(value="SELECT * FROM Note WHERE idx =:idx")
    public Note getNoteByIdx(long var1);

    @Query(value="SELECT * FROM Note WHERE thread =:thread")
    public List<Note> getNotesByThread(long var1);

    @Query(value="SELECT * FROM Note WHERE date =:date")
    public List<Note> getNotesByDate(long var1);

    @Query(value="SELECT * FROM Note WHERE thread =:thread")
    public LiveData<List<Note>> getLiveDataNotesByThread(long var1);

    @Query(value="SELECT * FROM Note")
    public LiveData<List<Note>> getLiveDataNotes();

    @Update(onConflict=1)
    public void updateNote(Note var1);

    @Delete
    public void removeNote(Note var1);

    @Query(value="SELECT mimeType FROM Note WHERE idx = :idx")
    public String getMimeType(long var1);

    @Query(value="SELECT * FROM Note WHERE expire < :date")
    public List<Note> getExpiredNotes(long var1);

    @Query(value="DELETE FROM Note")
    public void clear();

    @Query(value="SELECT * FROM Note WHERE noteType =:type")
    @TypeConverters(value={NoteType.class})
    public List<Note> getNotesByType(NoteType var1);

    @Query(value="SELECT COUNT(idx) FROM Note WHERE cid =:cid OR image =:cid")
    @TypeConverters(value={Converter.class})
    public int references(CID var1);

    @Query(value="UPDATE Note SET image = :image WHERE idx = :idx")
    @TypeConverters(value={Converter.class})
    public void setImage(long var1, CID var3);

    @Query(value="UPDATE Note SET blocked = :blocked WHERE senderPid = :pid")
    @TypeConverters(value={Converter.class})
    public void setSenderBlocked(PID var1, boolean var2);

    @Query(value="SELECT status FROM Note WHERE idx = :idx")
    @TypeConverters(value={Status.class})
    public Status getStatus(long var1);

    @Query(value="SELECT noteType FROM Note WHERE idx = :idx")
    @TypeConverters(value={NoteType.class})
    public NoteType getNoteType(long var1);
}

