/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import androidx.room.ColumnInfo;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverters;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import threads.core.api.AddressType;
import threads.core.api.Converter;
import threads.core.api.Entity;
import threads.core.api.Kind;
import threads.core.api.NoteType;
import threads.core.api.Status;
import threads.ipfs.api.CID;
import threads.ipfs.api.PID;

@androidx.room.Entity
public class Note
extends Entity {
    @NonNull
    @TypeConverters(value={Converter.class})
    @ColumnInfo(name="senderPid")
    private final PID senderPid;
    @NonNull
    @ColumnInfo(name="senderKey")
    private final String senderKey;
    @NonNull
    @ColumnInfo(name="sesKey")
    private final String sesKey;
    @NonNull
    @TypeConverters(value={Kind.class})
    @ColumnInfo(name="kind")
    private final Kind kind;
    @ColumnInfo(name="thread")
    private final long thread;
    @NonNull
    @TypeConverters(value={NoteType.class})
    @ColumnInfo(name="noteType")
    private final NoteType noteType;
    @NonNull
    @ColumnInfo(name="mimeType")
    private final String mimeType;
    @ColumnInfo(name="date")
    private final long date;
    @NonNull
    @ColumnInfo(name="senderAlias")
    private String senderAlias;
    @PrimaryKey(autoGenerate=true)
    private long idx;
    @Nullable
    @TypeConverters(value={Converter.class})
    @ColumnInfo(name="cid")
    private CID cid;
    @NonNull
    @TypeConverters(value={Status.class})
    @ColumnInfo(name="status")
    private Status status;
    @Nullable
    @ColumnInfo(name="image")
    @TypeConverters(value={Converter.class})
    private CID image;
    @ColumnInfo(name="publishing")
    private boolean publishing;
    @ColumnInfo(name="leaching")
    private boolean leaching;
    @ColumnInfo(name="expire")
    private long expire;
    @ColumnInfo(name="blocked")
    private boolean blocked;

    Note(long thread, @NonNull PID senderPid, @NonNull String senderAlias, @NonNull String senderKey, @NonNull String sesKey, @NonNull String mimeType, @NonNull Status status, @NonNull Kind kind, @NonNull NoteType noteType, long date) {
        this.thread = thread;
        this.senderPid = senderPid;
        this.senderAlias = senderAlias;
        this.senderKey = senderKey;
        this.sesKey = sesKey;
        this.mimeType = mimeType;
        this.status = status;
        this.kind = kind;
        this.noteType = noteType;
        this.date = date;
        this.publishing = false;
        this.leaching = false;
        this.blocked = false;
        this.expire = System.currentTimeMillis() + TimeUnit.DAYS.toMillis(365L);
    }

    public static Note createNote(long thread, @NonNull PID senderPid, @NonNull String senderAlias, @NonNull String senderKey, @NonNull String sesKey, @NonNull Status status, @NonNull Kind kind, @NonNull NoteType noteType, @NonNull String mimeType, long date) {
        Preconditions.checkNotNull((Object)senderPid);
        Preconditions.checkNotNull((Object)senderAlias);
        Preconditions.checkNotNull((Object)senderKey);
        Preconditions.checkNotNull((Object)sesKey);
        Preconditions.checkNotNull((Object)((Object)status));
        Preconditions.checkNotNull((Object)((Object)kind));
        Preconditions.checkNotNull((Object)((Object)noteType));
        Preconditions.checkNotNull((Object)mimeType);
        return new Note(thread, senderPid, senderAlias, senderKey, sesKey, mimeType, status, kind, noteType, date);
    }

    public boolean isLeaching() {
        return this.leaching;
    }

    public void setLeaching(boolean leaching) {
        this.leaching = leaching;
    }

    public long getExpire() {
        return this.expire;
    }

    public void setExpire(long expire) {
        this.expire = expire;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public boolean isPublishing() {
        return this.publishing;
    }

    public void setPublishing(boolean publishing) {
        this.publishing = publishing;
    }

    @Nullable
    public CID getImage() {
        return this.image;
    }

    public void setImage(@Nullable CID image) {
        this.image = image;
    }

    @NonNull
    public String getSenderBox() {
        return AddressType.getAddress(this.getSenderPid(), AddressType.INBOX);
    }

    @NonNull
    public String getSenderKey() {
        return this.senderKey;
    }

    @NonNull
    public String getSesKey() {
        return this.sesKey;
    }

    @NonNull
    public PID getSenderPid() {
        return this.senderPid;
    }

    @NonNull
    public String getMimeType() {
        return this.mimeType;
    }

    public long getIdx() {
        return this.idx;
    }

    void setIdx(long idx) {
        this.idx = idx;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Note that = (Note)o;
        return Objects.equals(this.idx, that.idx);
    }

    public int hashCode() {
        return Objects.hash(this.idx);
    }

    @NonNull
    public String getSenderAlias() {
        return this.senderAlias;
    }

    public void setSenderAlias(@NonNull String senderAlias) {
        Preconditions.checkNotNull((Object)senderAlias);
        this.senderAlias = senderAlias;
    }

    @NonNull
    public Kind getKind() {
        return this.kind;
    }

    @NonNull
    public NoteType getNoteType() {
        return this.noteType;
    }

    public long getDate() {
        return this.date;
    }

    public boolean areItemsTheSame(@NonNull Note note) {
        Preconditions.checkNotNull((Object)note);
        return this.idx == note.getIdx();
    }

    public long getThread() {
        return this.thread;
    }

    @NonNull
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(@NonNull Status status) {
        this.status = status;
    }

    public boolean sameContent(@NonNull Note o) {
        Preconditions.checkNotNull((Object)o);
        if (this == o) {
            return true;
        }
        return this.noteType == o.getNoteType() && this.status == o.getStatus() && this.publishing == o.isPublishing() && this.leaching == o.isLeaching() && this.blocked == o.isBlocked() && this.date == o.getDate() && Objects.equals(this.cid, o.getCid()) && Objects.equals(this.senderAlias, o.getSenderAlias()) && Objects.equals(this.image, o.getImage());
    }

    public boolean sameNote(@NonNull Note o) {
        Preconditions.checkNotNull((Object)o);
        if (this == o) {
            return true;
        }
        return this.noteType == o.getNoteType() && this.date == o.getDate() && Objects.equals(this.cid, o.getCid()) && Objects.equals(this.thread, o.getThread()) && Objects.equals(this.senderPid, o.getSenderPid()) && Objects.equals(this.image, o.getImage());
    }

    @NonNull
    public String toString() {
        return "Note{senderAlias='" + this.senderAlias + '\'' + ", senderPid='" + this.senderPid + '\'' + ", senderKey='" + this.senderKey + '\'' + ", sesKey='" + this.sesKey + '\'' + ", kind=" + (Object)((Object)this.kind) + ", thread='" + this.thread + '\'' + ", noteType=" + (Object)((Object)this.noteType) + ", mimeType='" + this.mimeType + '\'' + ", date=" + this.date + ", idx=" + this.idx + ", cid='" + this.cid + '\'' + ", status=" + (Object)((Object)this.status) + '}';
    }

    public boolean isEncrypted() {
        return !this.sesKey.isEmpty();
    }

    @Nullable
    public CID getCid() {
        return this.cid;
    }

    public void setCid(@Nullable CID cid) {
        this.cid = cid;
    }
}

