/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverters;
import threads.core.api.MessageKind;

@Entity
public class Message {
    @NonNull
    @ColumnInfo(name="message")
    private final String message;
    @ColumnInfo(name="timestamp")
    private final long timestamp;
    @NonNull
    @TypeConverters(value={MessageKind.class})
    @ColumnInfo(name="messageKind")
    private final MessageKind messageKind;
    @PrimaryKey(autoGenerate=true)
    private long idx;

    Message(@NonNull MessageKind messageKind, @NonNull String message, long timestamp) {
        Preconditions.checkNotNull((Object)message);
        this.message = message;
        this.messageKind = messageKind;
        this.timestamp = timestamp;
    }

    static Message createMessage(@NonNull MessageKind messageKind, @NonNull String message, long timestamp) {
        Preconditions.checkNotNull((Object)((Object)messageKind));
        Preconditions.checkNotNull((Object)message);
        return new Message(messageKind, message, timestamp);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @NonNull
    public MessageKind getMessageKind() {
        return this.messageKind;
    }

    @NonNull
    public String toString() {
        return "Message{message='" + this.message + '\'' + ", timestamp=" + this.timestamp + ", messageKind=" + (Object)((Object)this.messageKind) + ", idx=" + this.idx + '}';
    }

    public long getIdx() {
        return this.idx;
    }

    public void setIdx(long idx) {
        this.idx = idx;
    }

    @NonNull
    public String getMessage() {
        return this.message;
    }

    public boolean areItemsTheSame(@NonNull Message message) {
        Preconditions.checkNotNull((Object)message);
        return message.idx == this.idx;
    }

    public boolean sameContent(@NonNull Message message) {
        Preconditions.checkNotNull((Object)message);
        return this.areItemsTheSame(message);
    }
}

