package threads.core.api;

import androidx.annotation.NonNull;

import java.util.HashMap;

import threads.ipfs.api.CID;
import threads.ipfs.api.Encryption;

import static androidx.core.util.Preconditions.checkArgument;
import static androidx.core.util.Preconditions.checkNotNull;

public class NoteRequestEncoder {


    @NonNull
    public static Content convert(@NonNull Thread thread,
                                  @NonNull Note note,
                                  @NonNull String publicKey) throws Exception {
        checkNotNull(thread);
        checkNotNull(publicKey);
        checkNotNull(note);
        checkArgument(!publicKey.isEmpty());
        Content content = new Content();

        String sesKey = note.getSesKey();

        // NOT ENCRYPTED
        content.put(Content.PID, note.getSenderPid().getPid());

        // NOT ENCRYPTED
        content.put(Content.PKEY, note.getSenderKey());

        // NOT ENCRYPTED
        content.put(Content.DATE, String.valueOf(note.getDate()));

        // ENCRYPTED
        content.put(Content.ALIAS, Encryption.encrypt(note.getSenderAlias(), sesKey));

        // ENCRYPTED
        if (!sesKey.isEmpty()) {
            content.put(Content.SKEY, Encryption.encryptRSA(sesKey, publicKey));
        }

        // ENCRYPTED
        CID threadCid = thread.getCid();
        checkNotNull(threadCid);
        content.put(Content.THREAD, Encryption.encrypt(threadCid.getCid(), sesKey));


        // ENCRYPTED
        HashMap<String, String> additions = note.getExternalAdditions();
        checkNotNull(additions);
        content.put(Content.ADDS, Encryption.encrypt(Additionals.toString(additions), sesKey));


        return content;
    }
}
