/*
 * Decompiled with CFR 0.152.
 */
package threads.core.mdl;

import android.app.Application;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.LiveData;
import threads.core.Singleton;
import threads.core.api.Event;
import threads.core.api.EventsDatabase;

public class EventViewModel
extends AndroidViewModel {
    private final EventsDatabase eventsDatabase;

    public EventViewModel(@NonNull Application application) {
        super(application);
        this.eventsDatabase = Singleton.getInstance(application.getApplicationContext()).getEventsDatabase();
    }

    public LiveData<Event> getIPFSInstallFailure() {
        return this.eventsDatabase.eventDao().getEvent("IPFS_INSTALL_FAILURE");
    }

    public LiveData<Event> getIPFSStartFailure() {
        return this.eventsDatabase.eventDao().getEvent("IPFS_START_FAILURE");
    }

    public LiveData<Event> getException() {
        return this.eventsDatabase.eventDao().getEvent("EXCEPTION");
    }

    public LiveData<Event> getWarning() {
        return this.eventsDatabase.eventDao().getEvent("WARNING");
    }

    public LiveData<Event> getInfo() {
        return this.eventsDatabase.eventDao().getEvent("INFO");
    }

    public LiveData<Event> getEvent(@NonNull String event) {
        Preconditions.checkNotNull((Object)event);
        return this.eventsDatabase.eventDao().getEvent(event);
    }

    public void removeEvent(@NonNull Event event) {
        new Thread(() -> this.eventsDatabase.eventDao().deleteEvent(event)).start();
    }
}

