/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.lifecycle.LiveData;
import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.TypeConverters;
import androidx.room.Update;
import java.util.List;
import threads.core.api.Converter;
import threads.core.api.User;
import threads.core.api.UserType;
import threads.ipfs.api.CID;

@Dao
public interface UserDao {
    @Insert(onConflict=1)
    public void insertUsers(User ... var1);

    @Update(onConflict=1)
    public void updateUser(User var1);

    @Query(value="DELETE FROM User")
    public void clear();

    @Query(value="SELECT * FROM User")
    public List<User> getUsers();

    @Query(value="SELECT * FROM User WHERE blocked = :blocked")
    public List<User> getBlockedUsers(boolean var1);

    @Query(value="SELECT * FROM User WHERE autoConnect = :autoConnect")
    public List<User> getAutoConnectUsers(boolean var1);

    @Query(value="SELECT pid FROM User")
    public List<String> getUserPids();

    @Query(value="UPDATE User SET hash = :hash WHERE pid = :pid")
    public void setHash(String var1, String var2);

    @Query(value="UPDATE User SET alias = :alias WHERE pid = :pid")
    public void setAlias(String var1, String var2);

    @Query(value="UPDATE User SET publicKey = :publicKey WHERE pid = :pid")
    public void setPublicKey(String var1, String var2);

    @Query(value="UPDATE User SET image = :image WHERE pid = :pid")
    @TypeConverters(value={Converter.class})
    public void setImage(String var1, CID var2);

    @Query(value="SELECT publicKey FROM User WHERE pid = :pid ")
    public String getPublicKey(String var1);

    @Query(value="SELECT alias FROM User WHERE pid = :pid ")
    public String getAlias(String var1);

    @Query(value="SELECT * FROM User WHERE pid = :pid")
    public User getUserByPid(String var1);

    @Query(value="SELECT * FROM User WHERE pid IN (:pids)")
    public List<User> getUsersByPid(String ... var1);

    @Query(value="SELECT * FROM User WHERE pid = :pid")
    public LiveData<User> getLiveDataUser(String var1);

    @Query(value="DELETE FROM User WHERE pid = :pid")
    public void removeUserByPid(String var1);

    @Query(value="DELETE FROM User WHERE pid IN (:pids)")
    public void removeUsersByPid(String ... var1);

    @Query(value="SELECT * FROM User")
    public LiveData<List<User>> getLiveDataUsers();

    @Query(value="UPDATE User SET dialing = 0")
    public void resetUsersDialing();

    @Query(value="SELECT * FROM User WHERE type = :type")
    @TypeConverters(value={UserType.class})
    public LiveData<List<User>> getLiveDataUsersByType(UserType var1);

    @Query(value="UPDATE User SET type = :type WHERE pid = :pid")
    @TypeConverters(value={UserType.class})
    public void setUserType(String var1, UserType var2);

    @Query(value="UPDATE User SET dialing = :dialing WHERE pid = :pid")
    public void setUserDialing(String var1, boolean var2);

    @Query(value="SELECT * FROM User WHERE hash =:hash")
    public User getUserByHash(String var1);

    @Delete
    public void removeUsers(User ... var1);

    @Query(value="SELECT COUNT(*) FROM User WHERE pid = :pid")
    public long hasUser(String var1);

    @Query(value="SELECT dialing FROM User WHERE pid = :pid")
    public boolean getUserDialing(String var1);

    @Query(value="UPDATE User SET connected = 0")
    public void resetUsersConnected();

    @Query(value="UPDATE User SET connected = :connected WHERE pid = :pid")
    public void setConnected(String var1, boolean var2);

    @Query(value="SELECT connected FROM User WHERE pid = :pid ")
    public boolean isConnected(String var1);

    @Query(value="SELECT autoConnect FROM User WHERE pid = :pid ")
    public boolean isAutoConnect(String var1);

    @Query(value="UPDATE User SET autoConnect = :autoConnect WHERE pid = :pid")
    public void setAutoConnect(String var1, boolean var2);

    @Query(value="UPDATE User SET blocked = :blocked WHERE pid = :pid")
    public void setBlocked(String var1, boolean var2);

    @Query(value="SELECT blocked FROM User WHERE pid = :pid ")
    public boolean isBlocked(String var1);
}

