/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import androidx.room.ColumnInfo;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverters;
import java.util.Objects;
import threads.core.api.Converter;
import threads.core.api.Entity;
import threads.core.api.IPeer;
import threads.core.api.UserType;
import threads.ipfs.api.CID;
import threads.ipfs.api.PID;

@androidx.room.Entity
public class User
extends Entity
implements IPeer {
    @PrimaryKey
    @NonNull
    @ColumnInfo(name="pid")
    private final String pid;
    @NonNull
    @ColumnInfo(name="publicKey")
    private String publicKey;
    @NonNull
    @ColumnInfo(name="alias")
    private String alias;
    @NonNull
    @TypeConverters(value={UserType.class})
    @ColumnInfo(name="type")
    private UserType type;
    @ColumnInfo(name="autoConnect")
    private boolean autoConnect;
    @ColumnInfo(name="connected")
    private boolean connected;
    @Nullable
    @ColumnInfo(name="image")
    @TypeConverters(value={Converter.class})
    private CID image;
    @ColumnInfo(name="blocked")
    private boolean blocked;
    @ColumnInfo(name="dialing")
    private boolean dialing;

    User(@NonNull UserType type, @NonNull String alias, @NonNull String publicKey, @NonNull String pid, @Nullable CID image) {
        this.type = type;
        this.alias = alias;
        this.publicKey = publicKey;
        this.pid = pid;
        this.image = image;
        this.blocked = false;
        this.dialing = false;
        this.connected = false;
        this.autoConnect = false;
    }

    @NonNull
    public static User createUser(@NonNull UserType type, @NonNull String alias, @NonNull String publicKey, @NonNull PID pid, @Nullable CID image) {
        Preconditions.checkNotNull((Object)((Object)type));
        Preconditions.checkNotNull((Object)alias);
        Preconditions.checkNotNull((Object)publicKey);
        Preconditions.checkNotNull((Object)pid);
        return new User(type, alias, publicKey, pid.getPid(), image);
    }

    public boolean isAutoConnect() {
        return this.autoConnect;
    }

    public void setAutoConnect(boolean autoConnect) {
        this.autoConnect = autoConnect;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    @Override
    public boolean isDialing() {
        return this.dialing;
    }

    public void setDialing(boolean dialing) {
        this.dialing = dialing;
    }

    @Override
    public boolean isBlocked() {
        return this.blocked;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    @NonNull
    public UserType getType() {
        return this.type;
    }

    public void setType(@NonNull UserType type) {
        Preconditions.checkNotNull((Object)((Object)type));
        this.type = type;
    }

    @NonNull
    String getPid() {
        return this.pid;
    }

    @Override
    @NonNull
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(@NonNull String alias) {
        this.alias = alias;
    }

    @NonNull
    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(@NonNull String publicKey) {
        Preconditions.checkNotNull((Object)publicKey);
        this.publicKey = publicKey;
    }

    @Override
    @Nullable
    public CID getImage() {
        return this.image;
    }

    public void setImage(@Nullable CID image) {
        this.image = image;
    }

    @NonNull
    public String getSesKey() {
        return "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.pid, user.pid);
    }

    public int hashCode() {
        return Objects.hash(this.pid);
    }

    public boolean areItemsTheSame(@NonNull User user) {
        Preconditions.checkNotNull((Object)user);
        return this.pid.equals(user.pid);
    }

    public boolean sameContent(@NonNull User user) {
        Preconditions.checkNotNull((Object)user);
        if (this == user) {
            return true;
        }
        return Objects.equals(this.connected, user.isConnected()) && Objects.equals(this.autoConnect, user.isAutoConnect()) && Objects.equals(this.dialing, user.isDialing()) && Objects.equals(this.alias, user.getAlias()) && Objects.equals(this.blocked, user.isBlocked()) && Objects.equals(this.image, user.getImage());
    }

    @Override
    public PID getPID() {
        return PID.create((String)this.pid);
    }

    @Override
    public boolean areItemsTheSame(@NonNull IPeer peer) {
        Preconditions.checkNotNull((Object)peer);
        if (peer instanceof User) {
            return this.areItemsTheSame((User)peer);
        }
        return false;
    }

    @Override
    public boolean sameContent(@NonNull IPeer peer) {
        Preconditions.checkNotNull((Object)peer);
        if (peer instanceof User) {
            return this.sameContent((User)peer);
        }
        return false;
    }
}

