/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import androidx.room.ColumnInfo;
import androidx.room.TypeConverters;
import java.util.HashMap;
import java.util.Map;
import threads.core.api.Additional;
import threads.core.api.Additionals;

public class Entity {
    @NonNull
    @TypeConverters(value={Additionals.class})
    @ColumnInfo(name="additionals")
    private Additionals additionals = new Additionals();
    @Nullable
    @ColumnInfo(name="hash")
    private String hash;
    @ColumnInfo(name="timestamp")
    private long timestamp = System.currentTimeMillis();

    Entity() {
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Nullable
    public String getHash() {
        return this.hash;
    }

    public void setHash(@Nullable String hash) {
        this.hash = hash;
    }

    public boolean hasHash() {
        return this.hash != null;
    }

    @NonNull
    public Additionals getAdditionals() {
        return this.additionals;
    }

    public void setAdditionals(@NonNull Additionals additionals) {
        Preconditions.checkNotNull((Object)additionals);
        this.additionals = additionals;
    }

    public void removeAdditionals() {
        this.additionals.clear();
    }

    public void addAdditional(@NonNull String key, @NonNull String value, @NonNull Boolean internal) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkNotNull((Object)internal);
        this.additionals.put(key, Additional.createAdditional(value, internal));
    }

    @Nullable
    public Additional getAdditional(@NonNull String key) {
        Preconditions.checkNotNull((Object)key);
        return (Additional)this.additionals.get(key);
    }

    @NonNull
    public String getAdditionalValue(@NonNull String key) {
        Preconditions.checkNotNull((Object)key);
        Additional additional = (Additional)this.additionals.get(key);
        if (additional != null) {
            return additional.getValue();
        }
        return "";
    }

    public boolean hasAdditional(@NonNull String key) {
        Preconditions.checkNotNull((Object)key);
        return this.additionals.get(key) != null;
    }

    public void removeAdditional(@NonNull String key) {
        Preconditions.checkNotNull((Object)key);
        this.additionals.remove(key);
    }

    @NonNull
    HashMap<String, String> getExternalAdditions() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry entry : this.additionals.entrySet()) {
            Additional additional = (Additional)entry.getValue();
            if (additional.getInternal().booleanValue()) continue;
            hashMap.put((String)entry.getKey(), additional.getValue());
        }
        return hashMap;
    }

    void setExternalAdditions(@NonNull Map<String, String> hashMap) {
        Preconditions.checkNotNull(hashMap);
        for (Map.Entry<String, String> entry : hashMap.entrySet()) {
            this.additionals.put(entry.getKey(), Additional.createAdditional(entry.getValue(), false));
        }
    }
}

