/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import com.google.gson.Gson;
import java.util.HashMap;
import threads.core.api.Additionals;
import threads.core.api.Content;
import threads.core.api.User;
import threads.ipfs.api.Encryption;

public class UserEncoder {
    @NonNull
    public static String convert(@NonNull User user, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)aesKey);
        Content content = new Content();
        content.put("pubKey", user.getPublicKey());
        content.put("alias", user.getAlias());
        content.put("pid", user.getPid());
        HashMap<String, String> additions = user.getExternalAdditions();
        Preconditions.checkNotNull(additions);
        content.put("adds", Additionals.toString(additions));
        Gson gson = new Gson();
        String data = gson.toJson((Object)content);
        try {
            data = Encryption.encrypt((String)data, (String)aesKey);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return data;
    }
}

