/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import androidx.room.TypeConverter;

public enum Status {
    OFFLINE(0),
    ONLINE(1),
    SEEDING(2),
    DELETING(3),
    EXPIRED(4),
    ERROR(5);

    @NonNull
    private final Integer code;

    private Status(Integer code) {
        Preconditions.checkNotNull((Object)code);
        this.code = code;
    }

    @TypeConverter
    public static Status toStatus(Integer status) {
        Preconditions.checkNotNull((Object)status);
        if (status.equals(SEEDING.getCode())) {
            return SEEDING;
        }
        if (status.equals(ONLINE.getCode())) {
            return ONLINE;
        }
        if (status.equals(OFFLINE.getCode())) {
            return OFFLINE;
        }
        if (status.equals(DELETING.getCode())) {
            return DELETING;
        }
        if (status.equals(EXPIRED.getCode())) {
            return EXPIRED;
        }
        if (status.equals(ERROR.getCode())) {
            return ERROR;
        }
        throw new IllegalArgumentException("Could not recognize status");
    }

    @TypeConverter
    public static Integer toInteger(Status status) {
        Preconditions.checkNotNull((Object)((Object)status));
        return status.getCode();
    }

    @NonNull
    private Integer getCode() {
        return this.code;
    }
}

