/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import java.util.HashMap;
import threads.core.api.Additionals;
import threads.core.api.Content;
import threads.core.api.Note;
import threads.core.api.NoteType;
import threads.core.api.Thread;
import threads.ipfs.api.CID;
import threads.ipfs.api.Encryption;

public class NoteEncoder {
    @NonNull
    public static Content convert(@NonNull Thread thread, @NonNull Note note) throws Exception {
        CID image;
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)note);
        Content content = new Content();
        NoteType type = note.getNoteType();
        content.put("est", String.valueOf(type.getCode()));
        content.put("pid", note.getSenderPid().getPid());
        content.put("pubKey", note.getSenderKey());
        content.put("date", String.valueOf(note.getDate()));
        CID cid = note.getCid();
        if (cid != null) {
            content.put("cid", Encryption.encrypt((String)cid.getCid(), (String)note.getSesKey()));
        }
        if ((image = note.getImage()) != null) {
            content.put("img", Encryption.encrypt((String)image.getCid(), (String)note.getSesKey()));
        }
        content.put("type", Encryption.encrypt((String)note.getMimeType(), (String)note.getSesKey()));
        content.put("alias", Encryption.encrypt((String)note.getSenderAlias(), (String)note.getSesKey()));
        HashMap<String, String> additions = note.getExternalAdditions();
        Preconditions.checkNotNull(additions);
        content.put("adds", Encryption.encrypt((String)Additionals.toString(additions), (String)note.getSesKey()));
        return content;
    }
}

