/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import com.google.gson.Gson;
import threads.core.api.Additionals;
import threads.core.api.Content;
import threads.core.api.Kind;
import threads.core.api.Status;
import threads.core.api.Thread;
import threads.iota.Entity;
import threads.ipfs.api.CID;
import threads.ipfs.api.Encryption;
import threads.ipfs.api.PID;

public class ThreadDecoder {
    private static final String TAG = ThreadDecoder.class.getSimpleName();

    @Nullable
    public static Thread convert(@NonNull Entity entity, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)entity);
        Preconditions.checkNotNull((Object)aesKey);
        try {
            String imgValue;
            String data = entity.getContent();
            Gson gson = new Gson();
            Content content = (Content)gson.fromJson(data, Content.class);
            String senderPid = (String)content.get("pid");
            Preconditions.checkNotNull((Object)senderPid);
            String additions = Encryption.decrypt((String)((String)content.get("adds")), (String)aesKey);
            Preconditions.checkNotNull((Object)additions);
            String sesKey = (String)content.get("sesKey");
            Preconditions.checkNotNull((Object)sesKey);
            String senderAlias = Encryption.decrypt((String)((String)content.get("alias")), (String)aesKey);
            Preconditions.checkNotNull((Object)senderAlias);
            String senderKey = (String)content.get("pubKey");
            Preconditions.checkNotNull((Object)senderKey);
            String cidValue = (String)content.get("cid");
            CID cid = null;
            if (cidValue != null) {
                cid = CID.create((String)cidValue);
            }
            String date = (String)content.get("date");
            Preconditions.checkNotNull((Object)date);
            long timestamp = Long.valueOf(date);
            Thread thread = Thread.createThread(Status.ONLINE, PID.create((String)senderPid), senderAlias, senderKey, sesKey, Kind.IN, Long.valueOf(date), 0L);
            thread.setCid(cid);
            if (!additions.isEmpty()) {
                thread.setExternalAdditions(Additionals.toHashMap(additions));
            }
            if ((imgValue = (String)content.get("img")) != null) {
                thread.setImage(CID.create((String)imgValue));
            }
            String expireDate = (String)content.get("exp");
            Preconditions.checkNotNull((Object)expireDate);
            thread.setExpireDate(Long.valueOf(expireDate));
            thread.setMarked(false);
            thread.setHash(entity.getHash());
            thread.setTimestamp(timestamp);
            return thread;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            return null;
        }
    }
}

