/*
 * Decompiled with CFR 0.152.
 */
package threads.core;

import android.text.format.DateFormat;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.iota.jota.utils.TrytesConverter;
import threads.core.api.EventsDatabase;
import threads.core.api.LinkType;
import threads.core.api.Note;
import threads.core.api.NoteType;
import threads.core.api.PeersDatabase;
import threads.core.api.PeersInfoDatabase;
import threads.core.api.Thread;
import threads.core.api.ThreadsAPI;
import threads.core.api.ThreadsDatabase;
import threads.iota.EntityService;
import threads.iota.IOTA;
import threads.ipfs.IPFS;
import threads.ipfs.api.CID;

public class THREADS
extends ThreadsAPI {
    public static final String TAG = THREADS.class.getSimpleName();

    private THREADS(Builder builder) {
        super(builder.threadsDatabase, builder.eventsDatabase, builder.peersInfoDatabase, builder.peersDatabase, builder.entityService);
    }

    @NonNull
    public static String getAddress(@NonNull CID cid) {
        Preconditions.checkNotNull((Object)cid);
        String address = TrytesConverter.asciiToTrytes((String)cid.getCid());
        return IOTA.addChecksum((String)address.substring(0, 81));
    }

    @NonNull
    public static THREADS createThreads(@NonNull ThreadsDatabase threadsDatabase, @NonNull EventsDatabase eventsDatabase, @NonNull PeersInfoDatabase peersInfoDatabase, @NonNull PeersDatabase peersDatabase, @NonNull EntityService entityService) {
        Preconditions.checkNotNull((Object)((Object)threadsDatabase));
        Preconditions.checkNotNull((Object)((Object)eventsDatabase));
        Preconditions.checkNotNull((Object)((Object)peersInfoDatabase));
        Preconditions.checkNotNull((Object)((Object)peersDatabase));
        Preconditions.checkNotNull((Object)entityService);
        return new Builder().threadsDatabase(threadsDatabase).peersInfoDatabase(peersInfoDatabase).peersDatabase(peersDatabase).eventsDatabase(eventsDatabase).entityService(entityService).build();
    }

    @Nullable
    public static LinkType getLinkType(@NonNull Note note) {
        Preconditions.checkNotNull((Object)note);
        if (note.getNoteType() == NoteType.LINK) {
            String linkType = note.getAdditionalValue(LinkType.class.getSimpleName());
            return LinkType.valueOf(linkType);
        }
        return null;
    }

    public static double getLatitude(@NonNull Note note) {
        Preconditions.checkNotNull((Object)note);
        if (note.getNoteType() == NoteType.LOCATION) {
            return Double.valueOf(note.getAdditionalValue("LATITUDE"));
        }
        return Double.NaN;
    }

    public static double getLongitude(@NonNull Note note) {
        Preconditions.checkNotNull((Object)note);
        if (note.getNoteType() == NoteType.LOCATION) {
            return Double.valueOf(note.getAdditionalValue("LONGITUDE"));
        }
        return Double.NaN;
    }

    public static double getZoom(@NonNull Note note) {
        Preconditions.checkNotNull((Object)note);
        if (note.getNoteType() == NoteType.LOCATION) {
            return Double.valueOf(note.getAdditionalValue("ZOOM"));
        }
        return Double.NaN;
    }

    @NonNull
    public static Date getTomorrow() {
        Calendar c = Calendar.getInstance();
        c.add(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    @NonNull
    public static Date getYesterday() {
        Calendar c = Calendar.getInstance();
        c.add(5, -1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    @NonNull
    public static String getDate(@NonNull Date date) {
        Calendar c = Calendar.getInstance();
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date today = c.getTime();
        c.set(2, 0);
        c.set(5, 0);
        Date lastYear = c.getTime();
        if (date.before(today)) {
            if (date.before(lastYear)) {
                return DateFormat.format((CharSequence)"dd.MM.yyyy", (Date)date).toString();
            }
            return DateFormat.format((CharSequence)"dd.MMMM", (Date)date).toString();
        }
        return DateFormat.format((CharSequence)"HH:mm", (Date)date).toString();
    }

    @NonNull
    public static Calendar getUserAgeOffsetCalendar(int offset) {
        Date now = new Date();
        GregorianCalendar init = new GregorianCalendar();
        init.setTime(now);
        int mYear = init.get(1);
        int mMonth = init.get(2);
        int mDay = init.get(5);
        return new GregorianCalendar(mYear - offset, mMonth, mDay);
    }

    static long getOffsetDate(int offsetInYears) {
        return THREADS.getUserAgeOffsetCalendar(offsetInYears).getTime().getTime();
    }

    @NonNull
    public static Date getOffsetYearDate(int offsetInYears) {
        return THREADS.getUserAgeOffsetCalendar(offsetInYears).getTime();
    }

    public static long getTodayDate() {
        return THREADS.getToday().getTime();
    }

    @NonNull
    public static Date getToday() {
        Calendar c = Calendar.getInstance();
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public void setImage(@NonNull IPFS ipfs, @NonNull Thread thread, @NonNull byte[] data) throws Exception {
        Preconditions.checkNotNull((Object)ipfs);
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)data);
        CID image = ipfs.storeData(data);
        if (image != null) {
            this.setImage(thread, image);
        }
    }

    public static class Builder {
        EventsDatabase eventsDatabase = null;
        ThreadsDatabase threadsDatabase = null;
        PeersInfoDatabase peersInfoDatabase = null;
        EntityService entityService = null;
        PeersDatabase peersDatabase = null;

        public THREADS build() {
            Preconditions.checkNotNull((Object)((Object)this.threadsDatabase));
            Preconditions.checkNotNull((Object)((Object)this.eventsDatabase));
            Preconditions.checkNotNull((Object)((Object)this.peersInfoDatabase));
            Preconditions.checkNotNull((Object)((Object)this.peersDatabase));
            Preconditions.checkNotNull((Object)this.entityService);
            return new THREADS(this);
        }

        public Builder threadsDatabase(@NonNull ThreadsDatabase threadsDatabase) {
            Preconditions.checkNotNull((Object)((Object)threadsDatabase));
            this.threadsDatabase = threadsDatabase;
            return this;
        }

        public Builder eventsDatabase(@NonNull EventsDatabase eventsDatabase) {
            Preconditions.checkNotNull((Object)((Object)eventsDatabase));
            this.eventsDatabase = eventsDatabase;
            return this;
        }

        public Builder peersInfoDatabase(@NonNull PeersInfoDatabase peersDatabase) {
            Preconditions.checkNotNull((Object)((Object)peersDatabase));
            this.peersInfoDatabase = peersDatabase;
            return this;
        }

        public Builder entityService(@NonNull EntityService entityService) {
            Preconditions.checkNotNull((Object)entityService);
            this.entityService = entityService;
            return this;
        }

        public Builder peersDatabase(@NonNull PeersDatabase peersDatabase) {
            Preconditions.checkNotNull((Object)((Object)peersDatabase));
            this.peersDatabase = peersDatabase;
            return this;
        }
    }
}

