/*
 * Decompiled with CFR 0.152.
 */
package threads.core;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import androidx.room.Room;
import threads.core.Network;
import threads.core.Preferences;
import threads.core.THREADS;
import threads.core.api.EventsDatabase;
import threads.core.api.Message;
import threads.core.api.MessageKind;
import threads.core.api.PeersDatabase;
import threads.core.api.PeersInfoDatabase;
import threads.core.api.ThreadsDatabase;
import threads.iota.EntityService;
import threads.iota.IOTA;
import threads.ipfs.IPFS;
import threads.ipfs.api.AddressesConfig;
import threads.ipfs.api.ConnMgrConfig;
import threads.ipfs.api.DiscoveryConfig;
import threads.ipfs.api.ExperimentalConfig;
import threads.ipfs.api.PubsubConfig;
import threads.ipfs.api.RoutingConfig;
import threads.ipfs.api.SwarmConfig;

public class Singleton {
    private static Singleton SINGLETON = null;
    private final IOTA iota;
    private final ThreadsDatabase threadsDatabase;
    private final EventsDatabase eventsDatabase;
    private final PeersInfoDatabase peersInfoDatabase;
    private final PeersDatabase peersDatabase;
    private final THREADS threads;
    private final EntityService entityService;
    private final ConsoleListener consoleListener = new ConsoleListener();
    @Nullable
    private IPFS ipfs = null;

    private Singleton(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        this.threadsDatabase = (ThreadsDatabase)Room.databaseBuilder((Context)context, ThreadsDatabase.class, (String)ThreadsDatabase.class.getSimpleName()).fallbackToDestructiveMigration().build();
        this.eventsDatabase = (EventsDatabase)Room.inMemoryDatabaseBuilder((Context)context, EventsDatabase.class).build();
        this.peersInfoDatabase = (PeersInfoDatabase)Room.inMemoryDatabaseBuilder((Context)context, PeersInfoDatabase.class).build();
        this.peersDatabase = (PeersDatabase)Room.databaseBuilder((Context)context, PeersDatabase.class, (String)PeersDatabase.class.getSimpleName()).fallbackToDestructiveMigration().build();
        this.entityService = EntityService.getInstance((Context)context);
        this.threads = THREADS.createThreads(this.threadsDatabase, this.eventsDatabase, this.peersInfoDatabase, this.peersDatabase, this.entityService);
        IOTA.Builder iotaBuilder = new IOTA.Builder();
        iotaBuilder.protocol(EntityService.getTangleProtocol((Context)context));
        iotaBuilder.host(EntityService.getTangleHost((Context)context));
        iotaBuilder.port(EntityService.getTanglePort((Context)context));
        iotaBuilder.timeout(EntityService.getTangleTimeout((Context)context));
        this.iota = iotaBuilder.build();
        int swarmPort = Preferences.getSwarmPort(context);
        if (Preferences.isRandomSwarmPort(context)) {
            swarmPort = Network.nextFreePort();
        }
        Integer quicPort = null;
        if (Preferences.isQUICEnabled(context)) {
            quicPort = swarmPort;
        }
        AddressesConfig addresses = AddressesConfig.create((Integer)swarmPort, (Integer)quicPort);
        ExperimentalConfig experimental = ExperimentalConfig.create();
        experimental.setQUIC(Preferences.isQUICEnabled(context));
        experimental.setPreferTLS(Preferences.isPreferTLS(context));
        PubsubConfig pubsubConfig = PubsubConfig.create();
        pubsubConfig.setRouter(Preferences.getPubsubRouter(context));
        SwarmConfig swarmConfig = SwarmConfig.create();
        swarmConfig.setDisableBandwidthMetrics(true);
        swarmConfig.setDisableNatPortMap(false);
        swarmConfig.setDisableRelay(false);
        swarmConfig.setEnableAutoRelay(Preferences.isAutoRelayEnabled(context));
        swarmConfig.setEnableAutoNATService(Preferences.isAutoNATServiceEnabled(context));
        swarmConfig.setEnableRelayHop(Preferences.isRelayHopEnabled(context));
        ConnMgrConfig mgr = swarmConfig.getConnMgr();
        mgr.setGracePeriod(Preferences.getGracePeriod(context));
        mgr.setHighWater(Preferences.getHighWater(context));
        mgr.setLowWater(Preferences.getLowWater(context));
        mgr.setType(Preferences.getConnMgrConfigType(context));
        DiscoveryConfig discoveryConfig = DiscoveryConfig.create();
        discoveryConfig.getMdns().setEnabled(Preferences.isMdnsEnabled(context));
        RoutingConfig routingConfig = RoutingConfig.create();
        routingConfig.setType(Preferences.getRoutingType(context));
        try {
            this.ipfs = IPFS.getInstance((Context)context, (AddressesConfig)addresses, (ExperimentalConfig)experimental, (PubsubConfig)pubsubConfig, (DiscoveryConfig)discoveryConfig, (SwarmConfig)swarmConfig, (RoutingConfig)routingConfig);
            Preferences.setPID(context, this.ipfs.getPeerID());
        }
        catch (Throwable e) {
            Preferences.evaluateException(this.threads, "IPFS_INSTALL_FAILURE", e);
        }
    }

    @NonNull
    public static Singleton getInstance(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        if (SINGLETON == null) {
            SINGLETON = new Singleton(context);
        }
        return SINGLETON;
    }

    public PeersDatabase getPeersDatabase() {
        return this.peersDatabase;
    }

    @NonNull
    public PeersInfoDatabase getPeersInfoDatabase() {
        return this.peersInfoDatabase;
    }

    @NonNull
    public ConsoleListener getConsoleListener() {
        return this.consoleListener;
    }

    @NonNull
    public IOTA getIota() {
        return this.iota;
    }

    @Nullable
    public IPFS getIpfs() {
        return this.ipfs;
    }

    @NonNull
    public EventsDatabase getEventsDatabase() {
        return this.eventsDatabase;
    }

    @NonNull
    public THREADS getThreads() {
        return this.threads;
    }

    @NonNull
    public ThreadsDatabase getThreadsDatabase() {
        return this.threadsDatabase;
    }

    @NonNull
    public EntityService getEntityService() {
        return this.entityService;
    }

    public class ConsoleListener {
        public void debug(@NonNull String message) {
            long timestamp = System.currentTimeMillis();
            new Thread(() -> {
                Message em = Singleton.this.threads.createMessage(MessageKind.DEBUG, message, timestamp);
                Singleton.this.threads.storeMessage(em);
            }).start();
        }

        public void info(@NonNull String message) {
            long timestamp = System.currentTimeMillis();
            new Thread(() -> {
                Message em = Singleton.this.threads.createMessage(MessageKind.INFO, message, timestamp);
                Singleton.this.threads.storeMessage(em);
            }).start();
        }

        public void error(@NonNull String message) {
            long timestamp = System.currentTimeMillis();
            new Thread(() -> {
                Message em = Singleton.this.threads.createMessage(MessageKind.ERROR, message, timestamp);
                Singleton.this.threads.storeMessage(em);
            }).start();
        }
    }
}

