/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import threads.core.api.Additionals;
import threads.core.api.Converter;
import threads.core.api.User;
import threads.core.api.UserDao;
import threads.core.api.UserType;
import threads.ipfs.api.CID;

public final class UserDao_Impl
implements UserDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfUser;
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfUser;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfUser;
    private final SharedSQLiteStatement __preparedStmtOfClear;
    private final SharedSQLiteStatement __preparedStmtOfSetHash;
    private final SharedSQLiteStatement __preparedStmtOfSetAlias;
    private final SharedSQLiteStatement __preparedStmtOfSetPublicKey;
    private final SharedSQLiteStatement __preparedStmtOfSetImage;
    private final SharedSQLiteStatement __preparedStmtOfRemoveUserByPid;
    private final SharedSQLiteStatement __preparedStmtOfResetUsersDialing;
    private final SharedSQLiteStatement __preparedStmtOfSetUserType;
    private final SharedSQLiteStatement __preparedStmtOfSetUserDialing;
    private final SharedSQLiteStatement __preparedStmtOfResetUsersConnected;
    private final SharedSQLiteStatement __preparedStmtOfSetConnected;
    private final SharedSQLiteStatement __preparedStmtOfSetAutoConnect;
    private final SharedSQLiteStatement __preparedStmtOfSetBlocked;

    public UserDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfUser = new EntityInsertionAdapter<User>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `User`(`pid`,`publicKey`,`alias`,`type`,`autoConnect`,`connected`,`image`,`blocked`,`dialing`,`additionals`,`hash`,`timestamp`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, User value) {
                if (value.getPid() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPid());
                }
                if (value.getPublicKey() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getPublicKey());
                }
                if (value.getAlias() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getAlias());
                }
                Integer _tmp = UserType.toInteger(value.getType());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindLong(4, (long)_tmp.intValue());
                }
                int _tmp_1 = value.isAutoConnect() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_1);
                int _tmp_2 = value.isConnected() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp_2);
                String _tmp_3 = Converter.toString(value.getImage());
                if (_tmp_3 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_3);
                }
                int _tmp_4 = value.isBlocked() ? 1 : 0;
                stmt.bindLong(8, (long)_tmp_4);
                int _tmp_5 = value.isDialing() ? 1 : 0;
                stmt.bindLong(9, (long)_tmp_5);
                String _tmp_6 = Additionals.toString(value.getAdditionals());
                if (_tmp_6 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_6);
                }
                if (value.getHash() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getHash());
                }
                stmt.bindLong(12, value.getTimestamp());
            }
        };
        this.__deletionAdapterOfUser = new EntityDeletionOrUpdateAdapter<User>(__db){

            public String createQuery() {
                return "DELETE FROM `User` WHERE `pid` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, User value) {
                if (value.getPid() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPid());
                }
            }
        };
        this.__updateAdapterOfUser = new EntityDeletionOrUpdateAdapter<User>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `User` SET `pid` = ?,`publicKey` = ?,`alias` = ?,`type` = ?,`autoConnect` = ?,`connected` = ?,`image` = ?,`blocked` = ?,`dialing` = ?,`additionals` = ?,`hash` = ?,`timestamp` = ? WHERE `pid` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, User value) {
                if (value.getPid() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPid());
                }
                if (value.getPublicKey() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getPublicKey());
                }
                if (value.getAlias() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getAlias());
                }
                Integer _tmp = UserType.toInteger(value.getType());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindLong(4, (long)_tmp.intValue());
                }
                int _tmp_1 = value.isAutoConnect() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_1);
                int _tmp_2 = value.isConnected() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp_2);
                String _tmp_3 = Converter.toString(value.getImage());
                if (_tmp_3 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_3);
                }
                int _tmp_4 = value.isBlocked() ? 1 : 0;
                stmt.bindLong(8, (long)_tmp_4);
                int _tmp_5 = value.isDialing() ? 1 : 0;
                stmt.bindLong(9, (long)_tmp_5);
                String _tmp_6 = Additionals.toString(value.getAdditionals());
                if (_tmp_6 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_6);
                }
                if (value.getHash() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getHash());
                }
                stmt.bindLong(12, value.getTimestamp());
                if (value.getPid() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, value.getPid());
                }
            }
        };
        this.__preparedStmtOfClear = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM User";
                return "DELETE FROM User";
            }
        };
        this.__preparedStmtOfSetHash = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE User SET hash = ? WHERE pid = ?";
                return "UPDATE User SET hash = ? WHERE pid = ?";
            }
        };
        this.__preparedStmtOfSetAlias = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE User SET alias = ? WHERE pid = ?";
                return "UPDATE User SET alias = ? WHERE pid = ?";
            }
        };
        this.__preparedStmtOfSetPublicKey = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE User SET publicKey = ? WHERE pid = ?";
                return "UPDATE User SET publicKey = ? WHERE pid = ?";
            }
        };
        this.__preparedStmtOfSetImage = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE User SET image = ? WHERE pid = ?";
                return "UPDATE User SET image = ? WHERE pid = ?";
            }
        };
        this.__preparedStmtOfRemoveUserByPid = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM User WHERE pid = ?";
                return "DELETE FROM User WHERE pid = ?";
            }
        };
        this.__preparedStmtOfResetUsersDialing = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE User SET dialing = 0";
                return "UPDATE User SET dialing = 0";
            }
        };
        this.__preparedStmtOfSetUserType = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE User SET type = ? WHERE pid = ?";
                return "UPDATE User SET type = ? WHERE pid = ?";
            }
        };
        this.__preparedStmtOfSetUserDialing = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE User SET dialing = ? WHERE pid = ?";
                return "UPDATE User SET dialing = ? WHERE pid = ?";
            }
        };
        this.__preparedStmtOfResetUsersConnected = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE User SET connected = 0";
                return "UPDATE User SET connected = 0";
            }
        };
        this.__preparedStmtOfSetConnected = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE User SET connected = ? WHERE pid = ?";
                return "UPDATE User SET connected = ? WHERE pid = ?";
            }
        };
        this.__preparedStmtOfSetAutoConnect = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE User SET autoConnect = ? WHERE pid = ?";
                return "UPDATE User SET autoConnect = ? WHERE pid = ?";
            }
        };
        this.__preparedStmtOfSetBlocked = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE User SET blocked = ? WHERE pid = ?";
                return "UPDATE User SET blocked = ? WHERE pid = ?";
            }
        };
    }

    @Override
    public void insertUsers(User ... users) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfUser.insert((Object[])users);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void removeUsers(User ... users) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfUser.handleMultiple((Object[])users);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateUser(User user) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfUser.handle((Object)user);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void clear() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClear.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClear.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHash(String pid, String hash) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetHash.acquire();
        int _argIndex = 1;
        if (hash == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, hash);
        }
        _argIndex = 2;
        if (pid == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, pid);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetHash.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAlias(String pid, String alias) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetAlias.acquire();
        int _argIndex = 1;
        if (alias == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, alias);
        }
        _argIndex = 2;
        if (pid == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, pid);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetAlias.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPublicKey(String pid, String publicKey) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetPublicKey.acquire();
        int _argIndex = 1;
        if (publicKey == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, publicKey);
        }
        _argIndex = 2;
        if (pid == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, pid);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetPublicKey.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setImage(String pid, CID image) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetImage.acquire();
        int _argIndex = 1;
        String _tmp = Converter.toString(image);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        if (pid == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, pid);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetImage.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUserByPid(String pid) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfRemoveUserByPid.acquire();
        int _argIndex = 1;
        if (pid == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, pid);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfRemoveUserByPid.release(_stmt);
        }
    }

    @Override
    public void resetUsersDialing() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfResetUsersDialing.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfResetUsersDialing.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserType(String pid, UserType type) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetUserType.acquire();
        int _argIndex = 1;
        Integer _tmp = UserType.toInteger(type);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 2;
        if (pid == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, pid);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetUserType.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserDialing(String pid, boolean dialing) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetUserDialing.acquire();
        int _argIndex = 1;
        int _tmp = dialing ? 1 : 0;
        _stmt.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        if (pid == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, pid);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetUserDialing.release(_stmt);
        }
    }

    @Override
    public void resetUsersConnected() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfResetUsersConnected.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfResetUsersConnected.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConnected(String pid, boolean connected) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetConnected.acquire();
        int _argIndex = 1;
        int _tmp = connected ? 1 : 0;
        _stmt.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        if (pid == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, pid);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetConnected.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoConnect(String pid, boolean autoConnect) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetAutoConnect.acquire();
        int _argIndex = 1;
        int _tmp = autoConnect ? 1 : 0;
        _stmt.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        if (pid == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, pid);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetAutoConnect.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlocked(String pid, boolean blocked) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetBlocked.acquire();
        int _argIndex = 1;
        int _tmp = blocked ? 1 : 0;
        _stmt.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        if (pid == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, pid);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetBlocked.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<User> getUsers() {
        String _sql = "SELECT * FROM User";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM User", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
            int _cursorIndexOfPublicKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publicKey");
            int _cursorIndexOfAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"alias");
            int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
            int _cursorIndexOfAutoConnect = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"autoConnect");
            int _cursorIndexOfConnected = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"connected");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfBlocked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blocked");
            int _cursorIndexOfDialing = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dialing");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<User> _result = new ArrayList<User>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpPid = _cursor.getString(_cursorIndexOfPid);
                String _tmpPublicKey = _cursor.getString(_cursorIndexOfPublicKey);
                String _tmpAlias = _cursor.getString(_cursorIndexOfAlias);
                Integer _tmp = _cursor.isNull(_cursorIndexOfType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfType));
                UserType _tmpType = UserType.toUserType(_tmp);
                String _tmp_1 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_1);
                User _item = new User(_tmpType, _tmpAlias, _tmpPublicKey, _tmpPid, _tmpImage);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfAutoConnect);
                boolean _tmpAutoConnect = _tmp_2 != 0;
                _item.setAutoConnect(_tmpAutoConnect);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfConnected);
                boolean _tmpConnected = _tmp_3 != 0;
                _item.setConnected(_tmpConnected);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfBlocked);
                boolean _tmpBlocked = _tmp_4 != 0;
                _item.setBlocked(_tmpBlocked);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfDialing);
                boolean _tmpDialing = _tmp_5 != 0;
                _item.setDialing(_tmpDialing);
                String _tmp_6 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_6);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<User> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<User> getAutoConnectUsers(boolean autoConnect) {
        String _sql = "SELECT * FROM User WHERE autoConnect = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM User WHERE autoConnect = ?", (int)1);
        int _argIndex = 1;
        int _tmp = autoConnect ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
            int _cursorIndexOfPublicKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publicKey");
            int _cursorIndexOfAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"alias");
            int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
            int _cursorIndexOfAutoConnect = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"autoConnect");
            int _cursorIndexOfConnected = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"connected");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfBlocked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blocked");
            int _cursorIndexOfDialing = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dialing");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<User> _result = new ArrayList<User>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpPid = _cursor.getString(_cursorIndexOfPid);
                String _tmpPublicKey = _cursor.getString(_cursorIndexOfPublicKey);
                String _tmpAlias = _cursor.getString(_cursorIndexOfAlias);
                Integer _tmp_1 = _cursor.isNull(_cursorIndexOfType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfType));
                UserType _tmpType = UserType.toUserType(_tmp_1);
                String _tmp_2 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_2);
                User _item = new User(_tmpType, _tmpAlias, _tmpPublicKey, _tmpPid, _tmpImage);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfAutoConnect);
                boolean _tmpAutoConnect = _tmp_3 != 0;
                _item.setAutoConnect(_tmpAutoConnect);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfConnected);
                boolean _tmpConnected = _tmp_4 != 0;
                _item.setConnected(_tmpConnected);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfBlocked);
                boolean _tmpBlocked = _tmp_5 != 0;
                _item.setBlocked(_tmpBlocked);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfDialing);
                boolean _tmpDialing = _tmp_6 != 0;
                _item.setDialing(_tmpDialing);
                String _tmp_7 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_7);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<User> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getUserPids() {
        String _sql = "SELECT pid FROM User";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT pid FROM User", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _item = _cursor.getString(0);
                _result.add(_item);
            }
            ArrayList<String> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPublicKey(String pid) {
        String _sql = "SELECT publicKey FROM User WHERE pid = ? ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT publicKey FROM User WHERE pid = ? ", (int)1);
        int _argIndex = 1;
        if (pid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, pid);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            String _result = _cursor.moveToFirst() ? _cursor.getString(0) : null;
            String string = _result;
            return string;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAlias(String pid) {
        String _sql = "SELECT alias FROM User WHERE pid = ? ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT alias FROM User WHERE pid = ? ", (int)1);
        int _argIndex = 1;
        if (pid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, pid);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            String _result = _cursor.moveToFirst() ? _cursor.getString(0) : null;
            String string = _result;
            return string;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User getUserByPid(String pid) {
        String _sql = "SELECT * FROM User WHERE pid = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM User WHERE pid = ?", (int)1);
        int _argIndex = 1;
        if (pid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, pid);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            User _result;
            int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
            int _cursorIndexOfPublicKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publicKey");
            int _cursorIndexOfAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"alias");
            int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
            int _cursorIndexOfAutoConnect = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"autoConnect");
            int _cursorIndexOfConnected = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"connected");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfBlocked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blocked");
            int _cursorIndexOfDialing = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dialing");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            if (_cursor.moveToFirst()) {
                String _tmpPid = _cursor.getString(_cursorIndexOfPid);
                String _tmpPublicKey = _cursor.getString(_cursorIndexOfPublicKey);
                String _tmpAlias = _cursor.getString(_cursorIndexOfAlias);
                Integer _tmp = _cursor.isNull(_cursorIndexOfType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfType));
                UserType _tmpType = UserType.toUserType(_tmp);
                String _tmp_1 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_1);
                _result = new User(_tmpType, _tmpAlias, _tmpPublicKey, _tmpPid, _tmpImage);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfAutoConnect);
                boolean _tmpAutoConnect = _tmp_2 != 0;
                _result.setAutoConnect(_tmpAutoConnect);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfConnected);
                boolean _tmpConnected = _tmp_3 != 0;
                _result.setConnected(_tmpConnected);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfBlocked);
                boolean _tmpBlocked = _tmp_4 != 0;
                _result.setBlocked(_tmpBlocked);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfDialing);
                boolean _tmpDialing = _tmp_5 != 0;
                _result.setDialing(_tmpDialing);
                String _tmp_6 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_6);
                _result.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _result.setHash(_tmpHash);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _result.setTimestamp(_tmpTimestamp);
            } else {
                _result = null;
            }
            User user = _result;
            return user;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<User> getUsersByPid(String ... pids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM User WHERE pid IN (");
        int _inputSize = pids.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : pids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
            int _cursorIndexOfPublicKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publicKey");
            int _cursorIndexOfAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"alias");
            int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
            int _cursorIndexOfAutoConnect = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"autoConnect");
            int _cursorIndexOfConnected = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"connected");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfBlocked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blocked");
            int _cursorIndexOfDialing = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dialing");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<User> _result = new ArrayList<User>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpPid = _cursor.getString(_cursorIndexOfPid);
                String _tmpPublicKey = _cursor.getString(_cursorIndexOfPublicKey);
                String _tmpAlias = _cursor.getString(_cursorIndexOfAlias);
                Integer _tmp = _cursor.isNull(_cursorIndexOfType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfType));
                UserType _tmpType = UserType.toUserType(_tmp);
                String _tmp_1 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_1);
                User _item_1 = new User(_tmpType, _tmpAlias, _tmpPublicKey, _tmpPid, _tmpImage);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfAutoConnect);
                boolean _tmpAutoConnect = _tmp_2 != 0;
                _item_1.setAutoConnect(_tmpAutoConnect);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfConnected);
                boolean _tmpConnected = _tmp_3 != 0;
                _item_1.setConnected(_tmpConnected);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfBlocked);
                boolean _tmpBlocked = _tmp_4 != 0;
                _item_1.setBlocked(_tmpBlocked);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfDialing);
                boolean _tmpDialing = _tmp_5 != 0;
                _item_1.setDialing(_tmpDialing);
                String _tmp_6 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_6);
                _item_1.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item_1.setHash(_tmpHash);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item_1.setTimestamp(_tmpTimestamp);
                _result.add(_item_1);
            }
            ArrayList<User> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<User> getLiveDataUser(String pid) {
        String _sql = "SELECT * FROM User WHERE pid = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM User WHERE pid = ?", (int)1);
        int _argIndex = 1;
        if (pid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, pid);
        }
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"User"}, false, (Callable)new Callable<User>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public User call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)UserDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false);){
                    User _result;
                    int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
                    int _cursorIndexOfPublicKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publicKey");
                    int _cursorIndexOfAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"alias");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfAutoConnect = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"autoConnect");
                    int _cursorIndexOfConnected = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"connected");
                    int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
                    int _cursorIndexOfBlocked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blocked");
                    int _cursorIndexOfDialing = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dialing");
                    int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
                    int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    if (_cursor.moveToFirst()) {
                        String _tmpPid = _cursor.getString(_cursorIndexOfPid);
                        String _tmpPublicKey = _cursor.getString(_cursorIndexOfPublicKey);
                        String _tmpAlias = _cursor.getString(_cursorIndexOfAlias);
                        Integer _tmp = _cursor.isNull(_cursorIndexOfType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfType));
                        UserType _tmpType = UserType.toUserType(_tmp);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfImage);
                        CID _tmpImage = Converter.toCID(_tmp_1);
                        _result = new User(_tmpType, _tmpAlias, _tmpPublicKey, _tmpPid, _tmpImage);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfAutoConnect);
                        boolean _tmpAutoConnect = _tmp_2 != 0;
                        _result.setAutoConnect(_tmpAutoConnect);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfConnected);
                        boolean _tmpConnected = _tmp_3 != 0;
                        _result.setConnected(_tmpConnected);
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfBlocked);
                        boolean _tmpBlocked = _tmp_4 != 0;
                        _result.setBlocked(_tmpBlocked);
                        int _tmp_5 = _cursor.getInt(_cursorIndexOfDialing);
                        boolean _tmpDialing = _tmp_5 != 0;
                        _result.setDialing(_tmpDialing);
                        String _tmp_6 = _cursor.getString(_cursorIndexOfAdditionals);
                        Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_6);
                        _result.setAdditionals(_tmpAdditionals);
                        String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                        _result.setHash(_tmpHash);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        _result.setTimestamp(_tmpTimestamp);
                    } else {
                        _result = null;
                    }
                    User user = _result;
                    return user;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public LiveData<List<User>> getLiveDataUsers() {
        String _sql = "SELECT * FROM User";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM User", (int)0);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"User"}, false, (Callable)new Callable<List<User>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<User> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)UserDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false);){
                    int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
                    int _cursorIndexOfPublicKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publicKey");
                    int _cursorIndexOfAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"alias");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfAutoConnect = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"autoConnect");
                    int _cursorIndexOfConnected = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"connected");
                    int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
                    int _cursorIndexOfBlocked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blocked");
                    int _cursorIndexOfDialing = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dialing");
                    int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
                    int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    ArrayList<User> _result = new ArrayList<User>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpPid = _cursor.getString(_cursorIndexOfPid);
                        String _tmpPublicKey = _cursor.getString(_cursorIndexOfPublicKey);
                        String _tmpAlias = _cursor.getString(_cursorIndexOfAlias);
                        Integer _tmp = _cursor.isNull(_cursorIndexOfType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfType));
                        UserType _tmpType = UserType.toUserType(_tmp);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfImage);
                        CID _tmpImage = Converter.toCID(_tmp_1);
                        User _item = new User(_tmpType, _tmpAlias, _tmpPublicKey, _tmpPid, _tmpImage);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfAutoConnect);
                        boolean _tmpAutoConnect = _tmp_2 != 0;
                        _item.setAutoConnect(_tmpAutoConnect);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfConnected);
                        boolean _tmpConnected = _tmp_3 != 0;
                        _item.setConnected(_tmpConnected);
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfBlocked);
                        boolean _tmpBlocked = _tmp_4 != 0;
                        _item.setBlocked(_tmpBlocked);
                        int _tmp_5 = _cursor.getInt(_cursorIndexOfDialing);
                        boolean _tmpDialing = _tmp_5 != 0;
                        _item.setDialing(_tmpDialing);
                        String _tmp_6 = _cursor.getString(_cursorIndexOfAdditionals);
                        Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_6);
                        _item.setAdditionals(_tmpAdditionals);
                        String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                        _item.setHash(_tmpHash);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        _item.setTimestamp(_tmpTimestamp);
                        _result.add(_item);
                    }
                    ArrayList<User> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public LiveData<List<User>> getLiveDataUsersByType(UserType type) {
        String _sql = "SELECT * FROM User WHERE type = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM User WHERE type = ?", (int)1);
        int _argIndex = 1;
        Integer _tmp = UserType.toInteger(type);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"User"}, false, (Callable)new Callable<List<User>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<User> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)UserDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false);){
                    int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
                    int _cursorIndexOfPublicKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publicKey");
                    int _cursorIndexOfAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"alias");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfAutoConnect = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"autoConnect");
                    int _cursorIndexOfConnected = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"connected");
                    int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
                    int _cursorIndexOfBlocked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blocked");
                    int _cursorIndexOfDialing = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dialing");
                    int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
                    int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    ArrayList<User> _result = new ArrayList<User>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpPid = _cursor.getString(_cursorIndexOfPid);
                        String _tmpPublicKey = _cursor.getString(_cursorIndexOfPublicKey);
                        String _tmpAlias = _cursor.getString(_cursorIndexOfAlias);
                        Integer _tmp_1 = _cursor.isNull(_cursorIndexOfType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfType));
                        UserType _tmpType = UserType.toUserType(_tmp_1);
                        String _tmp_2 = _cursor.getString(_cursorIndexOfImage);
                        CID _tmpImage = Converter.toCID(_tmp_2);
                        User _item = new User(_tmpType, _tmpAlias, _tmpPublicKey, _tmpPid, _tmpImage);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfAutoConnect);
                        boolean _tmpAutoConnect = _tmp_3 != 0;
                        _item.setAutoConnect(_tmpAutoConnect);
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfConnected);
                        boolean _tmpConnected = _tmp_4 != 0;
                        _item.setConnected(_tmpConnected);
                        int _tmp_5 = _cursor.getInt(_cursorIndexOfBlocked);
                        boolean _tmpBlocked = _tmp_5 != 0;
                        _item.setBlocked(_tmpBlocked);
                        int _tmp_6 = _cursor.getInt(_cursorIndexOfDialing);
                        boolean _tmpDialing = _tmp_6 != 0;
                        _item.setDialing(_tmpDialing);
                        String _tmp_7 = _cursor.getString(_cursorIndexOfAdditionals);
                        Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_7);
                        _item.setAdditionals(_tmpAdditionals);
                        String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                        _item.setHash(_tmpHash);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        _item.setTimestamp(_tmpTimestamp);
                        _result.add(_item);
                    }
                    ArrayList<User> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User getUserByHash(String hash) {
        String _sql = "SELECT * FROM User WHERE hash =?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM User WHERE hash =?", (int)1);
        int _argIndex = 1;
        if (hash == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, hash);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            User _result;
            int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
            int _cursorIndexOfPublicKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publicKey");
            int _cursorIndexOfAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"alias");
            int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
            int _cursorIndexOfAutoConnect = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"autoConnect");
            int _cursorIndexOfConnected = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"connected");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfBlocked = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"blocked");
            int _cursorIndexOfDialing = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dialing");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            if (_cursor.moveToFirst()) {
                String _tmpPid = _cursor.getString(_cursorIndexOfPid);
                String _tmpPublicKey = _cursor.getString(_cursorIndexOfPublicKey);
                String _tmpAlias = _cursor.getString(_cursorIndexOfAlias);
                Integer _tmp = _cursor.isNull(_cursorIndexOfType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfType));
                UserType _tmpType = UserType.toUserType(_tmp);
                String _tmp_1 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_1);
                _result = new User(_tmpType, _tmpAlias, _tmpPublicKey, _tmpPid, _tmpImage);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfAutoConnect);
                boolean _tmpAutoConnect = _tmp_2 != 0;
                _result.setAutoConnect(_tmpAutoConnect);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfConnected);
                boolean _tmpConnected = _tmp_3 != 0;
                _result.setConnected(_tmpConnected);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfBlocked);
                boolean _tmpBlocked = _tmp_4 != 0;
                _result.setBlocked(_tmpBlocked);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfDialing);
                boolean _tmpDialing = _tmp_5 != 0;
                _result.setDialing(_tmpDialing);
                String _tmp_6 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_6);
                _result.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _result.setHash(_tmpHash);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _result.setTimestamp(_tmpTimestamp);
            } else {
                _result = null;
            }
            User user = _result;
            return user;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long hasUser(String pid) {
        String _sql = "SELECT COUNT(*) FROM User WHERE pid = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT COUNT(*) FROM User WHERE pid = ?", (int)1);
        int _argIndex = 1;
        if (pid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, pid);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            long _result = _cursor.moveToFirst() ? _cursor.getLong(0) : 0L;
            long l = _result;
            return l;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getUserDialing(String pid) {
        String _sql = "SELECT dialing FROM User WHERE pid = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT dialing FROM User WHERE pid = ?", (int)1);
        int _argIndex = 1;
        if (pid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, pid);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _tmp;
            boolean _result = _cursor.moveToFirst() ? (_tmp = _cursor.getInt(0)) != 0 : false;
            boolean bl = _result;
            return bl;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected(String pid) {
        String _sql = "SELECT connected FROM User WHERE pid = ? ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT connected FROM User WHERE pid = ? ", (int)1);
        int _argIndex = 1;
        if (pid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, pid);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _tmp;
            boolean _result = _cursor.moveToFirst() ? (_tmp = _cursor.getInt(0)) != 0 : false;
            boolean bl = _result;
            return bl;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAutoConnect(String pid) {
        String _sql = "SELECT autoConnect FROM User WHERE pid = ? ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT autoConnect FROM User WHERE pid = ? ", (int)1);
        int _argIndex = 1;
        if (pid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, pid);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _tmp;
            boolean _result = _cursor.moveToFirst() ? (_tmp = _cursor.getInt(0)) != 0 : false;
            boolean bl = _result;
            return bl;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBlocked(String pid) {
        String _sql = "SELECT blocked FROM User WHERE pid = ? ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT blocked FROM User WHERE pid = ? ", (int)1);
        int _argIndex = 1;
        if (pid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, pid);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _tmp;
            boolean _result = _cursor.moveToFirst() ? (_tmp = _cursor.getInt(0)) != 0 : false;
            boolean bl = _result;
            return bl;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUsersByPid(String ... pids) {
        this.__db.assertNotSuspendingTransaction();
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE FROM User WHERE pid IN (");
        int _inputSize = pids.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        for (String _item : pids) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }
}

