/*
 * Decompiled with CFR 0.152.
 */
package threads.core;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.text.format.DateFormat;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.journeyapps.barcodescanner.BarcodeEncoder;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import threads.core.Singleton;
import threads.core.THREADS;
import threads.ipfs.IPFS;
import threads.ipfs.api.CID;
import threads.ipfs.api.ConnMgrConfig;
import threads.ipfs.api.PID;
import threads.ipfs.api.PubsubConfig;
import threads.ipfs.api.RoutingConfig;

public class Preferences {
    public static final String THREAD_TITLE = "TITLE";
    public static final String THREAD_CONTENT = "THREAD_CONTENT";
    public static final String THREAD_MIME_TYPE = "THREAD_MIME_TYPE";
    public static final String THREAD_DATE = "THREAD_DATE";
    public static final String THREAD_KIND = "THREAD_KIND";
    public static final String LATITUDE = "LATITUDE";
    public static final String LONGITUDE = "LONGITUDE";
    public static final String ZOOM = "ZOOM";
    public static final String EXCEPTION = "EXCEPTION";
    public static final String IPFS_START_FAILURE = "IPFS_START_FAILURE";
    public static final String IPFS_INSTALL_FAILURE = "IPFS_INSTALL_FAILURE";
    public static final String WARNING = "WARNING";
    public static final String INFO = "INFO";
    public static final String SEARCH_SETTINGS_ID = "SEARCH_SETTINGS_ID";
    private static final String PREF_KEY = "prefKey";
    private static final String PID_KEY = "pidKey";
    private static final String TOKEN_KEY = "tokenKey";
    private static final String LOGIN_FLAG_KEY = "loginFlagKey";
    private static final String IPFS_KEY = "ipfsKey";
    private static final String SWARM_PORT_KEY = "swarmPortKey";
    private static final String TOPIC_KEY = "prefTopicKey";
    private static final String QUIC_KEY = "quicKey";
    private static final String PUBSUB_KEY = "pubsubKey";
    private static final String NAT_SERVICE_KEY = "noFetchKey";
    private static final String ENABLE_AUTO_RELAY_KEY = "enableAutoRelayKey";
    private static final String RELAY_HOP_KEY = "relayHopKey";
    private static final String CONN_MGR_CONFIG_TYPE_KEY = "connMgrConfigTypeKey";
    private static final String ROUTING_TYPE_KEY = "routingTypeKey";
    private static final String ROUTER_ENUM_KEY = "routerEnumKey";
    private static final String HIGH_WATER_KEY = "highWaterKey";
    private static final String LOW_WATER_KEY = "lowWaterKey";
    private static final String GRACE_PERIOD_KEY = "gracePeriodKey";
    private static final int QR_CODE_SIZE = 250;
    private static final String TIMEOUT_KEY = "timeoutKey";
    private static final String SWARM_TIMEOUT_KEY = "swarmTimeoutKey";
    private static final String AUDIO_CODEC_KEY = "audioCodecKey";
    private static final String VIDEO_CODEC_KEY = "videoCodecKey";
    private static final String AUDIO_PROCESSING_KEY = "audioProcessingEnabledKey";
    private static final String OPEN_SL_ES_KEY = "openSlEsKey";
    private static final String PREFER_TLS_KEY = "preferTLSKey";
    private static final String AEC_KEY = "aecKey";
    private static final String AGC_KEY = "agcKey";
    private static final String HNS_KEY = "hnsKey";
    private static final String RANDOM_SWARM_KEY = "randomSwarmKey";
    private static final String DEBUG_MODE_KEY = "debugModeKey";
    private static final String REPORT_MODE_KEY = "reportModeKey";
    private static final String MDNS_KEY = "mdnsKey";
    @NonNull
    private static final Hashtable<String, CID> BITMAP_HASH_TABLE = new Hashtable();

    @NonNull
    public static String getToken(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getString(TOKEN_KEY, "");
    }

    public static void setToken(@NonNull Context context, @NonNull String token) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)token);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putString(TOKEN_KEY, token);
        editor.apply();
    }

    public static boolean isRandomSwarmPort(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getBoolean(RANDOM_SWARM_KEY, false);
    }

    public static void setRandomSwarmPort(@NonNull Context context, boolean enable) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putBoolean(RANDOM_SWARM_KEY, enable);
        editor.apply();
    }

    public static boolean isPreferTLS(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getBoolean(PREFER_TLS_KEY, false);
    }

    public static void setPreferTLS(@NonNull Context context, boolean enable) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putBoolean(PREFER_TLS_KEY, enable);
        editor.apply();
    }

    @NonNull
    public static String getAudioCodec(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getString(AUDIO_CODEC_KEY, "opus");
    }

    public static void setAudioCodec(@NonNull Context context, @NonNull String codec) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)codec);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putString(AUDIO_CODEC_KEY, codec);
        editor.apply();
    }

    @NonNull
    public static String getVideoCodec(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getString(VIDEO_CODEC_KEY, "VP9");
    }

    public static void setVideoCodec(@NonNull Context context, @NonNull String codec) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)codec);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putString(VIDEO_CODEC_KEY, codec);
        editor.apply();
    }

    public static boolean isAutomaticGainControlEnabled(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getBoolean(AGC_KEY, true);
    }

    public static void setAutomaticGainControlEnabled(@NonNull Context context, boolean enable) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putBoolean(AGC_KEY, enable);
        editor.apply();
    }

    public static boolean isHardwareNoiseSuppressorEnabled(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getBoolean(HNS_KEY, true);
    }

    public static void setHardwareNoiseSuppressorEnabled(@NonNull Context context, boolean enable) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putBoolean(HNS_KEY, enable);
        editor.apply();
    }

    public static boolean isAcousticEchoCancelerEnabled(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getBoolean(AEC_KEY, true);
    }

    public static void setAcousticEchoCancelerEnabled(@NonNull Context context, boolean enable) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putBoolean(AEC_KEY, enable);
        editor.apply();
    }

    public static boolean isOpenSlESEnabled(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getBoolean(OPEN_SL_ES_KEY, true);
    }

    public static void setOpenSlESEnabled(@NonNull Context context, boolean enable) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putBoolean(OPEN_SL_ES_KEY, enable);
        editor.apply();
    }

    public static boolean isAudioProcessingEnabled(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getBoolean(AUDIO_PROCESSING_KEY, true);
    }

    public static void setAudioProcessingEnabled(@NonNull Context context, boolean enable) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putBoolean(AUDIO_PROCESSING_KEY, enable);
        editor.apply();
    }

    public static int getConnectionTimeout(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getInt(TIMEOUT_KEY, 30);
    }

    public static void setConnectionTimeout(@NonNull Context context, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkArgument((timeout >= 0 ? 1 : 0) != 0);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putInt(TIMEOUT_KEY, timeout);
        editor.apply();
    }

    public static int getSwarmTimeout(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getInt(SWARM_TIMEOUT_KEY, 5);
    }

    public static void setSwarmTimeout(@NonNull Context context, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkArgument((timeout >= 0 ? 1 : 0) != 0);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putInt(SWARM_TIMEOUT_KEY, timeout);
        editor.apply();
    }

    @NonNull
    public static CID getBitmap(@NonNull Context context, @NonNull String hash) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)hash);
        Preconditions.checkArgument((!hash.isEmpty() ? 1 : 0) != 0, (Object)"Hash is empty.");
        if (BITMAP_HASH_TABLE.containsKey(hash)) {
            CID stored = BITMAP_HASH_TABLE.get(hash);
            Preconditions.checkNotNull((Object)stored);
            return stored;
        }
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        Preconditions.checkNotNull((Object)ipfs, (Object)"IPFS is not valid.");
        MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
        try {
            BitMatrix bitMatrix = multiFormatWriter.encode(hash, BarcodeFormat.QR_CODE, 250, 250);
            BarcodeEncoder barcodeEncoder = new BarcodeEncoder();
            Bitmap bitmap = barcodeEncoder.createBitmap(bitMatrix);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
            byte[] bytes = stream.toByteArray();
            bitmap.recycle();
            CID cid = ipfs.storeData(bytes, true);
            Preconditions.checkNotNull((Object)cid);
            BITMAP_HASH_TABLE.put(hash, cid);
            return cid;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isMdnsEnabled(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getBoolean(MDNS_KEY, true);
    }

    public static void setMdnsEnabled(@NonNull Context context, boolean enable) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putBoolean(MDNS_KEY, enable);
        editor.apply();
    }

    public static boolean isAutoRelayEnabled(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getBoolean(ENABLE_AUTO_RELAY_KEY, false);
    }

    public static void setAutoRelayEnabled(@NonNull Context context, boolean enable) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putBoolean(ENABLE_AUTO_RELAY_KEY, enable);
        editor.apply();
    }

    public static boolean isQUICEnabled(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getBoolean(QUIC_KEY, false);
    }

    public static void setQUICEnabled(@NonNull Context context, boolean enable) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putBoolean(QUIC_KEY, enable);
        editor.apply();
    }

    public static boolean isPubsubEnabled(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getBoolean(PUBSUB_KEY, true);
    }

    public static void setPubsubEnabled(@NonNull Context context, boolean enable) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putBoolean(PUBSUB_KEY, enable);
        editor.apply();
    }

    @NonNull
    public static String getDate(@NonNull Date date) {
        Calendar c = Calendar.getInstance();
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date today = c.getTime();
        c.set(2, 0);
        c.set(5, 0);
        Date lastYear = c.getTime();
        if (date.before(today)) {
            if (date.before(lastYear)) {
                return DateFormat.format((CharSequence)"dd.MM.yyyy", (Date)date).toString();
            }
            return DateFormat.format((CharSequence)"dd.MMMM", (Date)date).toString();
        }
        return DateFormat.format((CharSequence)"HH:mm", (Date)date).toString();
    }

    @NonNull
    public static String getCompactString(@NonNull String title) {
        Preconditions.checkNotNull((Object)title);
        return title.replace("\n", " ");
    }

    public static void event(@NonNull THREADS threads, @NonNull String identifier, @NonNull String content) {
        Preconditions.checkNotNull((Object)threads);
        Preconditions.checkNotNull((Object)identifier);
        Preconditions.checkNotNull((Object)content);
        new Thread(() -> threads.invokeEvent(identifier, content)).start();
    }

    public static void error(@NonNull THREADS threads, @NonNull String message) {
        Preconditions.checkNotNull((Object)threads);
        Preconditions.checkNotNull((Object)message);
        Preferences.event(threads, EXCEPTION, message);
    }

    public static void warning(@NonNull THREADS threads, @NonNull String message) {
        Preconditions.checkNotNull((Object)threads);
        Preconditions.checkNotNull((Object)message);
        Preferences.event(threads, WARNING, message);
    }

    public static void info(@NonNull THREADS threads, @NonNull String message) {
        Preconditions.checkNotNull((Object)threads);
        Preconditions.checkNotNull((Object)message);
        Preferences.event(threads, INFO, message);
    }

    public static void evaluateException(@NonNull THREADS threads, @NonNull String eventKey, @NonNull Throwable e) {
        Preconditions.checkNotNull((Object)threads);
        Preconditions.checkNotNull((Object)eventKey);
        Preconditions.checkNotNull((Object)e);
        Preferences.event(threads, eventKey, "" + e.getLocalizedMessage());
    }

    @NonNull
    public static String getDefaultTopic(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getString(TOPIC_KEY, "pubsub");
    }

    public static void setDefaultTopic(@NonNull Context context, @NonNull String topic) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)topic);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putString(TOPIC_KEY, topic);
        editor.apply();
    }

    @NonNull
    public static CID getPIDBitmap(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        PID pid = Preferences.getPID(context);
        Preconditions.checkNotNull((Object)pid);
        String hash = pid.getPid();
        return Preferences.getBitmap(context, hash);
    }

    public static void setPID(@NonNull Context context, @NonNull PID pid) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)pid);
        Preconditions.checkArgument((!pid.getPid().isEmpty() ? 1 : 0) != 0);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putString(PID_KEY, pid.getPid());
        editor.apply();
    }

    public static void setSwarmPort(@NonNull Context context, int port) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putInt(SWARM_PORT_KEY, port);
        editor.apply();
    }

    public static int getSwarmPort(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getInt(SWARM_PORT_KEY, 4001);
    }

    @Nullable
    public static PID getPID(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        String pid = sharedPref.getString(PID_KEY, "");
        if (pid.isEmpty()) {
            return null;
        }
        return PID.create((String)pid);
    }

    public static boolean getIpfsSupport(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getBoolean(IPFS_KEY, false);
    }

    public static boolean getLoginFlag(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getBoolean(LOGIN_FLAG_KEY, false);
    }

    public static void setLoginFlag(@NonNull Context context, boolean login) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putBoolean(LOGIN_FLAG_KEY, login);
        editor.apply();
    }

    public static void setIpfsSupport(@NonNull Context context, boolean ipfs) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putBoolean(IPFS_KEY, ipfs);
        editor.apply();
    }

    public static boolean isAutoNATServiceEnabled(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getBoolean(NAT_SERVICE_KEY, false);
    }

    public static void setAutoNATServiceEnabled(@NonNull Context context, boolean natService) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putBoolean(NAT_SERVICE_KEY, natService);
        editor.apply();
    }

    public static boolean isRelayHopEnabled(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getBoolean(RELAY_HOP_KEY, false);
    }

    public static void setRelayHopEnabled(@NonNull Context context, boolean relayHop) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putBoolean(RELAY_HOP_KEY, relayHop);
        editor.apply();
    }

    public static PubsubConfig.RouterEnum getPubsubRouter(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return PubsubConfig.RouterEnum.valueOf((String)sharedPref.getString(ROUTER_ENUM_KEY, PubsubConfig.RouterEnum.floodsub.name()));
    }

    public static void setPubsubRouter(@NonNull Context context, @NonNull PubsubConfig.RouterEnum routerEnum) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)routerEnum);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putString(ROUTER_ENUM_KEY, routerEnum.name());
        editor.apply();
    }

    @NonNull
    public static RoutingConfig.TypeEnum getRoutingType(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return RoutingConfig.TypeEnum.valueOf((String)sharedPref.getString(ROUTING_TYPE_KEY, RoutingConfig.TypeEnum.dhtclient.name()));
    }

    public static void setRoutingType(@NonNull Context context, @NonNull RoutingConfig.TypeEnum routingType) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)routingType);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putString(ROUTING_TYPE_KEY, routingType.name());
        editor.apply();
    }

    @NonNull
    public static ConnMgrConfig.TypeEnum getConnMgrConfigType(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return ConnMgrConfig.TypeEnum.valueOf((String)sharedPref.getString(CONN_MGR_CONFIG_TYPE_KEY, ConnMgrConfig.TypeEnum.basic.name()));
    }

    public static void setConnMgrConfigType(@NonNull Context context, ConnMgrConfig.TypeEnum typeEnum) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)typeEnum);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putString(CONN_MGR_CONFIG_TYPE_KEY, typeEnum.name());
        editor.apply();
    }

    public static void setLowWater(@NonNull Context context, int lowWater) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkArgument((lowWater > 0 ? 1 : 0) != 0);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putInt(LOW_WATER_KEY, lowWater);
        editor.apply();
    }

    public static int getLowWater(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getInt(LOW_WATER_KEY, 20);
    }

    public static void setHighWater(@NonNull Context context, int highWater) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkArgument((highWater > 0 ? 1 : 0) != 0);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putInt(HIGH_WATER_KEY, highWater);
        editor.apply();
    }

    public static int getHighWater(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getInt(HIGH_WATER_KEY, 40);
    }

    @NonNull
    public static String getGracePeriod(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        return sharedPref.getString(GRACE_PERIOD_KEY, "30s");
    }

    public static void setGracePeriod(@NonNull Context context, @NonNull String gracePeriod) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)gracePeriod);
        SharedPreferences sharedPref = context.getSharedPreferences(PREF_KEY, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putString(GRACE_PERIOD_KEY, gracePeriod);
        editor.apply();
    }
}

