package threads.core.api;

import androidx.annotation.NonNull;
import androidx.room.TypeConverter;

import static androidx.core.util.Preconditions.checkNotNull;


public enum Status {
    OFFLINE(0),    // KIND::OUT note just created
    ONLINE(1),     // KIND::IN and KIND::OUT note is available for others
    SEEDING(2),    // KIND::IN and KIND::OUT note is available for others
    DELETING(3),   // KIND::IN and KIND::OUT note will be deleted
    EXPIRED(4),    // KIND::IN and KIND::OUT note is in status expired
    LEACHING(5),   // KIND::IN note will be loaded to IPFS
    ERROR(6);      // KIND::IN and KIND::OUT note is in error state
    @NonNull
    private final Integer code;

    Status(@NonNull Integer code) {
        checkNotNull(code);
        this.code = code;
    }

    @TypeConverter
    public static Status toStatus(Integer status) {
        checkNotNull(status);
        if (status.equals(Status.SEEDING.getCode())) {
            return Status.SEEDING;
        } else if (status.equals(Status.ONLINE.getCode())) {
            return Status.ONLINE;
        } else if (status.equals(Status.OFFLINE.getCode())) {
            return Status.OFFLINE;
        } else if (status.equals(Status.DELETING.getCode())) {
            return Status.DELETING;
        } else if (status.equals(Status.EXPIRED.getCode())) {
            return Status.EXPIRED;
        } else if (status.equals(Status.LEACHING.getCode())) {
            return Status.LEACHING;
        } else if (status.equals(Status.ERROR.getCode())) {
            return Status.ERROR;
        } else {
            throw new IllegalArgumentException("Could not recognize status");
        }
    }

    @TypeConverter
    public static Integer toInteger(Status status) {
        checkNotNull(status);
        return status.getCode();
    }

    @NonNull
    private Integer getCode() {
        return code;
    }
}
